/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;

public class TypeDeclarationLocator
extends PatternLocator {
    protected TypeDeclarationPattern pattern;

    public TypeDeclarationLocator(TypeDeclarationPattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    @Override
    public int match(TypeDeclaration node, MatchingNodeSet nodeSet) {
        if (this.matchesName(this.pattern.simpleName, node.name)) {
            return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    @Override
    public int match(InferredType node, MatchingNodeSet nodeSet) {
        int index;
        char[] typeName = node.getName();
        char[] patternName = this.pattern.getSearchPrefix() != null ? this.pattern.getSearchPrefix() : this.pattern.simpleName;
        if (this.matchesName(patternName, typeName)) {
            return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
        }
        char[] pkg = this.pattern.qualification;
        if (this.pattern.getSearchPrefix() == null && pkg != null ? pkg.length > 0 && this.matchesName(CharOperation.concat(pkg, this.pattern.simpleName, '.'), typeName) : (index = CharOperation.lastIndexOf('.', typeName)) >= 0 && this.matchesName(patternName, CharOperation.subarray(typeName, index + 1, typeName.length))) {
            return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    @Override
    public int resolveLevel(ASTNode node) {
        SourceTypeBinding binding = null;
        if (node instanceof TypeDeclaration) {
            binding = ((TypeDeclaration)node).binding;
        } else if (node instanceof InferredType) {
            InferredType type = (InferredType)node;
            if (!type.isDefinition() || !type.isIndexed()) {
                return 0;
            }
            binding = type.binding;
        } else {
            return 0;
        }
        return this.resolveLevel(binding);
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof TypeBinding)) {
            return 0;
        }
        TypeBinding type = (TypeBinding)binding;
        int resolveLevel = this.pattern.getSearchPrefix() != null ? this.resolveLevelUsingSearchPrefix(this.pattern.getSearchPrefix(), type) : this.resolveLevelForType(this.pattern.simpleName, this.pattern.qualification, type);
        return resolveLevel;
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern, char[] enclosingNamePattern, TypeBinding type) {
        if (enclosingNamePattern == null) {
            return this.resolveLevelForType(simpleNamePattern, qualificationPattern, type);
        }
        if (qualificationPattern == null) {
            return this.resolveLevelForType(simpleNamePattern, enclosingNamePattern, type);
        }
        if (type instanceof ProblemReferenceBinding) {
            return 0;
        }
        char[] fullQualificationPattern = CharOperation.concat(qualificationPattern, enclosingNamePattern, '.');
        if (CharOperation.equals(this.pattern.qualification, CharOperation.concatWith(type.getPackage().compoundName, '.'))) {
            return this.resolveLevelForType(simpleNamePattern, fullQualificationPattern, type);
        }
        return 0;
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }

    @Override
    public int matchMetadataElement(IJavaScriptElement element) {
        String elementName = element.getElementName();
        char[] typeName = elementName.toCharArray();
        char[] pkg = this.pattern.qualification;
        if (this.pattern.simpleName == null || this.matchesName(this.pattern.simpleName, typeName)) {
            return 3;
        }
        if (pkg != null && pkg.length > 0 && this.matchesName(CharOperation.concat(pkg, this.pattern.simpleName, '.'), typeName)) {
            return 3;
        }
        return 0;
    }
}

