/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.extractor;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.POIDocument;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hslf.model.Comment;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.model.OLEShape;
import org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import org.apache.poi.hslf.usermodel.HSLFNotes;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideMaster;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import org.apache.poi.hslf.usermodel.HSLFTable;
import org.apache.poi.hslf.usermodel.HSLFTableCell;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class PowerPointExtractor
extends POIOLE2TextExtractor {
    private HSLFSlideShowImpl _hslfshow;
    private HSLFSlideShow _show;
    private List<HSLFSlide> _slides;
    private boolean _slidesByDefault = true;
    private boolean _notesByDefault = false;
    private boolean _commentsByDefault = false;
    private boolean _masterByDefault = false;

    public static void main(String[] args) throws IOException {
        String file;
        if (args.length < 1) {
            System.err.println("Useage:");
            System.err.println("\tPowerPointExtractor [-notes] <file>");
            System.exit(1);
        }
        boolean notes = false;
        boolean comments = false;
        boolean master = true;
        if (args.length > 1) {
            notes = true;
            file = args[1];
            if (args.length > 2) {
                comments = true;
            }
        } else {
            file = args[0];
        }
        PowerPointExtractor ppe = new PowerPointExtractor(file);
        System.out.println(ppe.getText(true, notes, comments, master));
        ppe.close();
    }

    public PowerPointExtractor(String fileName) throws IOException {
        this(new NPOIFSFileSystem(new File(fileName)));
    }

    public PowerPointExtractor(InputStream iStream) throws IOException {
        this(new POIFSFileSystem(iStream));
    }

    public PowerPointExtractor(POIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public PowerPointExtractor(NPOIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
        this.setFilesystem((Closeable)fs);
    }

    public PowerPointExtractor(DirectoryNode dir) throws IOException {
        this(new HSLFSlideShowImpl(dir));
    }

    @Deprecated
    public PowerPointExtractor(DirectoryNode dir, POIFSFileSystem fs) throws IOException {
        this(new HSLFSlideShowImpl(dir, fs));
    }

    public PowerPointExtractor(HSLFSlideShowImpl ss) {
        super((POIDocument)ss);
        this._hslfshow = ss;
        this._show = new HSLFSlideShow(this._hslfshow);
        this._slides = this._show.getSlides();
    }

    public void setSlidesByDefault(boolean slidesByDefault) {
        this._slidesByDefault = slidesByDefault;
    }

    public void setNotesByDefault(boolean notesByDefault) {
        this._notesByDefault = notesByDefault;
    }

    public void setCommentsByDefault(boolean commentsByDefault) {
        this._commentsByDefault = commentsByDefault;
    }

    public void setMasterByDefault(boolean masterByDefault) {
        this._masterByDefault = masterByDefault;
    }

    public String getText() {
        return this.getText(this._slidesByDefault, this._notesByDefault, this._commentsByDefault, this._masterByDefault);
    }

    public String getNotes() {
        return this.getText(false, true);
    }

    public List<OLEShape> getOLEShapes() {
        ArrayList<OLEShape> list = new ArrayList<OLEShape>();
        for (HSLFSlide slide : this._slides) {
            for (HSLFShape shape : slide.getShapes()) {
                if (!(shape instanceof OLEShape)) continue;
                list.add((OLEShape)shape);
            }
        }
        return list;
    }

    public String getText(boolean getSlideText, boolean getNoteText) {
        return this.getText(getSlideText, getNoteText, this._commentsByDefault, this._masterByDefault);
    }

    public String getText(boolean getSlideText, boolean getNoteText, boolean getCommentText, boolean getMasterText) {
        StringBuffer ret = new StringBuffer();
        if (getSlideText) {
            if (getMasterText) {
                for (HSLFSlideMaster master : this._show.getSlideMasters()) {
                    for (HSLFShape sh : master.getShapes()) {
                        HSLFTextShape tsh;
                        String text;
                        if (!(sh instanceof HSLFTextShape) || HSLFMasterSheet.isPlaceholder(sh) || (text = (tsh = (HSLFTextShape)sh).getText()) == null) continue;
                        ret.append(text);
                        if (text.endsWith("\n")) continue;
                        ret.append("\n");
                    }
                }
            }
            for (HSLFSlide slide : this._slides) {
                String headerText = "";
                String footerText = "";
                HeadersFooters hf = slide.getHeadersFooters();
                if (hf != null) {
                    if (hf.isHeaderVisible()) {
                        headerText = PowerPointExtractor.safeLine(hf.getHeaderText());
                    }
                    if (hf.isFooterVisible()) {
                        footerText = PowerPointExtractor.safeLine(hf.getFooterText());
                    }
                }
                ret.append(headerText);
                this.textRunsToText(ret, slide.getTextParagraphs());
                for (HSLFShape shape : slide.getShapes()) {
                    if (!(shape instanceof HSLFTable)) continue;
                    this.extractTableText(ret, (HSLFTable)shape);
                }
                ret.append(footerText);
                if (!getCommentText) continue;
                Comment[] comments = slide.getComments();
                for (int j = 0; j < comments.length; ++j) {
                    ret.append(comments[j].getAuthor() + " - " + comments[j].getText() + "\n");
                }
            }
            if (getNoteText) {
                ret.append("\n");
            }
        }
        if (getNoteText) {
            HashSet<Integer> seenNotes = new HashSet<Integer>();
            String headerText = "";
            String footerText = "";
            HeadersFooters hf = this._show.getNotesHeadersFooters();
            if (hf != null) {
                if (hf.isHeaderVisible()) {
                    headerText = PowerPointExtractor.safeLine(hf.getHeaderText());
                }
                if (hf.isFooterVisible()) {
                    footerText = PowerPointExtractor.safeLine(hf.getFooterText());
                }
            }
            for (int i = 0; i < this._slides.size(); ++i) {
                Integer id;
                HSLFNotes notes = this._slides.get(i).getNotes();
                if (notes == null || seenNotes.contains(id = Integer.valueOf(notes._getSheetNumber()))) continue;
                seenNotes.add(id);
                ret.append(headerText);
                this.textRunsToText(ret, notes.getTextParagraphs());
                ret.append(footerText);
            }
        }
        return ret.toString();
    }

    private static String safeLine(String text) {
        return text == null ? "" : text + '\n';
    }

    private void extractTableText(StringBuffer ret, HSLFTable table) {
        for (int row = 0; row < table.getNumberOfRows(); ++row) {
            for (int col = 0; col < table.getNumberOfColumns(); ++col) {
                HSLFTableCell cell = table.getCell(row, col);
                if (cell == null) continue;
                String txt = cell.getText();
                txt = txt == null ? "" : txt;
                ret.append(txt);
                if (col >= table.getNumberOfColumns() - 1) continue;
                ret.append("\t");
            }
            ret.append('\n');
        }
    }

    private void textRunsToText(StringBuffer ret, List<List<HSLFTextParagraph>> paragraphs) {
        if (paragraphs == null) {
            return;
        }
        for (List<HSLFTextParagraph> lp : paragraphs) {
            ret.append(HSLFTextParagraph.getText(lp));
            if (ret.length() <= 0 || ret.charAt(ret.length() - 1) == '\n') continue;
            ret.append("\n");
        }
    }
}

