/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.api.TypeReference;
import com.sun.xml.internal.ws.api.databinding.MetadataReader;
import com.sun.xml.internal.ws.api.model.JavaMethod;
import com.sun.xml.internal.ws.api.model.MEP;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.soap.SOAPBinding;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.CheckedExceptionImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.model.soap.SOAPBindingImpl;
import com.sun.xml.internal.ws.spi.db.TypeInfo;
import com.sun.xml.internal.ws.wsdl.ActionBasedOperationSignature;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;
import javax.xml.ws.WebServiceException;

public final class JavaMethodImpl
implements JavaMethod {
    private String inputAction = "";
    private String outputAction = "";
    private final List<CheckedExceptionImpl> exceptions = new ArrayList<CheckedExceptionImpl>();
    private final Method method;
    final List<ParameterImpl> requestParams = new ArrayList<ParameterImpl>();
    final List<ParameterImpl> responseParams = new ArrayList<ParameterImpl>();
    private final List<ParameterImpl> unmReqParams = Collections.unmodifiableList(this.requestParams);
    private final List<ParameterImpl> unmResParams = Collections.unmodifiableList(this.responseParams);
    private SOAPBinding binding;
    private MEP mep;
    private QName operationName;
    private WSDLBoundOperation wsdlOperation;
    final AbstractSEIModelImpl owner;
    private final Method seiMethod;
    private QName requestPayloadName;
    private String soapAction;
    private static final Logger LOGGER = Logger.getLogger(JavaMethodImpl.class.getName());

    public JavaMethodImpl(AbstractSEIModelImpl abstractSEIModelImpl, Method method, Method method2, MetadataReader metadataReader) {
        this.owner = abstractSEIModelImpl;
        this.method = method;
        this.seiMethod = method2;
        this.setWsaActions(metadataReader);
    }

    private void setWsaActions(MetadataReader metadataReader) {
        Action action;
        Action action2 = action = metadataReader != null ? metadataReader.getAnnotation(Action.class, this.seiMethod) : this.seiMethod.getAnnotation(Action.class);
        if (action != null) {
            this.inputAction = action.input();
            this.outputAction = action.output();
        }
        WebMethod webMethod = metadataReader != null ? metadataReader.getAnnotation(WebMethod.class, this.seiMethod) : this.seiMethod.getAnnotation(WebMethod.class);
        this.soapAction = "";
        if (webMethod != null) {
            this.soapAction = webMethod.action();
        }
        if (!this.soapAction.equals("")) {
            if (this.inputAction.equals("")) {
                this.inputAction = this.soapAction;
            } else if (!this.inputAction.equals(this.soapAction)) {
                // empty if block
            }
        }
    }

    public ActionBasedOperationSignature getOperationSignature() {
        QName qName = this.getRequestPayloadName();
        if (qName == null) {
            qName = new QName("", "");
        }
        return new ActionBasedOperationSignature(this.getInputAction(), qName);
    }

    @Override
    public SEIModel getOwner() {
        return this.owner;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Method getSEIMethod() {
        return this.seiMethod;
    }

    @Override
    public MEP getMEP() {
        return this.mep;
    }

    void setMEP(MEP mEP) {
        this.mep = mEP;
    }

    @Override
    public SOAPBinding getBinding() {
        if (this.binding == null) {
            return new SOAPBindingImpl();
        }
        return this.binding;
    }

    void setBinding(SOAPBinding sOAPBinding) {
        this.binding = sOAPBinding;
    }

    public WSDLBoundOperation getOperation() {
        return this.wsdlOperation;
    }

    public void setOperationQName(QName qName) {
        this.operationName = qName;
    }

    public QName getOperationQName() {
        return this.wsdlOperation != null ? this.wsdlOperation.getName() : this.operationName;
    }

    public String getSOAPAction() {
        return this.wsdlOperation != null ? this.wsdlOperation.getSOAPAction() : this.soapAction;
    }

    @Override
    public String getOperationName() {
        return this.operationName.getLocalPart();
    }

    @Override
    public String getRequestMessageName() {
        return this.getOperationName();
    }

    @Override
    public String getResponseMessageName() {
        if (this.mep.isOneWay()) {
            return null;
        }
        return this.getOperationName() + "Response";
    }

    public void setRequestPayloadName(QName qName) {
        this.requestPayloadName = qName;
    }

    @Override
    @Nullable
    public QName getRequestPayloadName() {
        return this.wsdlOperation != null ? this.wsdlOperation.getRequestPayloadName() : this.requestPayloadName;
    }

    @Override
    @Nullable
    public QName getResponsePayloadName() {
        return this.mep == MEP.ONE_WAY ? null : this.wsdlOperation.getResponsePayloadName();
    }

    public List<ParameterImpl> getRequestParameters() {
        return this.unmReqParams;
    }

    public List<ParameterImpl> getResponseParameters() {
        return this.unmResParams;
    }

    void addParameter(ParameterImpl parameterImpl) {
        if (parameterImpl.isIN() || parameterImpl.isINOUT()) {
            assert (!this.requestParams.contains(parameterImpl));
            this.requestParams.add(parameterImpl);
        }
        if (parameterImpl.isOUT() || parameterImpl.isINOUT()) {
            assert (!this.responseParams.contains(parameterImpl));
            this.responseParams.add(parameterImpl);
        }
    }

    void addRequestParameter(ParameterImpl parameterImpl) {
        if (parameterImpl.isIN() || parameterImpl.isINOUT()) {
            this.requestParams.add(parameterImpl);
        }
    }

    void addResponseParameter(ParameterImpl parameterImpl) {
        if (parameterImpl.isOUT() || parameterImpl.isINOUT()) {
            this.responseParams.add(parameterImpl);
        }
    }

    public int getInputParametersCount() {
        int n = 0;
        for (ParameterImpl parameterImpl : this.requestParams) {
            if (parameterImpl.isWrapperStyle()) {
                n += ((WrapperParameter)parameterImpl).getWrapperChildren().size();
                continue;
            }
            ++n;
        }
        for (ParameterImpl parameterImpl : this.responseParams) {
            if (parameterImpl.isWrapperStyle()) {
                for (ParameterImpl parameterImpl2 : ((WrapperParameter)parameterImpl).getWrapperChildren()) {
                    if (parameterImpl2.isResponse() || !parameterImpl2.isOUT()) continue;
                    ++n;
                }
                continue;
            }
            if (parameterImpl.isResponse() || !parameterImpl.isOUT()) continue;
            ++n;
        }
        return n;
    }

    void addException(CheckedExceptionImpl checkedExceptionImpl) {
        if (!this.exceptions.contains(checkedExceptionImpl)) {
            this.exceptions.add(checkedExceptionImpl);
        }
    }

    public CheckedExceptionImpl getCheckedException(Class clazz) {
        for (CheckedExceptionImpl checkedExceptionImpl : this.exceptions) {
            if (checkedExceptionImpl.getExceptionClass() != clazz) continue;
            return checkedExceptionImpl;
        }
        return null;
    }

    public List<CheckedExceptionImpl> getCheckedExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public String getInputAction() {
        return this.inputAction;
    }

    public String getOutputAction() {
        return this.outputAction;
    }

    public CheckedExceptionImpl getCheckedException(TypeReference typeReference) {
        for (CheckedExceptionImpl checkedExceptionImpl : this.exceptions) {
            TypeInfo typeInfo = checkedExceptionImpl.getDetailType();
            if (!typeInfo.tagName.equals(typeReference.tagName) || typeInfo.type != typeReference.type) continue;
            return checkedExceptionImpl;
        }
        return null;
    }

    public boolean isAsync() {
        return this.mep.isAsync;
    }

    void freeze(WSDLPort wSDLPort) {
        this.wsdlOperation = wSDLPort.getBinding().get(new QName(wSDLPort.getBinding().getPortType().getName().getNamespaceURI(), this.getOperationName()));
        if (this.wsdlOperation == null) {
            throw new WebServiceException("Method " + this.seiMethod.getName() + " is exposed as WebMethod, but there is no corresponding wsdl operation with name " + this.operationName + " in the wsdl:portType" + wSDLPort.getBinding().getPortType().getName());
        }
        if (this.inputAction.equals("")) {
            this.inputAction = this.wsdlOperation.getOperation().getInput().getAction();
        } else if (!this.inputAction.equals(this.wsdlOperation.getOperation().getInput().getAction())) {
            LOGGER.warning("Input Action on WSDL operation " + this.wsdlOperation.getName().getLocalPart() + " and @Action on its associated Web Method " + this.seiMethod.getName() + " did not match and will cause problems in dispatching the requests");
        }
        if (!this.mep.isOneWay()) {
            if (this.outputAction.equals("")) {
                this.outputAction = this.wsdlOperation.getOperation().getOutput().getAction();
            }
            for (CheckedExceptionImpl checkedExceptionImpl : this.exceptions) {
                if (!checkedExceptionImpl.getFaultAction().equals("")) continue;
                QName qName = checkedExceptionImpl.getDetailType().tagName;
                WSDLFault wSDLFault = this.wsdlOperation.getOperation().getFault(qName);
                if (wSDLFault == null) {
                    LOGGER.warning("Mismatch between Java model and WSDL model found, For wsdl operation " + this.wsdlOperation.getName() + ",There is no matching wsdl fault with detail QName " + checkedExceptionImpl.getDetailType().tagName);
                    checkedExceptionImpl.setFaultAction(checkedExceptionImpl.getDefaultFaultAction());
                    continue;
                }
                checkedExceptionImpl.setFaultAction(wSDLFault.getAction());
            }
        }
    }

    final void fillTypes(List<TypeInfo> list) {
        this.fillTypes(this.requestParams, list);
        this.fillTypes(this.responseParams, list);
        for (CheckedExceptionImpl checkedExceptionImpl : this.exceptions) {
            list.add(checkedExceptionImpl.getDetailType());
        }
    }

    private void fillTypes(List<ParameterImpl> list, List<TypeInfo> list2) {
        for (ParameterImpl parameterImpl : list) {
            parameterImpl.fillTypes(list2);
        }
    }
}

