/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.IStackTraceInfo;
import java.util.Comparator;

public class AllocationInfo
implements IStackTraceInfo {
    private final String mAllocatedClass;
    private final int mAllocNumber;
    private final int mAllocationSize;
    private final short mThreadId;
    private final StackTraceElement[] mStackTrace;

    AllocationInfo(int allocNumber, String allocatedClass, int allocationSize, short threadId, StackTraceElement[] stackTrace) {
        this.mAllocNumber = allocNumber;
        this.mAllocatedClass = allocatedClass;
        this.mAllocationSize = allocationSize;
        this.mThreadId = threadId;
        this.mStackTrace = stackTrace;
    }

    public int getAllocNumber() {
        return this.mAllocNumber;
    }

    public String getAllocatedClass() {
        return this.mAllocatedClass;
    }

    public int getSize() {
        return this.mAllocationSize;
    }

    public short getThreadId() {
        return this.mThreadId;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.mStackTrace;
    }

    public int compareTo(AllocationInfo otherAlloc) {
        return otherAlloc.mAllocationSize - this.mAllocationSize;
    }

    public String getFirstTraceClassName() {
        if (this.mStackTrace.length > 0) {
            return this.mStackTrace[0].getClassName();
        }
        return null;
    }

    public String getFirstTraceMethodName() {
        if (this.mStackTrace.length > 0) {
            return this.mStackTrace[0].getMethodName();
        }
        return null;
    }

    public boolean filter(String filter, boolean fullTrace) {
        if (this.mAllocatedClass.toLowerCase().contains(filter)) {
            return true;
        }
        if (this.mStackTrace.length > 0) {
            int length = fullTrace ? this.mStackTrace.length : 1;
            int i = 0;
            while (i < length) {
                if (this.mStackTrace[i].getClassName().toLowerCase().contains(filter)) {
                    return true;
                }
                if (this.mStackTrace[i].getMethodName().toLowerCase().contains(filter)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static final class AllocationSorter
    implements Comparator<AllocationInfo> {
        private SortMode mSortMode = SortMode.SIZE;
        private boolean mDescending = true;

        public void setSortMode(SortMode mode) {
            if (this.mSortMode == mode) {
                this.mDescending = !this.mDescending;
            } else {
                this.mSortMode = mode;
            }
        }

        public SortMode getSortMode() {
            return this.mSortMode;
        }

        public boolean isDescending() {
            return this.mDescending;
        }

        @Override
        public int compare(AllocationInfo o1, AllocationInfo o2) {
            int diff = 0;
            switch (this.mSortMode) {
                case NUMBER: {
                    diff = o1.mAllocNumber - o2.mAllocNumber;
                    break;
                }
                case SIZE: {
                    break;
                }
                case CLASS: {
                    diff = o1.mAllocatedClass.compareTo(o2.mAllocatedClass);
                    break;
                }
                case THREAD: {
                    diff = o1.mThreadId - o2.mThreadId;
                    break;
                }
                case IN_CLASS: {
                    String class1 = o1.getFirstTraceClassName();
                    String class2 = o2.getFirstTraceClassName();
                    diff = this.compareOptionalString(class1, class2);
                    break;
                }
                case IN_METHOD: {
                    String method1 = o1.getFirstTraceMethodName();
                    String method2 = o2.getFirstTraceMethodName();
                    diff = this.compareOptionalString(method1, method2);
                }
            }
            if (diff == 0) {
                diff = o1.mAllocationSize - o2.mAllocationSize;
            }
            if (this.mDescending) {
                diff = -diff;
            }
            return diff;
        }

        private int compareOptionalString(String str1, String str2) {
            if (str1 != null) {
                if (str2 == null) {
                    return -1;
                }
                return str1.compareTo(str2);
            }
            if (str2 == null) {
                return 0;
            }
            return 1;
        }
    }

    public static enum SortMode {
        NUMBER,
        SIZE,
        CLASS,
        THREAD,
        IN_CLASS,
        IN_METHOD;

    }
}

