/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.wrapper.images;

import boofcv.core.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageType;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class JpegByteImageSequence<T extends ImageBase>
implements SimpleImageSequence<T> {
    int index;
    List<byte[]> jpegData = new ArrayList<byte[]>();
    ImageType<T> imageType;
    BufferedImage imageGUI;
    T output;
    boolean loop = false;
    boolean forward = true;

    public JpegByteImageSequence(ImageType<T> imageType, List<byte[]> jpegData, boolean loop) {
        this.imageType = imageType;
        this.jpegData = jpegData;
        this.loop = loop;
        this.output = imageType.createImage(1, 1);
    }

    public JpegByteImageSequence(Class<T> imageType, List<byte[]> jpegData, boolean loop) {
        this.imageType = new ImageType(ImageType.Family.SINGLE_BAND, ImageDataType.classToType(imageType), 1);
        this.jpegData = jpegData;
        this.loop = loop;
        this.output = this.imageType.createImage(1, 1);
    }

    @Override
    public boolean hasNext() {
        if (this.loop) {
            return true;
        }
        return this.index < this.jpegData.size();
    }

    @Override
    public T next() {
        try {
            this.imageGUI = ImageIO.read(new ByteArrayInputStream(this.jpegData.get(this.index)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.forward) {
            ++this.index;
            if (this.loop && this.index >= this.jpegData.size()) {
                this.index = this.jpegData.size() - 1;
                this.forward = false;
            }
        } else {
            --this.index;
            if (this.loop && this.index < 0) {
                this.index = 1;
                this.forward = true;
            }
        }
        this.output.reshape(this.imageGUI.getWidth(), this.imageGUI.getHeight());
        ConvertBufferedImage.convertFrom((BufferedImage)this.imageGUI, this.output, (boolean)true);
        return this.output;
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Override
    public BufferedImage getGuiImage() {
        return this.imageGUI;
    }

    @Override
    public void close() {
    }

    @Override
    public int getFrameNumber() {
        return this.index;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public void reset() {
        this.index = 0;
        this.forward = true;
    }
}

