/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.alg.feature.detect.line.LineImageOps;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class ImageLinePanel
extends JPanel {
    public BufferedImage background;
    public List<LineSegment2D_F32> lines = new ArrayList<LineSegment2D_F32>();

    public synchronized void setBackground(BufferedImage background) {
        this.background = background;
    }

    public synchronized void setLines(List<LineParametric2D_F32> lines) {
        this.lines.clear();
        for (LineParametric2D_F32 p : lines) {
            this.lines.add(LineImageOps.convert((LineParametric2D_F32)p, (int)this.background.getWidth(), (int)this.background.getHeight()));
        }
    }

    public synchronized void setLineSegments(List<LineSegment2D_F32> lines) {
        this.lines.clear();
        this.lines.addAll(lines);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        double scaleY;
        super.paintComponent(g);
        if (this.background == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        int w = this.background.getWidth();
        int h = this.background.getHeight();
        double scaleX = (double)this.getWidth() / (double)w;
        double scale = Math.min(scaleX, scaleY = (double)this.getHeight() / (double)h);
        if (scale > 1.0) {
            scale = 1.0;
        }
        g2.drawImage(this.background, 0, 0, (int)(scale * (double)w), (int)(scale * (double)h), 0, 0, w, h, null);
        g2.setStroke(new BasicStroke(3.0f));
        for (LineSegment2D_F32 s : this.lines) {
            g2.setColor(Color.RED);
            g2.drawLine((int)(scale * (double)s.a.x), (int)(scale * (double)s.a.y), (int)(scale * (double)s.b.x), (int)(scale * (double)s.b.y));
            g2.setColor(Color.BLUE);
            g2.fillOval((int)(scale * (double)s.a.x) - 1, (int)(scale * (double)s.a.y) - 1, 3, 3);
            g2.fillOval((int)(scale * (double)s.b.x) - 1, (int)(scale * (double)s.b.y) - 1, 3, 3);
        }
    }
}

