/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.EllipseRotated_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.util.List;

public class VisualizeShapes {
    public static void draw(Quadrilateral_F64 quad, Graphics2D g2) {
        VisualizeShapes.draw(quad.a, quad.b, g2);
        VisualizeShapes.draw(quad.b, quad.c, g2);
        VisualizeShapes.draw(quad.c, quad.d, g2);
        VisualizeShapes.draw(quad.d, quad.a, g2);
    }

    public static void draw(Point2D_F64 p0, Point2D_F64 p1, Graphics2D g2) {
        g2.drawLine((int)(p0.x + 0.5), (int)(p0.y + 0.5), (int)(p1.x + 0.5), (int)(p1.y + 0.5));
    }

    public static <T extends Point2D_I32> void drawPolygon(List<T> vertexes, boolean loop, Graphics2D g2) {
        for (int i = 0; i < vertexes.size() - 1; ++i) {
            Point2D_I32 p0 = (Point2D_I32)vertexes.get(i);
            Point2D_I32 p1 = (Point2D_I32)vertexes.get(i + 1);
            g2.drawLine(p0.x, p0.y, p1.x, p1.y);
        }
        if (loop && vertexes.size() > 0) {
            Point2D_I32 p0 = (Point2D_I32)vertexes.get(0);
            Point2D_I32 p1 = (Point2D_I32)vertexes.get(vertexes.size() - 1);
            g2.drawLine(p0.x, p0.y, p1.x, p1.y);
        }
    }

    public static void drawEllipse(EllipseRotated_F64 ellipse, Graphics2D g2) {
        AffineTransform rotate = new AffineTransform();
        rotate.rotate(ellipse.phi);
        double w = ellipse.a * 2.0;
        double h = ellipse.b * 2.0;
        Shape shape = rotate.createTransformedShape(new Ellipse2D.Double(-w / 2.0, -h / 2.0, w, h));
        shape = AffineTransform.getTranslateInstance(ellipse.center.x, ellipse.center.y).createTransformedShape(shape);
        g2.draw(shape);
    }
}

