/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.fiducial;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.IntrinsicParameters;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

public class VisualizeFiducial {
    public static void drawCube(Se3_F64 targetToCamera, IntrinsicParameters intrinsic, double width, Graphics2D g2) {
        double r = width / 2.0;
        Point3D_F64[] corners = new Point3D_F64[]{new Point3D_F64(-r, -r, 0.0), new Point3D_F64(r, -r, 0.0), new Point3D_F64(r, r, 0.0), new Point3D_F64(-r, r, 0.0), new Point3D_F64(-r, -r, r), new Point3D_F64(r, -r, r), new Point3D_F64(r, r, r), new Point3D_F64(-r, r, r)};
        Point2D_I32[] pixel = new Point2D_I32[8];
        Point2D_F64 p = new Point2D_F64();
        for (int i = 0; i < 8; ++i) {
            Point3D_F64 c = corners[i];
            SePointOps_F64.transform((Se3_F64)targetToCamera, (Point3D_F64)c, (Point3D_F64)c);
            PerspectiveOps.convertNormToPixel((IntrinsicParameters)intrinsic, (double)(c.x / c.z), (double)(c.y / c.z), (Point2D_F64)p);
            pixel[i] = new Point2D_I32((int)(p.x + 0.5), (int)(p.y + 0.5));
        }
        g2.setStroke(new BasicStroke(4.0f));
        g2.setColor(Color.RED);
        g2.drawLine(pixel[0].x, pixel[0].y, pixel[1].x, pixel[1].y);
        g2.drawLine(pixel[1].x, pixel[1].y, pixel[2].x, pixel[2].y);
        g2.drawLine(pixel[2].x, pixel[2].y, pixel[3].x, pixel[3].y);
        g2.drawLine(pixel[3].x, pixel[3].y, pixel[0].x, pixel[0].y);
        g2.setColor(Color.BLACK);
        g2.drawLine(pixel[0].x, pixel[0].y, pixel[4].x, pixel[4].y);
        g2.drawLine(pixel[1].x, pixel[1].y, pixel[5].x, pixel[5].y);
        g2.drawLine(pixel[2].x, pixel[2].y, pixel[6].x, pixel[6].y);
        g2.drawLine(pixel[3].x, pixel[3].y, pixel[7].x, pixel[7].y);
        g2.setColor(new Color(0, 255, 0, 125));
        g2.drawLine(pixel[4].x, pixel[4].y, pixel[5].x, pixel[5].y);
        g2.setColor(new Color(192, 16, 192, 125));
        g2.drawLine(pixel[5].x, pixel[5].y, pixel[6].x, pixel[6].y);
        g2.setColor(new Color(0, 160, 192, 125));
        g2.drawLine(pixel[6].x, pixel[6].y, pixel[7].x, pixel[7].y);
        g2.setColor(Color.BLUE);
        g2.drawLine(pixel[7].x, pixel[7].y, pixel[4].x, pixel[4].y);
    }
}

