/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.struct.image.ImageSInt32;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.JPanel;

public class ImageBinaryLabeledPanel
extends JPanel
implements MouseListener {
    protected BufferedImage img;
    protected ImageSInt32 labelImage;
    int[] colors;

    public ImageBinaryLabeledPanel(ImageSInt32 labelImage, int maxValues, long randSeed) {
        this();
        this.labelImage = labelImage;
        this.img = new BufferedImage(labelImage.getWidth(), labelImage.getHeight(), 1);
        this.setPreferredSize(new Dimension(labelImage.getWidth(), labelImage.getHeight()));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        Random rand = new Random(randSeed);
        this.colors = BinaryImageOps.selectRandomColors((int)maxValues, (Random)rand);
        VisualizeBinaryData.renderLabeled(labelImage, this.colors, this.img);
    }

    protected ImageBinaryLabeledPanel() {
        this.addMouseListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, this);
        }
    }

    public void setImage(ImageSInt32 binaryImage) {
        this.labelImage = binaryImage;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.labelImage.isInBounds(e.getX(), e.getY())) {
            int val = this.labelImage.get(e.getX(), e.getY());
            System.out.println("Label at (" + e.getX() + "," + e.getY() + ") = " + val);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

