/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.alg.misc.ImageStatistics;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.gui.image.ImageGridPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.VisualizeImageData;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ShowImages {
    public static void showDialog(BufferedImage img) {
        ImageIcon icon = new ImageIcon();
        icon.setImage(img);
        JOptionPane.showMessageDialog(null, icon);
    }

    public static ImageGridPanel showGrid(int numColumns, String title, BufferedImage ... images) {
        JFrame frame = new JFrame(title);
        ImageGridPanel panel = new ImageGridPanel(images.length / numColumns, numColumns, images);
        frame.add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
        return panel;
    }

    public static ImagePanel showWindow(BufferedImage img, String title) {
        JFrame frame = new JFrame(title);
        ImagePanel panel = new ImagePanel(img);
        frame.add((Component)panel, "Center");
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
        return panel;
    }

    public static ImagePanel showWindow(ImageUInt8 img, String title) {
        BufferedImage buff = ConvertBufferedImage.convertTo((ImageUInt8)img, null);
        return ShowImages.showWindow(buff, title);
    }

    public static ImagePanel showWindow(ImageSInt16 img, String title) {
        int max = ImageStatistics.maxAbs((ImageSInt16)img);
        BufferedImage buff = img.getDataType().isSigned() ? VisualizeImageData.colorizeSign((ImageSingleBand)img, null, (double)max) : VisualizeImageData.grayUnsigned((ImageInteger)img, null, max);
        return ShowImages.showWindow(buff, title);
    }

    public static ImagePanel showWindow(ImageFloat32 img, String title, boolean showMagnitude) {
        float max = ImageStatistics.maxAbs((ImageFloat32)img);
        BufferedImage buff = showMagnitude ? VisualizeImageData.grayMagnitude((ImageSingleBand)img, null, (double)max) : VisualizeImageData.colorizeSign((ImageSingleBand)img, null, (double)max);
        return ShowImages.showWindow(buff, title);
    }

    public static JFrame showWindow(JComponent component, String title) {
        final JFrame frame = new JFrame(title);
        frame.add((Component)component, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.pack();
                frame.setVisible(true);
            }
        });
        return frame;
    }
}

