/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.plane;

import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;

public class FitPlane3D_F64 {
    SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)3, (int)10, (boolean)false, (boolean)true, (boolean)false);
    DenseMatrix64F A = new DenseMatrix64F(3, 3);
    DenseMatrix64F V = new DenseMatrix64F(3, 3);

    public boolean svd(List<Point3D_F64> points, Point3D_F64 outputCenter, Vector3D_F64 outputNormal) {
        int N = points.size();
        outputCenter.set(0.0, 0.0, 0.0);
        for (int i = 0; i < N; ++i) {
            Point3D_F64 p = points.get(i);
            outputCenter.x += p.x;
            outputCenter.y += p.y;
            outputCenter.z += p.z;
        }
        outputCenter.x /= (double)N;
        outputCenter.y /= (double)N;
        outputCenter.z /= (double)N;
        return this.svdPoint(points, outputCenter, outputNormal);
    }

    public boolean svdPoint(List<Point3D_F64> points, Point3D_F64 pointOnPlane, Vector3D_F64 outputNormal) {
        int N = points.size();
        this.A.reshape(N, 3);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            Point3D_F64 p = points.get(i);
            this.A.data[index++] = p.x - pointOnPlane.x;
            this.A.data[index++] = p.y - pointOnPlane.y;
            this.A.data[index++] = p.z - pointOnPlane.z;
        }
        if (!this.svd.decompose((Matrix64F)this.A)) {
            return false;
        }
        double[] sv = this.svd.getSingularValues();
        int smallestIndex = -1;
        double smallestValue = Double.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            double v = sv[i];
            if (!(v < smallestValue)) continue;
            smallestValue = v;
            smallestIndex = i;
        }
        this.svd.getV((Matrix64F)this.V, true);
        outputNormal.x = this.V.unsafe_get(smallestIndex, 0);
        outputNormal.y = this.V.unsafe_get(smallestIndex, 1);
        outputNormal.z = this.V.unsafe_get(smallestIndex, 2);
        return true;
    }
}

