/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.metric.ClosestPoint3D_F32;
import georegression.struct.plane.PlaneGeneral3D_F32;
import georegression.struct.plane.PlaneNormal3D_F32;
import georegression.struct.plane.PlaneTangent3D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.Se3_F32;
import org.ejml.data.DenseMatrix64F;

public class UtilPlane3D_F32 {
    public static PlaneGeneral3D_F32 convert(PlaneNormal3D_F32 input, PlaneGeneral3D_F32 output) {
        if (output == null) {
            output = new PlaneGeneral3D_F32();
        }
        Vector3D_F32 n = input.n;
        Point3D_F32 p = input.p;
        output.A = n.x;
        output.B = n.y;
        output.C = n.z;
        output.D = n.x * p.x + n.y * p.y + n.z * p.z;
        return output;
    }

    public static PlaneNormal3D_F32 convert(PlaneGeneral3D_F32 input, PlaneNormal3D_F32 output) {
        if (output == null) {
            output = new PlaneNormal3D_F32();
        }
        float top = -input.D;
        float n2 = input.A * input.A + input.B * input.B + input.C * input.C;
        output.p.x = -input.A * top / n2;
        output.p.y = -input.B * top / n2;
        output.p.z = -input.C * top / n2;
        output.n.set(input.A, input.B, input.C);
        return output;
    }

    public static PlaneNormal3D_F32 convert(PlaneTangent3D_F32 input, PlaneNormal3D_F32 output) {
        if (output == null) {
            output = new PlaneNormal3D_F32();
        }
        output.n.x = input.x;
        output.n.y = input.y;
        output.n.z = input.z;
        output.p.set(input);
        return output;
    }

    public static void hessianNormalForm(PlaneGeneral3D_F32 plane) {
        float n = (float)Math.sqrt(plane.A * plane.A + plane.B * plane.B + plane.C * plane.C);
        plane.A /= n;
        plane.B /= n;
        plane.C /= n;
        plane.D /= n;
    }

    public static float evaluate(PlaneGeneral3D_F32 plane, Point3D_F32 point) {
        return plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
    }

    public static float evaluate(PlaneNormal3D_F32 plane, Point3D_F32 point) {
        float dx = point.x - plane.p.x;
        float dy = point.y - plane.p.y;
        float dz = point.z - plane.p.z;
        return plane.n.x * dx + plane.n.y * dy + plane.n.z * dz;
    }

    public static boolean equals(PlaneNormal3D_F32 a, PlaneNormal3D_F32 b, float tol) {
        PlaneGeneral3D_F32 genA = UtilPlane3D_F32.convert(a, null);
        PlaneGeneral3D_F32 genB = UtilPlane3D_F32.convert(b, null);
        float normA = (float)Math.sqrt(genA.A * genA.A + genA.B * genA.B + genA.C * genA.C + genA.D * genA.D);
        float normB = (float)Math.sqrt(genB.A * genB.A + genB.B * genB.B + genB.C * genB.C + genB.D * genB.D);
        genA.A /= normA;
        genA.B /= normA;
        genA.C /= normA;
        genA.D /= normA;
        genB.A /= normB;
        genB.B /= normB;
        genB.C /= normB;
        genB.D /= normB;
        int numMatch0 = 0;
        if (Math.abs(genA.A - genB.A) <= tol) {
            ++numMatch0;
        }
        if (Math.abs(genA.B - genB.B) <= tol) {
            ++numMatch0;
        }
        if (Math.abs(genA.C - genB.C) <= tol) {
            ++numMatch0;
        }
        if (Math.abs(genA.D - genB.D) <= tol) {
            ++numMatch0;
        }
        if (numMatch0 == 4) {
            return true;
        }
        if (Math.abs(genA.A + genB.A) > tol) {
            return false;
        }
        if (Math.abs(genA.B + genB.B) > tol) {
            return false;
        }
        if (Math.abs(genA.C + genB.C) > tol) {
            return false;
        }
        return !(Math.abs(genA.D + genB.D) > tol);
    }

    public static Se3_F32 planeToWorld(PlaneGeneral3D_F32 plane, Se3_F32 planeToWorld) {
        if (planeToWorld == null) {
            planeToWorld = new Se3_F32();
        }
        Vector3D_F32 axisZ = new Vector3D_F32(plane.A, plane.B, plane.C);
        Vector3D_F32 axisX = new Vector3D_F32();
        Vector3D_F32 axisY = new Vector3D_F32();
        if (axisZ.x != 0.0f) {
            axisX.x = axisZ.y;
            axisX.y = -axisZ.x;
            axisX.z = axisZ.z;
        } else if (axisZ.y != 0.0f) {
            axisX.x = -axisZ.y;
            axisX.y = 0.0f;
            axisX.z = axisZ.z;
        } else if (axisZ.z != 0.0f) {
            axisX.x = 0.0f;
            axisX.y = axisZ.z;
            axisX.z = 0.0f;
        }
        axisY.cross(axisX, axisZ);
        axisX.cross(axisY, axisZ);
        axisX.normalize();
        axisY.normalize();
        axisZ.normalize();
        DenseMatrix64F R = planeToWorld.R;
        R.data[0] = axisX.x;
        R.data[1] = axisY.x;
        R.data[2] = axisZ.x;
        R.data[3] = axisX.y;
        R.data[4] = axisY.y;
        R.data[5] = axisZ.y;
        R.data[6] = axisX.z;
        R.data[7] = axisY.z;
        R.data[8] = axisZ.z;
        Point3D_F32 cp = ClosestPoint3D_F32.closestPointOrigin(plane, null);
        planeToWorld.getT().set(cp.x, cp.y, cp.z);
        return planeToWorld;
    }
}

