/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.metric.UtilAngle;
import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.Quadrilateral_F32;
import georegression.struct.shapes.Rectangle2D_F32;
import georegression.struct.shapes.RectangleLength2D_I32;
import java.util.List;

public class UtilPolygons2D_F32 {
    public static void convert(Rectangle2D_F32 input, Quadrilateral_F32 output) {
        output.a.x = input.p0.x;
        output.a.y = input.p0.y;
        output.b.x = input.p1.x;
        output.b.y = input.p0.y;
        output.c.x = input.p1.x;
        output.c.y = input.p1.y;
        output.d.x = input.p0.x;
        output.d.y = input.p1.y;
    }

    public static void convert(RectangleLength2D_I32 input, Quadrilateral_F32 output) {
        output.a.x = input.x0;
        output.a.y = input.y0;
        output.b.x = input.x0 + input.width - 1;
        output.b.y = input.y0;
        output.c.x = input.x0 + input.width - 1;
        output.c.y = input.y0 + input.height - 1;
        output.d.x = input.x0;
        output.d.y = input.y0 + input.height - 1;
    }

    public static void bounding(Quadrilateral_F32 quad, Rectangle2D_F32 rectangle) {
        rectangle.p0.x = Math.min(quad.a.x, quad.b.x);
        rectangle.p0.x = Math.min(rectangle.p0.x, quad.c.x);
        rectangle.p0.x = Math.min(rectangle.p0.x, quad.d.x);
        rectangle.p0.y = Math.min(quad.a.y, quad.b.y);
        rectangle.p0.y = Math.min(rectangle.p0.y, quad.c.y);
        rectangle.p0.y = Math.min(rectangle.p0.y, quad.d.y);
        rectangle.p1.x = Math.max(quad.a.x, quad.b.x);
        rectangle.p1.x = Math.max(rectangle.p1.x, quad.c.x);
        rectangle.p1.x = Math.max(rectangle.p1.x, quad.d.x);
        rectangle.p1.y = Math.max(quad.a.y, quad.b.y);
        rectangle.p1.y = Math.max(rectangle.p1.y, quad.c.y);
        rectangle.p1.y = Math.max(rectangle.p1.y, quad.d.y);
    }

    public static boolean isCCW(List<Point2D_F32> polygon) {
        float total = 0.0f;
        int N = polygon.size();
        for (int i = 0; i <= N; ++i) {
            Point2D_F32 a = polygon.get(i % N);
            Point2D_F32 b = polygon.get((i + 1) % N);
            Point2D_F32 c = polygon.get((i + 2) % N);
            float angleBA = (float)Math.atan2(a.y - b.y, a.x - b.x);
            float angleBC = (float)Math.atan2(c.y - b.y, c.x - b.x);
            total += UtilAngle.minus(angleBA, angleBC);
        }
        return total > 0.0f;
    }
}

