/*
 * Decompiled with CFR 0.152.
 */
package georegression.metric;

import georegression.geometry.UtilPoint2D_F32;
import georegression.metric.ClosestPoint2D_F32;
import georegression.struct.line.LineGeneral2D_F32;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;

public class Distance2D_F32 {
    public static float distance(LineParametric2D_F32 line, Point2D_F32 p) {
        return (float)Math.sqrt(Distance2D_F32.distanceSq(line, p));
    }

    public static float distanceSq(LineParametric2D_F32 line, Point2D_F32 p) {
        float t = ClosestPoint2D_F32.closestPointT(line, p);
        float a = line.slope.x * t + line.p.x;
        float b = line.slope.y * t + line.p.y;
        float dx = p.x - a;
        float dy = p.y - b;
        return dx * dx + dy * dy;
    }

    public static float distance(LineSegment2D_F32 line, Point2D_F32 p) {
        float a = line.b.x - line.a.x;
        float b = line.b.y - line.a.y;
        float t = a * (p.x - line.a.x) + b * (p.y - line.a.y);
        if ((t /= a * a + b * b) < 0.0f) {
            return UtilPoint2D_F32.distance(line.a.x, line.a.y, p.x, p.y);
        }
        if (t > 1.0f) {
            return UtilPoint2D_F32.distance(line.b.x, line.b.y, p.x, p.y);
        }
        return UtilPoint2D_F32.distance(line.a.x + t * a, line.a.y + t * b, p.x, p.y);
    }

    public static float distance(LineGeneral2D_F32 line, Point2D_F32 p) {
        return Math.abs(line.A * p.x + line.B * p.y + line.C) / (float)Math.sqrt(line.A * line.A + line.B * line.B);
    }
}

