/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.alg.geo.bundle.CalibratedPoseAndPoint;
import georegression.geometry.RotationMatrixGenerator;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class CalibPoseAndPointRodriguesCodec
implements ModelCodec<CalibratedPoseAndPoint> {
    int numViews;
    int numPoints;
    int numViewsUnknown;
    boolean[] knownView;
    Rodrigues_F64 rotation = new Rodrigues_F64();
    DenseMatrix64F R = new DenseMatrix64F(3, 3);
    SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)false);

    public void configure(int numViews, int numPoints, int numViewsUnknown, boolean[] knownView) {
        if (numViews < knownView.length) {
            throw new IllegalArgumentException("Number of views is less than knownView length");
        }
        this.numViews = numViews;
        this.numPoints = numPoints;
        this.numViewsUnknown = numViewsUnknown;
        this.knownView = knownView;
    }

    public void decode(double[] input, CalibratedPoseAndPoint outputModel) {
        int i;
        int paramIndex = 0;
        for (i = 0; i < this.numViews; ++i) {
            if (this.knownView[i]) continue;
            Se3_F64 se = outputModel.getWorldToCamera(i);
            this.rotation.setParamVector(input[paramIndex++], input[paramIndex++], input[paramIndex++]);
            RotationMatrixGenerator.rodriguesToMatrix((Rodrigues_F64)this.rotation, (DenseMatrix64F)se.getR());
            Vector3D_F64 T = se.getT();
            T.x = input[paramIndex++];
            T.y = input[paramIndex++];
            T.z = input[paramIndex++];
        }
        for (i = 0; i < this.numPoints; ++i) {
            Point3D_F64 p = outputModel.getPoint(i);
            p.x = input[paramIndex++];
            p.y = input[paramIndex++];
            p.z = input[paramIndex++];
        }
    }

    public void encode(CalibratedPoseAndPoint model, double[] param) {
        int i;
        int paramIndex = 0;
        for (i = 0; i < this.numViews; ++i) {
            if (this.knownView[i]) continue;
            Se3_F64 se = model.getWorldToCamera(i);
            if (!this.svd.decompose((Matrix64F)se.getR())) {
                throw new RuntimeException("SVD failed");
            }
            DenseMatrix64F U = (DenseMatrix64F)this.svd.getU(null, false);
            DenseMatrix64F V = (DenseMatrix64F)this.svd.getV(null, false);
            CommonOps.multTransB((RowD1Matrix64F)U, (RowD1Matrix64F)V, (RowD1Matrix64F)this.R);
            RotationMatrixGenerator.matrixToRodrigues((DenseMatrix64F)this.R, (Rodrigues_F64)this.rotation);
            param[paramIndex++] = this.rotation.unitAxisRotation.x * this.rotation.theta;
            param[paramIndex++] = this.rotation.unitAxisRotation.y * this.rotation.theta;
            param[paramIndex++] = this.rotation.unitAxisRotation.z * this.rotation.theta;
            Vector3D_F64 T = se.getT();
            param[paramIndex++] = T.x;
            param[paramIndex++] = T.y;
            param[paramIndex++] = T.z;
        }
        for (i = 0; i < this.numPoints; ++i) {
            Point3D_F64 p = model.getPoint(i);
            param[paramIndex++] = p.x;
            param[paramIndex++] = p.y;
            param[paramIndex++] = p.z;
        }
    }

    public int getParamLength() {
        return this.numViewsUnknown * 6 + this.numPoints * 3;
    }
}

