/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class DistanceEpipolarConstraint
implements DistanceFromModel<DenseMatrix64F, AssociatedPair> {
    DenseMatrix64F M = new DenseMatrix64F(3, 3);

    public void setModel(DenseMatrix64F F) {
        double v = CommonOps.elementSumAbs((D1Matrix64F)F);
        CommonOps.scale((double)(1.0 / v), (D1Matrix64F)F, (D1Matrix64F)this.M);
    }

    public double computeDistance(AssociatedPair pt) {
        return Math.abs(GeometryMath_F64.innerProd((GeoTuple2D_F64)pt.p2, (DenseMatrix64F)this.M, (GeoTuple2D_F64)pt.p1));
    }

    public void computeDistance(List<AssociatedPair> associatedPairs, double[] distance) {
        for (int i = 0; i < associatedPairs.size(); ++i) {
            distance[i] = this.computeDistance(associatedPairs.get(i));
        }
    }
}

