/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import java.io.Serializable;

public class IntrinsicParameters
implements Serializable {
    public static final long serialVersionUID = 1L;
    public int width;
    public int height;
    public boolean flipY;
    public double fx;
    public double fy;
    public double skew;
    public double cx;
    public double cy;
    public double[] radial;

    public IntrinsicParameters() {
    }

    public IntrinsicParameters(double fx, double fy, double skew, double cx, double cy, int width, int height, boolean flipY, double[] radial) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
        this.cx = cx;
        this.cy = cy;
        this.width = width;
        this.height = height;
        this.flipY = flipY;
        this.radial = radial;
    }

    public IntrinsicParameters(IntrinsicParameters param) {
        this.set(param);
    }

    public void set(IntrinsicParameters param) {
        this.fx = param.fx;
        this.fy = param.fy;
        this.skew = param.skew;
        this.cx = param.cx;
        this.cy = param.cy;
        this.width = param.width;
        this.height = param.height;
        this.flipY = param.flipY;
        this.radial = param.radial;
        if (param.radial != null) {
            this.radial = (double[])param.radial.clone();
        }
    }

    public double getCx() {
        return this.cx;
    }

    public void setCx(double cx) {
        this.cx = cx;
    }

    public double getCy() {
        return this.cy;
    }

    public void setCy(double cy) {
        this.cy = cy;
    }

    public double getFx() {
        return this.fx;
    }

    public void setFx(double fx) {
        this.fx = fx;
    }

    public double getFy() {
        return this.fy;
    }

    public void setFy(double fy) {
        this.fy = fy;
    }

    public double[] getRadial() {
        return this.radial;
    }

    public void setRadial(double[] radial) {
        this.radial = radial;
    }

    public double getSkew() {
        return this.skew;
    }

    public void setSkew(double skew) {
        this.skew = skew;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public void print() {
        System.out.println("Shape " + this.width + " " + this.height + " flipY = " + this.flipY);
        System.out.printf("center %7.2f %7.2f\n", this.cx, this.cy);
        System.out.println("fx = " + this.fx);
        System.out.println("fy = " + this.fy);
        System.out.println("skew = " + this.skew);
        if (this.radial != null) {
            for (int i = 0; i < this.radial.length; ++i) {
                System.out.printf("radial[%d] = %6.2e\n", i, this.radial[i]);
            }
        } else {
            System.out.println("No radial");
        }
    }
}

