/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.testin.itestin.business.actions.utils.g;
import org.apache.log4j.Logger;

public class BridgeUtils {
    static Logger log = Logger.getLogger(BridgeUtils.class);
    public static AndroidDebugBridge bridge = null;

    public static IDevice getDevice(String serialno) {
        if (bridge == null) {
            BridgeUtils.getDebugBridge();
        }
        try {
            int count = 0;
            while (!bridge.hasInitialDeviceList()) {
                g.sleep(500L);
                if (++count <= 10) continue;
                log.error((Object)"Timeout getting device list!");
                return null;
            }
            IDevice[] devices = bridge.getDevices();
            int deviceNumber = devices.length;
            if (deviceNumber == 0) {
                log.info((Object)"No devices found!");
                return null;
            }
            for (int i2 = 0; i2 < deviceNumber; ++i2) {
                if (!devices[i2].toString().equals(serialno)) continue;
                return devices[i2];
            }
            log.info((Object)("Cannot find device " + serialno));
        }
        catch (Exception e2) {
            log.error((Object)e2);
        }
        return null;
    }

    public static AndroidDebugBridge getDebugBridge() {
        if (bridge != null) {
            return bridge;
        }
        String adbLocation = "adb";
        try {
            AndroidDebugBridge.init((boolean)false);
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            return null;
        }
        try {
            bridge = AndroidDebugBridge.createBridge((String)adbLocation, (boolean)true);
        }
        catch (Exception e3) {
            log.error((Object)e3.getMessage(), (Throwable)e3);
            return null;
        }
        return bridge;
    }

    public static void closeBridge() {
        if (bridge != null) {
            AndroidDebugBridge.terminate();
        }
    }
}

