/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CancelConnectionTestListener;
import com.android.ddmlib.DeviceConnection;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TestinAdbHelper;
import com.android.ddmlib.TimeoutException;
import com.testin.itestin.device.f;
import com.testin.itestin.os.c;
import com.testin.itestin.shell.e;
import com.testin.itestin.util.g;
import com.testin.itestin.util.n;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DeviceViewClient {
    static Logger log = Logger.getLogger(DeviceViewClient.class);
    private final String HEARTBEAT = "heartbeat";
    private boolean isCancelled = false;
    private boolean isRunning = false;
    private f deviceInfo = null;
    private DeviceConnection deviceConnection = null;
    private String lastWindowInfoMD5 = "";
    private String currentWindowInfo = "";
    private long lastCmdTimeStamp = System.currentTimeMillis();
    public static final String REMOTE_PORT_CHANGE_FLAG = "RECORDER_NEW_PORT#";
    private final String RESULT_SEPERATOR = "@";
    private long currentWindowInfoTimeStamp;
    private boolean CONNECTION_SUCCESS = false;

    public DeviceViewClient(f deviceInfo) {
        if (deviceInfo == null) {
            log.error((Object)"Device is null, unable to initialize ViewClient");
            return;
        }
        this.deviceInfo = deviceInfo;
        this.deviceConnection = new DeviceConnection(deviceInfo);
        log.info((Object)("ViewClient initialized for device " + deviceInfo));
        this.start();
    }

    public String getWindowInfoFromDevice() {
        String windowinfo = this.fetchWindowInfo(this.lastWindowInfoMD5).getContent();
        if (!windowinfo.equals("0") && StringUtils.isNotEmpty((String)windowinfo)) {
            this.lastWindowInfoMD5 = g.r(windowinfo);
            this.currentWindowInfo = windowinfo;
            this.setCurrentWindowInfoTimeStamp(System.currentTimeMillis());
        }
        return windowinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public c sendHeartbeat() {
        c msg = new c();
        try {
            e.a rcvr = new e.a();
            try {
                TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), this.HEARTBEAT, this.deviceInfo.getDevice(), rcvr, 2000);
                msg.setContent(rcvr.getOutput());
                this.setLastCmdTimeStamp(System.currentTimeMillis());
            }
            catch (Exception ex) {
                msg.setStatus(20);
                msg.setContent(ex.getMessage());
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                rcvr = null;
            }
            c c2 = msg;
            this.setConnectionSuccess(msg.getStatus() == 0);
            return c2;
        }
        catch (Exception e2) {
            try {
                msg.setStatus(20);
                msg.setContent(e2.getMessage());
                log.error((Object)e2.getMessage(), (Throwable)e2);
                c c3 = msg;
                this.setConnectionSuccess(msg.getStatus() == 0);
                return c3;
            }
            catch (Throwable throwable) {
                this.setConnectionSuccess(msg.getStatus() == 0);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public c cancelRunCMD(boolean setCancelValue) {
        c msg = new c();
        try {
            e.a rcvr = new e.a();
            try {
                TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), "cancelruncmd " + setCancelValue, this.deviceInfo.getDevice(), rcvr, 60000);
                msg.setContent(rcvr.getOutput());
                this.setLastCmdTimeStamp(System.currentTimeMillis());
            }
            catch (Exception ex) {
                msg.setStatus(20);
                msg.setContent(ex.getMessage());
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                rcvr = null;
            }
            c c2 = msg;
            return c2;
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
        return msg;
    }

    public boolean stop() {
        String runcmd = "stopserver";
        e.a rcvr = new e.a();
        try {
            log.info((Object)"stop view server on device.");
            TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), runcmd, this.deviceInfo.getDevice(), rcvr, 2000);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.deviceConnection.removeForward();
        this.isCancelled = true;
        return true;
    }

    public void reset() {
        this.setConnectionSuccess(false);
        this.isCancelled = false;
        this.isRunning = false;
        this.setLastWindowInfoMD5("");
        this.setCurrentWindowInfo("");
    }

    public boolean start() {
        c msg = this.deviceConnection.createForward();
        boolean bl = this.isRunning = msg.getStatus() == 0;
        if (this.isRunning) {
            log.info((Object)"Start running view client.");
        } else {
            log.info((Object)"View client unable to start.");
        }
        return this.isRunning;
    }

    public boolean isRunning() {
        return this.isRunning && !this.isCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public c runCmd(String command, boolean scroll, int timeout) {
        long t1 = System.currentTimeMillis();
        c msg = new c();
        e.a rcvr = new e.a();
        try {
            command = String.format("[scroll/%s]%s", scroll, command);
            if (timeout > 0) {
                command = this.getTimeoutFormat(timeout) + command;
            } else {
                timeout = 60000;
            }
            Base64 base64 = new Base64(2048);
            byte[] data = base64.encode(command.getBytes("utf-8"));
            String cmd = new String(data, "utf-8");
            String runcmd = String.format("runcmd %s", cmd);
            TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), runcmd, this.deviceInfo.getDevice(), rcvr, timeout + 10000);
            String r2 = rcvr.getOutput();
            this.setLastCmdTimeStamp(System.currentTimeMillis());
            System.out.println("RESULT: " + r2);
            if (StringUtils.isNotEmpty((String)r2) && r2.contains("@") && r2.substring(0, r2.indexOf("@")).equals("false")) {
                msg.setContent(r2.substring(r2.indexOf("@") + 1, r2.length()));
                msg.setStatus(1);
            } else {
                log.error((Object)("RESULT: " + msg));
            }
            log.info((Object)String.format("Run CMD Sucessful: %s\nResult: %s", command, msg.getStatus() + (StringUtils.isEmpty((String)msg.getContent()) ? "" : " " + msg.getContent())));
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException ex) {
            System.out.println(ex.getLocalizedMessage());
            msg.setStatus(20);
            msg.setContent(ex.getMessage());
            log.error((Object)String.format("Run CMD Failed: %s, Error Msg: %s", command, ex.getMessage()), ex);
        }
        finally {
            long t2 = System.currentTimeMillis();
            System.err.println("\u6267\u884c\u547d\u4ee4\uff1a" + command + "\n" + "\u8017\u65f6\uff1a" + (t2 - t1));
        }
        return msg;
    }

    private String getTimeoutFormat(int timeout) {
        return String.format("[replaytimeout/%s]", timeout);
    }

    public c fetchText(String command) {
        c msg = new c();
        e.a rcvr = new e.a();
        try {
            Base64 base64 = new Base64(2048);
            byte[] data = base64.encode(command.getBytes("utf-8"));
            String cmd = new String(data, "utf-8");
            String runcmd = String.format("fetch.text %s", cmd);
            TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), runcmd, this.deviceInfo.getDevice(), rcvr, 60000);
            msg.setContent(rcvr.getOutput());
            this.setLastCmdTimeStamp(System.currentTimeMillis());
            log.info((Object)String.format("Run CMD Sucessful: %s\nResult: %s", command, msg.getContent()));
        }
        catch (Exception ex) {
            msg.setStatus(20);
            msg.setContent(ex.getMessage());
            log.error((Object)String.format("Run CMD Failed: %s, Error Msg: %s", command, ex.getMessage()), (Throwable)ex);
        }
        return msg;
    }

    public c fetchWindowInfo() {
        return this.fetchWindowInfo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public c fetchWindowInfo(String lastWindowInfoMD5) {
        c msg;
        block11: {
            msg = new c();
            if (!n.aL) break block11;
            c c2 = msg;
            return c2;
        }
        try {
            String command = "viewfetcher";
            if (lastWindowInfoMD5 != null && !lastWindowInfoMD5.equals("")) {
                command = String.format("%s %s", command, lastWindowInfoMD5);
            }
            e.a rcvr = new e.a();
            try {
                TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), command, this.deviceInfo.getDevice(), rcvr, 60000);
                msg.setContent(rcvr.getOutput());
                this.setLastCmdTimeStamp(System.currentTimeMillis());
            }
            catch (Exception ex) {
                msg.setStatus(20);
                msg.setContent(ex.getMessage());
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                rcvr = null;
            }
            c c3 = msg;
            return c3;
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
        return msg;
    }

    public long getLastCmdTimeStamp() {
        return this.lastCmdTimeStamp;
    }

    public void setLastCmdTimeStamp(long lastCmdTimeStamp) {
        this.lastCmdTimeStamp = lastCmdTimeStamp;
    }

    public String getLastWindowInfoMD5() {
        return this.lastWindowInfoMD5;
    }

    public void setLastWindowInfoMD5(String lastWindowInfoMD5) {
        this.lastWindowInfoMD5 = lastWindowInfoMD5;
    }

    public void setCurrentWindowInfo(String currentWindowInfo) {
        this.currentWindowInfo = currentWindowInfo;
    }

    public long getCurrentWindowInfoTimeStamp() {
        return this.currentWindowInfoTimeStamp;
    }

    public void setCurrentWindowInfoTimeStamp(long currentWindowInfoTimeStamp) {
        this.currentWindowInfoTimeStamp = currentWindowInfoTimeStamp;
    }

    public String getCurrentWindowInfo() {
        return this.currentWindowInfo;
    }

    public String getPortChangeFlag() {
        return REMOTE_PORT_CHANGE_FLAG;
    }

    public void setConnectionSuccess(boolean cONNECTION_SUCCESS) {
        this.CONNECTION_SUCCESS = cONNECTION_SUCCESS;
    }

    public boolean isConnectionSuccess() {
        return this.CONNECTION_SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public c runCommand(String command, boolean scroll, int timeout) {
        long t1 = System.currentTimeMillis();
        try {
            c c2 = this.runCmd(command, scroll, timeout);
            return c2;
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            c msg = new c();
            msg.setStatus(20);
            msg.setContent(e2.getMessage());
            c c3 = msg;
            return c3;
        }
        finally {
            long t2 = System.currentTimeMillis();
            log.info((Object)("RunCmd: \n" + command + "\nTimeConsumed: " + (t2 - t1)));
        }
    }

    public boolean testConnection(CancelConnectionTestListener cancelListener) {
        long timeout = 20000L;
        long startTime = System.currentTimeMillis();
        int count = 0;
        while (System.currentTimeMillis() - startTime < 2000L) {
            com.testin.itestin.business.actions.utils.g.sleep(100L);
            if (cancelListener == null || !cancelListener.isCancelled()) continue;
            return false;
        }
        while (System.currentTimeMillis() - startTime < timeout && (cancelListener != null && !cancelListener.isCancelled() || cancelListener == null)) {
            ++count;
            try {
                c msg = this.sendHeartbeat();
                if (msg.getStatus() == 0) {
                    return true;
                }
            }
            catch (Exception e2) {
                log.error((Object)("Test Connection " + count + " failed with message: " + e2.getMessage()));
            }
            com.testin.itestin.business.actions.utils.g.sleep(1000L);
        }
        return false;
    }

    public void updatePortAndRestart(String updateMessage) {
        if (StringUtils.isEmpty((String)updateMessage) || !updateMessage.contains(this.getPortChangeFlag())) {
            return;
        }
        final String[] infos = updateMessage.split(this.getPortChangeFlag());
        if (infos.length == 2) {
            if (infos[1].equals(String.valueOf(DeviceConnection.DEFAULT_VIEW_SERVER_PORT))) {
                return;
            }
            if (n.isNumber(infos[1])) {
                new Thread(){

                    @Override
                    public void run() {
                        DeviceViewClient.this.updatePortAndRestart(Integer.parseInt(infos[1]));
                    }
                }.start();
            }
        }
    }

    public synchronized boolean updatePortAndRestart(int newPort) {
        this.endViewServerIfAny();
        log.info((Object)String.format("Use new port (%s) to re-init the client.", newPort));
        if (this.deviceInfo == null || this.deviceInfo.getDevice() == null || !this.deviceInfo.getDevice().isOnline()) {
            log.error((Object)"Device is null or not online.");
            return false;
        }
        this.deviceConnection = new DeviceConnection(this.deviceInfo);
        this.deviceConnection.setNewRemotePort(newPort);
        if (!this.isRunning()) {
            return this.start();
        }
        return false;
    }

    public void heartbeat() {
        if (System.currentTimeMillis() - this.lastCmdTimeStamp < 5000L) {
            return;
        }
        this.sendHeartbeat();
    }

    public void endViewServerIfAny() {
        try {
            this.stop();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public c fetchViewText(String command) {
        long t1 = System.currentTimeMillis();
        try {
            c c2 = this.fetchText(command);
            return c2;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            c c3 = new c();
            return c3;
        }
        finally {
            long t2 = System.currentTimeMillis();
            log.info((Object)("fetch view text with command: " + command + "\nTimeConsumed: " + (t2 - t1)));
        }
    }
}

