/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.business;

import com.testin.itestin.business.d;
import com.testin.itestin.business.k;
import com.testin.itestin.device.f;
import com.testin.itestin.device.i;
import com.testin.itestin.entitys.a;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TestFileUtils {
    static Logger log = Logger.getLogger(TestFileUtils.class);

    public static String getTestRootDir(String scriptPath) {
        if (scriptPath == null) {
            return null;
        }
        File f2 = new File(scriptPath);
        String dir = f2.getParentFile().getParentFile().getAbsolutePath();
        return dir;
    }

    public static String getTestRootDir() {
        String pkg = k.a().q();
        String ver = k.a().getVersion();
        String dir_fn = String.format("%s_%s_dir", pkg, ver);
        String path = com.testin.itestin.service.a.ac() + File.separator + dir_fn + File.separator;
        return path;
    }

    public static String getTestRootDir(String pkgName, String version) {
        String dir_fn = String.format("%s_%s_dir", pkgName, version);
        String path = com.testin.itestin.service.a.ac() + File.separator + dir_fn + File.separator;
        return path;
    }

    public static String stringFilter(String str) throws PatternSyntaxException {
        if (str == null || StringUtils.isEmpty((String)str)) {
            return str;
        }
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p2 = Pattern.compile(regEx);
        Matcher m2 = p2.matcher(str);
        return m2.replaceAll("").trim().replaceAll(" ", "");
    }

    public static String getTestRelativeDir() {
        String pkg = k.a().q();
        String ver = k.a().getVersion();
        String dir_fn = String.format("%s_%s_dir", pkg, ver);
        String path = "script" + File.separator + dir_fn + File.separator;
        return path;
    }

    public static List<String> getScriptsDir(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        File f2 = new File(rootPath);
        File[] dirs = f2.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().endsWith("_dir");
            }
        });
        if (dirs != null) {
            for (File dir : dirs) {
                list.add(dir.getAbsolutePath());
            }
        }
        return list;
    }

    public static String getScriptDir(String rootPath, String scriptName) {
        if (rootPath == null) {
            return null;
        }
        String fn = String.format("%s_dir", scriptName);
        String path = rootPath + fn + File.separator;
        return path;
    }

    public static String getAppIconPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "icon.png";
        String path = rootPath + fn;
        return path;
    }

    public static String getAppOringinPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "oringin.apk";
        String path = rootPath + fn;
        return path;
    }

    public static String getAppResignedPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "resigned.apk";
        String path = rootPath + fn;
        return path;
    }

    public static String getAppRecordPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "record.apk";
        String path = rootPath + fn;
        return path;
    }

    public static String getAppInfoPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "app.dat";
        String path = rootPath + File.separator + fn;
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static a getAppInfo(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        a appInfo = null;
        String dataPath = TestFileUtils.getAppInfoPath(rootPath);
        File f2 = new File(dataPath);
        if (!f2.exists()) {
            return null;
        }
        try {
            String[] lines;
            appInfo = new a();
            String dat = FileUtils.readFileToString((File)f2, (String)"utf-8");
            for (String line : lines = dat.split("\r\n")) {
                String size;
                if (line.startsWith("appname=")) {
                    appInfo.setAppName(line.substring("appname=".length()));
                    continue;
                }
                if (line.startsWith("pacname=")) {
                    appInfo.setPackageName(line.substring("pacname=".length()));
                    continue;
                }
                if (line.startsWith("actname=")) {
                    appInfo.av(line.substring("actname=".length()));
                    continue;
                }
                if (line.startsWith("version=")) {
                    String ver = line.substring("version=".length());
                    if ("null".equals(ver)) {
                        appInfo.ax(null);
                        continue;
                    }
                    appInfo.ax(line.substring("version=".length()));
                    continue;
                }
                if (line.startsWith("appsize=")) {
                    try {
                        size = line.substring("appsize=".length());
                        long l2 = Long.parseLong(size);
                        appInfo.d(l2);
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    continue;
                }
                if (line.startsWith("md5=")) {
                    appInfo.setMd5(line.substring("md5=".length()));
                    continue;
                }
                if (line.startsWith("minsdk=")) {
                    try {
                        size = line.substring("minsdk=".length());
                        int l3 = Integer.parseInt(size);
                        appInfo.T(l3);
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    continue;
                }
                if (!line.startsWith("filepath=")) continue;
                appInfo.ay(line.substring("filepath=".length()));
            }
        }
        catch (IOException e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
        return appInfo;
    }

    public static String getKeystorePath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "test.keystore";
        String path = rootPath + File.separator + fn;
        return path;
    }

    public static String getKeystoreInfoPath(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        String fn = "keystore.dat";
        String path = rootPath + File.separator + fn;
        return path;
    }

    public static void saveKeyStoreData(String storePath, d keyStore, boolean used) {
        try {
            File keyInfo = new File(storePath);
            if (keyInfo.exists()) {
                FileUtils.deleteQuietly((File)keyInfo);
            }
            StringBuffer buff = new StringBuffer();
            buff.append("alias=" + keyStore.getAlias() + "\r\n");
            buff.append("storepass=" + keyStore.m() + "\r\n");
            buff.append("aliaspass=" + keyStore.n() + "\r\n");
            buff.append("used=" + used + "\r\n");
            FileUtils.write((File)keyInfo, (CharSequence)buff.toString());
        }
        catch (IOException e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
    }

    public static d getKeystore(String rootPath) {
        if (rootPath == null) {
            return null;
        }
        d keyStore = null;
        String storePath = TestFileUtils.getKeystorePath(rootPath);
        String dataPath = TestFileUtils.getKeystoreInfoPath(rootPath);
        File f1 = new File(storePath);
        if (!f1.exists()) {
            return null;
        }
        File f2 = new File(dataPath);
        if (!f2.exists()) {
            return null;
        }
        try {
            keyStore = new d();
            keyStore.o(storePath);
            String dat = FileUtils.readFileToString((File)f2, (String)"utf-8");
            String[] lines = dat.split("\r\n");
            boolean needupdate = true;
            for (String line : lines) {
                if (line.startsWith("alias=")) {
                    keyStore.r(line.substring("alias=".length()));
                    continue;
                }
                if (line.startsWith("storepass=")) {
                    keyStore.p(line.substring("storepass=".length()));
                    continue;
                }
                if (line.startsWith("aliaspass=")) {
                    keyStore.q(line.substring("aliaspass=".length()));
                    continue;
                }
                if (!line.startsWith("used=")) continue;
                needupdate = false;
                keyStore.e(Boolean.parseBoolean(line.substring("used=".length())));
            }
            keyStore.f(needupdate);
        }
        catch (IOException e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
        return keyStore;
    }

    public static String getPixel() {
        f dev = i.a();
        if (dev == null) {
            return "";
        }
        return dev.getPixel();
    }

    public static File[] getFilterList(String dir, final String filter) {
        File[] files = new File(dir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(filter);
            }
        });
        return files;
    }
}

