/*
 * Decompiled with CFR 0.152.
 */
package com.testin.itestin.service.FileWatch;

import com.testin.itestin.service.FileWatch.IFileChangeListener;
import com.testin.itestin.service.FileWatch.Listener;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class FileWatchService {
    static Logger log = Logger.getLogger(Listener.class);
    private static ExecutorService fixedThreadPool = Executors.newFixedThreadPool(5);
    private WatchService ws;
    private String listenerPath;
    private Listener listener;
    public static HashMap<String, FileWatchService> fileWatchServiceHashMap = new HashMap();

    private FileWatchService(String path) {
        try {
            this.ws = FileSystems.getDefault().newWatchService();
            this.listenerPath = path;
            this.start();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void addFileChangeListener(IFileChangeListener fileChangeListener) {
        this.listener.addListener(fileChangeListener);
    }

    private void start() {
        this.listener = new Listener(this.ws, this.listenerPath);
        fixedThreadPool.execute(this.listener);
    }

    public static void addListener(String path, IFileChangeListener listener) throws IOException {
        if (fileWatchServiceHashMap.containsKey(path)) {
            fileWatchServiceHashMap.get(path).addFileChangeListener(listener);
        } else {
            log.info((Object)("\u6dfb\u52a0\u4e86\u5bf9\u8def\u5f84 " + path + " \u7684\u8ba2\u9605"));
            FileWatchService resourceListener = new FileWatchService(path);
            Path p2 = Paths.get(path, new String[0]);
            p2.register(resourceListener.ws, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE);
            fileWatchServiceHashMap.put(path, resourceListener);
            resourceListener.addFileChangeListener(listener);
        }
    }
}

