/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.testin.itestin.business.actions.utils.d;
import com.testin.itestin.common.a;
import com.testin.javafx.ui.TemplateController;
import com.testin.javafx.ui.b;
import com.testin.javafx.ui.control.H;
import com.testin.javafx.ui.include.TopController;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CloudTestController
extends AnchorPane
implements b,
Initializable {
    static Logger log = Logger.getLogger(CloudTestController.class);
    @FXML
    WebView webView;
    @FXML
    BorderPane cloudTestPane;
    private int cloudTestPaneWidth;
    private int cloudTestPaneHeight;
    WebEngine webEngine;
    String message = d.e("cloudtestcontroller.mssage");
    H progressDialog = new H(H.b.c);
    private ChangeListener<String> locationChangeListener = new ChangeListener<String>(){

        public void changed(ObservableValue<? extends String> observable, final String oldValue, String newValue) {
            try {
                URI address;
                if (StringUtils.isNotEmpty((String)oldValue) && StringUtils.isNotEmpty((String)newValue) && !((address = new URI(newValue)).getQuery() + "").startsWith("op=App.list")) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CloudTestController.this.webEngine.load(oldValue);
                        }
                    });
                    com.testin.javafx.b.a().getHostServices().showDocument(newValue);
                }
            }
            catch (URISyntaxException e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
    };
    private ChangeListener<Worker.State> stateChangeListener = new ChangeListener<Worker.State>(){

        public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
            if (newValue == Worker.State.SUCCEEDED) {
                CloudTestController.this.progressDialog.setProgressValue(100);
                CloudTestController.this.progressDialog.close();
            } else if (newValue == Worker.State.FAILED) {
                CloudTestController.this.progressDialog.close();
            } else if (newValue == Worker.State.READY) {
                CloudTestController.this.progressDialog.setProgressValue(20);
            } else if (newValue == Worker.State.SCHEDULED) {
                CloudTestController.this.progressDialog.setProgressValue(40);
            } else if (newValue == Worker.State.RUNNING) {
                CloudTestController.this.progressDialog.setProgressValue(60);
            }
        }
    };

    public void initialize(URL arg0, ResourceBundle arg1) {
        TopController.setEmulatorEventListener(this);
        this.cloudTestPaneWidth = (int)this.cloudTestPane.getPrefWidth();
        this.cloudTestPaneHeight = (int)this.cloudTestPane.getPrefHeight();
        this.setSize();
        this.progressDialog.show();
        this.progressDialog.setMessage(this.message);
        this.progressDialog.setProgressValue(10);
        this.webView.setContextMenuEnabled(false);
        this.webEngine = this.webView.getEngine();
        this.webEngine.getLoadWorker().stateProperty().addListener(this.stateChangeListener);
        this.webEngine.locationProperty().addListener(this.locationChangeListener);
    }

    public void loadURL() {
        log.info((Object)a.ar());
        this.webEngine.load(a.ar());
    }

    @Override
    public void setSize() {
        if (TopController.isFullScreen) {
            int w2 = (int)com.testin.javafx.b.a().a().getWidth();
            int h2 = (int)com.testin.javafx.b.a().a().getHeight();
            this.cloudTestPane.setPrefWidth((double)w2);
            this.cloudTestPane.setPrefHeight((double)(h2 - TemplateController.topHeigh - TemplateController.bottomHeigh));
        } else {
            this.cloudTestPane.setPrefWidth((double)this.cloudTestPaneWidth);
            this.cloudTestPane.setPrefHeight((double)this.cloudTestPaneHeight);
        }
    }
}

