/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.utils.a;
import com.testin.itestin.service.FileWatch.IFileChangeListener;
import com.testin.itestin.util.f;
import com.testin.itestin.util.m;
import com.testin.javafx.b;
import com.testin.javafx.ui.TemplateController;
import com.testin.javafx.ui.apk.ApkFolderController;
import com.testin.javafx.ui.apk.a;
import com.testin.javafx.ui.control.H;
import com.testin.javafx.ui.control.d;
import com.testin.javafx.ui.include.TopController;
import com.testin.javafx.ui.include.logic.ScriptManageControllerLogic;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.WatchEvent;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.log4j.Logger;

public class ScriptTilesManageController
implements IFileChangeListener,
com.testin.javafx.ui.b,
Initializable {
    static Logger log = Logger.getLogger(ScriptTilesManageController.class);
    String message = com.testin.itestin.business.actions.utils.d.e("cloudtestcontroller.mssage");
    @FXML
    AnchorPane scriptTilesManagePage;
    @FXML
    BorderPane scriptTilesManageBorderPane;
    @FXML
    private TilePane tilepaneview;
    @FXML
    Label totalImport;
    @FXML
    TextField searchCon;
    @FXML
    Label search;
    @FXML
    Label clean;
    @FXML
    Label lineLabel;
    Vector<a> afm = new Vector();
    ScriptManageControllerLogic logic;
    private File zipOf = null;
    private boolean isLoading = false;
    H deleteDialog = new H(H.b.c);
    private int oriBorderPaneWidth;
    private int oriBorderPaneHeigh;
    private int oriTilepaneviewWidth;
    private int oriTilepaneviewHeigh;
    private int oriLineLabelWidth;

    public void initialize(URL location, ResourceBundle resources) {
        this.tilepaneview.setPrefColumns(4);
        this.logic = new ScriptManageControllerLogic(this);
        TopController.setScriptTitlesMaxEventListener(this);
        this.oriBorderPaneWidth = (int)this.scriptTilesManageBorderPane.getPrefWidth();
        this.oriBorderPaneHeigh = (int)this.scriptTilesManageBorderPane.getPrefHeight();
        this.oriTilepaneviewWidth = (int)this.tilepaneview.getPrefWidth();
        this.oriTilepaneviewHeigh = (int)this.tilepaneview.getPrefHeight();
        this.oriLineLabelWidth = (int)this.lineLabel.getPrefWidth();
        this.setSize();
    }

    public void showDeleteDialog() {
        Platform.runLater(() -> {
            this.deleteDialog.setProgressValue(50);
            this.deleteDialog.setMessage(com.testin.itestin.business.actions.utils.d.e("scriptmanagecontroller.delete.dialog.message"));
            this.deleteDialog.show();
        });
    }

    public void loadApkFolders() {
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.tilepaneview.getChildren().clear();
        Thread t2 = new Thread(() -> {
            this.afm.clear();
            this.afm = this.getApkFolderInfo();
            for (a a2 : this.afm) {
                VBox box = this.loadFxmlForApkFolder(a2);
                Platform.runLater(() -> this.tilepaneview.getChildren().add((Object)box));
            }
            this.isLoading = false;
        });
        t2.start();
    }

    private VBox loadFxmlForApkFolder(a am) {
        VBox page = new VBox();
        ApkFolderController controller = new ApkFolderController();
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/com/testin/javafx/ui/apk/ApkFolder.fxml"));
        fxmlLoader.setRoot((Object)controller.vboxholder);
        fxmlLoader.setController((Object)controller);
        try {
            page = (VBox)fxmlLoader.load();
            page.setSpacing(5.0);
            controller.setApkFolderModel(am);
            controller.updateView();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return page;
    }

    private static void setApkFileLastModifed(File[] ff) {
        for (File f2 : ff) {
            File[] scriptDir;
            if (!f2.exists()) continue;
            long t2 = f2.lastModified();
            for (File dir : scriptDir = TestFileUtils.getFilterList(f2.getPath(), "_dir")) {
                File[] xml;
                for (File xmlF : xml = TestFileUtils.getFilterList(dir.getPath(), ".xml")) {
                    if (!xmlF.exists() || xmlF.lastModified() <= t2) continue;
                    t2 = xmlF.lastModified();
                }
            }
            if (t2 <= f2.lastModified()) continue;
            f2.setLastModified(t2);
        }
    }

    private Vector<a> getApkFolderInfo() {
        Vector<a> v2 = new Vector<a>();
        String scriptPath = com.testin.itestin.service.a.ac();
        File[] scriptFiles = new File(scriptPath).listFiles();
        if (scriptFiles != null && scriptFiles.length > 0) {
            File[] files = TestFileUtils.getFilterList(scriptPath, "_dir");
            ScriptTilesManageController.setApkFileLastModifed(files);
            Arrays.sort(files, new a.a());
            for (File f2 : files) {
                com.testin.itestin.entitys.a info;
                a am = new a();
                File icon = new File(f2.getPath() + File.separator + "icon.png");
                if (icon.exists()) {
                    am.au(icon.getAbsolutePath());
                }
                if ((info = TestFileUtils.getAppInfo(f2.getPath())) == null) continue;
                am.v(info.getPackageName());
                am.setVersion(info.aI() == null ? "" : info.aI());
                am.a((StringProperty)new SimpleStringProperty(info.getAppName()));
                am.aF(info.getAppName());
                v2.add(am);
            }
        }
        return v2;
    }

    @FXML
    public void mouseMove() {
        ApkFolderController.getInstance().hideContextMenu();
    }

    @FXML
    public void cleanClick(MouseEvent event) {
        this.searchCon.setText("");
        this.loadApkFolders();
    }

    @FXML
    public void searchClick(MouseEvent event) {
        VBox box;
        if (this.searchCon.getText().isEmpty()) {
            d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("scriptitlesmanager.search.null"));
            return;
        }
        this.afm.clear();
        this.afm = this.getApkFolderInfo();
        this.tilepaneview.getChildren().clear();
        boolean isHave = false;
        for (a a2 : this.afm) {
            if (!a2.aY().contains(this.searchCon.getText()) && !a2.aY().equals(this.searchCon.getText())) continue;
            box = this.loadFxmlForApkFolder(a2);
            this.tilepaneview.getChildren().add((Object)box);
            isHave = true;
        }
        if (!isHave) {
            for (a a2 : this.afm) {
                box = this.loadFxmlForApkFolder(a2);
                this.tilepaneview.getChildren().add((Object)box);
            }
            d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("scriptitlesmanager.search.findnull"));
        }
    }

    @FXML
    public void totalImportClick() throws IOException {
        File f2;
        FileChooser chooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("zip files (*.zip)", new String[]{"*.zip"});
        chooser.getExtensionFilters().add((Object)extFilter);
        if (this.zipOf == null) {
            this.zipOf = f.a("zip");
            if (this.zipOf != null && this.zipOf.exists()) {
                chooser.setInitialDirectory(this.zipOf);
            }
        } else if (this.zipOf.exists()) {
            chooser.setInitialDirectory(this.zipOf);
        }
        if ((f2 = chooser.showOpenDialog((Window)b.a().a())) != null) {
            this.zipOf = f2.getParentFile();
            f.h("zip", this.zipOf.toString());
            if (!m.b(f2, "app.dat") || !m.b(f2, "oringin.apk")) {
                d.a(d.a.c, com.testin.itestin.business.actions.utils.d.e("scriptmanagercontroller.oneImportClick.diffstyle"));
                return;
            }
            String con = m.a(f2, "app.dat");
            String pkn = com.testin.itestin.business.utils.a.b(con, "pacname=", "actname=").replace("\r", "").replace("\n", "");
            String ver = com.testin.itestin.business.utils.a.b(con, "version=", "appsize=").replace("\r", "").replace("\n", "");
            String appDir = pkn + "_" + ver + "_dir";
            String desDir = com.testin.itestin.service.a.ac() + File.separator + appDir + File.separator;
            File dir = new File(com.testin.itestin.service.a.ac());
            File[] temp = dir.listFiles();
            boolean isSame = false;
            if (null != temp) {
                for (int i2 = 0; i2 < temp.length; ++i2) {
                    if (!temp[i2].getName().equals(appDir)) continue;
                    isSame = true;
                }
            }
            H progressDialog = new H(H.b.c);
            progressDialog.show();
            progressDialog.setMessage(com.testin.itestin.business.actions.utils.d.e("apkfoldercontroller.export.progressdialog"));
            progressDialog.setProgressValue(10);
            boolean result = false;
            result = isSame ? m.c(f2, desDir, appDir) : m.a(f2, desDir, appDir);
            progressDialog.setProgressValue(100);
            progressDialog.close();
            if (result) {
                d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("scriptmanagecontroller.importsuccess.text"));
            } else {
                d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("scriptmanagecontroller.importfailure.text"));
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    b.a().ax();
                }
            });
        }
    }

    public void onKeyReleased(KeyEvent event) {
        if (event.getCode().equals((Object)KeyCode.ENTER)) {
            this.searchClick(null);
        }
    }

    @Override
    public void onFileChange(List<WatchEvent<?>> watchEvents) {
        boolean loadflag = false;
        for (WatchEvent<?> event : watchEvents) {
            if (!event.kind().toString().equals("ENTRY_DELETE") && !event.kind().toString().equals("ENTRY_CREATE")) continue;
            loadflag = true;
            break;
        }
        if (loadflag) {
            Platform.runLater(() -> {
                this.deleteDialog.setProgressValue(100);
                this.deleteDialog.close();
                this.loadApkFolders();
            });
        }
    }

    @Override
    public void setSize() {
        if (TopController.isFullScreen) {
            int w2 = (int)b.a().a().getWidth();
            int h2 = (int)b.a().a().getHeight();
            int lineW = (int)this.lineLabel.getPrefWidth();
            int pageW = (int)this.scriptTilesManageBorderPane.getPrefWidth();
            this.scriptTilesManageBorderPane.setPrefWidth((double)w2);
            this.scriptTilesManageBorderPane.setPrefHeight((double)(h2 - TemplateController.topHeigh - TemplateController.bottomHeigh));
            this.tilepaneview.setPrefWidth((double)(w2 - 5));
            this.tilepaneview.setPrefHeight((double)(h2 - TemplateController.topHeigh - TemplateController.bottomHeigh - 54));
            this.lineLabel.setPrefWidth((double)(w2 - (pageW - lineW)));
        } else {
            this.scriptTilesManageBorderPane.setPrefWidth((double)this.oriBorderPaneWidth);
            this.scriptTilesManageBorderPane.setPrefHeight((double)this.oriBorderPaneHeigh);
            this.tilepaneview.setPrefWidth((double)this.oriTilepaneviewWidth);
            this.tilepaneview.setPrefHeight((double)this.oriTilepaneviewHeigh);
            this.lineLabel.setPrefWidth((double)this.oriLineLabelWidth);
        }
    }
}

