/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.apk;

import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.actions.utils.d;
import com.testin.itestin.business.k;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.util.f;
import com.testin.javafx.b;
import com.testin.javafx.ui.apk.CopyScriptApkFolderController;
import com.testin.javafx.ui.apk.a;
import com.testin.javafx.ui.control.H;
import com.testin.javafx.ui.control.d;
import com.testin.javafx.ui.control.m;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CopyScriptManagerController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(CopyScriptManagerController.class);
    private Stage stage;
    private m response = new m();
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    private TilePane tilepaneview;
    @FXML
    AnchorPane copyScriptManagePage;
    @FXML
    Label reNaemLabel;
    @FXML
    ImageView closeBtn;
    @FXML
    HBox versions;
    @FXML
    TextField newCaseName;
    @FXML
    ImageView currentImg;
    VBox newVersionWrapper;
    ImageView addNewVersion = new ImageView();
    @FXML
    Button ok;
    @FXML
    Button cancelBtn;
    private boolean select;
    public static Vector<a> afm = new Vector();
    public String caseName;
    private File of = null;
    @FXML
    BorderPane imageViewWrapper;
    EventHandler<MouseEvent> addNewVersionHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            String eventType = event.getEventType().getName();
            if (eventType.equals("MOUSE_CLICKED")) {
                CopyScriptManagerController.this.addNewVersionApk();
            } else if (eventType.equals("MOUSE_ENTERED")) {
                this.changeImage("add_btn_enter.png", true);
            } else if (eventType.equals("MOUSE_EXITED")) {
                this.changeImage("add_btn_normal.png", false);
            } else if (eventType.equals("MOUSE_PRESSED")) {
                this.changeImage("add_btn_pressed.png", true);
            }
        }

        private void changeImage(String imgName, boolean hand) {
            String url = this.getClass().getResource("/com/testin/javafx/resources/" + imgName).toExternalForm();
            CopyScriptManagerController.this.addNewVersion.setImage(new Image(url));
            CopyScriptManagerController.this.addNewVersion.setFitHeight(50.0);
            CopyScriptManagerController.this.addNewVersion.setFitWidth(50.0);
            if (hand) {
                CopyScriptManagerController.this.addNewVersion.setCursor(Cursor.HAND);
            } else {
                CopyScriptManagerController.this.addNewVersion.setCursor(Cursor.DEFAULT);
            }
        }
    };

    public void initialize(URL location, ResourceBundle resources) {
        String css = b.a().aX();
        this.copyScriptManagePage.getStylesheets().add((Object)css);
        this.reNaemLabel.setTooltip(UIController.getInternationalTooltip("copyscriptmanage.label.rename.tooltip"));
        this.imageViewWrapper.setOpacity(0.8);
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public double getMyPreHeight() {
        return this.copyScriptManagePage.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.copyScriptManagePage.getPrefWidth();
    }

    public m getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    @FXML
    public void currentVerClicked(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            boolean bl = this.select = !this.select;
            if (this.select) {
                UIController.updateNodeSytleClass((Node)this.imageViewWrapper, "imageViewWrapper");
            } else {
                UIController.updateNodeSytleClass((Node)this.imageViewWrapper, "imageViewWrapperInvisible");
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            this.imageViewWrapper.setOpacity(1.0);
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.select) {
                this.imageViewWrapper.setOpacity(1.0);
            } else {
                this.imageViewWrapper.setOpacity(0.8);
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            // empty if block
        }
    }

    @FXML
    public void clickOk(MouseEvent event) {
        String eventType;
        this.caseName = this.newCaseName.getText();
        if (StringUtils.isEmpty((String)this.caseName)) {
            File f2 = new File(k.a().getCasePath());
            String name = f2.getName();
            this.caseName = name = name.substring(0, name.lastIndexOf("_"));
        }
        if ((eventType = event.getEventType().getName()).equals("MOUSE_CLICKED")) {
            this.coptyScript();
        }
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        this.caseName = this.newCaseName.getText();
        if (StringUtils.isEmpty((String)this.caseName)) {
            File f2 = new File(k.a().getCasePath());
            String name = f2.getName();
            this.caseName = name = name.substring(0, name.lastIndexOf("_"));
        }
        if (event.getCharacter().equals("\r")) {
            this.coptyScript();
        }
    }

    public void addNewVersionApk() {
        File f2;
        FileChooser chooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("apk files (*.apk)", new String[]{"*.apk"});
        chooser.getExtensionFilters().add((Object)extFilter);
        if (this.of != null) {
            if (this.of.exists()) {
                chooser.setInitialDirectory(this.of);
            }
        } else {
            try {
                this.of = f.a("apkPath");
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if (this.of != null && this.of.exists()) {
                chooser.setInitialDirectory(this.of);
            }
        }
        if ((f2 = chooser.showOpenDialog((Window)this.stage)) != null) {
            this.of = f2.getParentFile();
            final String filePath = f2.getPath();
            new Thread(){

                @Override
                public void run() {
                    H progressDialog = new H(H.b.c);
                    progressDialog.show();
                    progressDialog.setMessage(d.e("copyscriptmanage.add.newVersion.text"));
                    com.testin.itestin.entitys.a appInfo = new com.testin.itestin.device.tools.a().a(filePath);
                    progressDialog.setProgressValue(15);
                    boolean isSame = com.testin.itestin.business.utils.a.a(appInfo.aI(), afm);
                    boolean parseresult = com.testin.itestin.business.utils.a.a(appInfo, filePath, isSame, progressDialog);
                    if (parseresult) {
                        CopyScriptManagerController.this.loadAppWithSamePkgName(true);
                    }
                }
            }.start();
        }
    }

    public void loadAppWithSamePkgName(final boolean needSelect) {
        if (Platform.isFxApplicationThread()) {
            this.loadApps(needSelect);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    CopyScriptManagerController.this.loadApps(needSelect);
                }
            });
        }
    }

    private void loadApps(boolean needSelect) {
        this.showCurrentVersionInfo();
        if (afm.size() == 0) {
            afm = this.findOtherVersionApks();
        } else if (needSelect) {
            this.refreshAfmValues(this.findOtherVersionApks());
        } else {
            afm.clear();
            afm = this.findOtherVersionApks();
        }
        this.versions.getChildren().clear();
        for (a a2 : afm) {
            VBox box = this.loadFxmlForApkFolder(a2);
            this.versions.getChildren().add((Object)box);
        }
        this.newVersionWrapper = this.getAddNewVersionImage();
        this.newVersionWrapper.addEventHandler(MouseEvent.ANY, this.addNewVersionHandler);
        this.versions.getChildren().add((Object)this.newVersionWrapper);
    }

    private VBox getAddNewVersionImage() {
        VBox box = new VBox();
        String url = ((Object)((Object)this)).getClass().getResource("/com/testin/javafx/resources/add_btn_normal.png").toExternalForm();
        this.addNewVersion.setImage(new Image(url));
        this.addNewVersion.setFitHeight(50.0);
        this.addNewVersion.setFitWidth(50.0);
        box.getChildren().add((Object)this.addNewVersion);
        VBox.setMargin((Node)this.addNewVersion, (Insets)new Insets(2.0, 0.0, 0.0, 0.0));
        return box;
    }

    private void refreshAfmValues(Vector<a> versions) {
        if (afm.size() == versions.size()) {
            return;
        }
        if (afm.size() < versions.size()) {
            for (a a2 : versions) {
                if (com.testin.itestin.business.utils.a.a(a2.getVersion(), afm)) continue;
                afm.add(a2);
            }
        } else {
            Vector<String> ss = new Vector<String>();
            for (a a3 : afm) {
                ss.add(a3.getVersion());
            }
            block2: for (String s2 : ss) {
                if (com.testin.itestin.business.utils.a.a(s2, versions)) continue;
                for (a a4 : afm) {
                    if (!a4.getVersion().equals(s2)) continue;
                    afm.remove(a4);
                    continue block2;
                }
            }
        }
    }

    private void showCurrentVersionInfo() {
        try {
            File f2 = new File(k.a().getCasePath());
            String name = f2.getName();
            name = name.substring(0, name.lastIndexOf("_"));
            if (new File(f2.getParent() + File.separator + "icon.png").exists()) {
                File fi = new File(f2.getParent() + File.separator + "icon.png");
                FileInputStream input = new FileInputStream(fi);
                Image icon = new Image((InputStream)input);
                this.currentImg.setImage(icon);
                ((InputStream)input).close();
            }
            this.newCaseName.setText(name + "_copy");
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
    }

    private VBox loadFxmlForApkFolder(a am) {
        VBox page = new VBox();
        CopyScriptApkFolderController controller = new CopyScriptApkFolderController();
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/com/testin/javafx/ui/apk/ApkFolder.fxml"));
        fxmlLoader.setRoot((Object)controller.vboxholder);
        fxmlLoader.setController((Object)controller);
        try {
            page = (VBox)fxmlLoader.load();
            page.setSpacing(5.0);
            controller.setApkFolderModel(am);
            controller.updateView();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return page;
    }

    private Vector<a> findOtherVersionApks() {
        Vector<a> afm = new Vector<a>();
        String scriptPath = com.testin.itestin.service.a.ac();
        File[] files = new File(scriptPath).listFiles();
        if (files != null && files.length > 0) {
            for (File f2 : files) {
                com.testin.itestin.entitys.a info;
                if (!com.testin.itestin.business.utils.a.b(f2)) continue;
                a am = new a();
                File icon = new File(f2.getPath() + File.separator + "icon.png");
                if (icon.exists()) {
                    am.au(icon.getAbsolutePath());
                }
                if ((info = TestFileUtils.getAppInfo(f2.getPath())) == null) continue;
                am.v(info.getPackageName());
                am.setVersion(info.aI() == null ? "" : info.aI());
                am.a((StringProperty)new SimpleStringProperty(info.getAppName()));
                am.aF(info.getAppName());
                afm.add(am);
            }
        }
        return afm;
    }

    @FXML
    public void csOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void csOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void closeCopyScriptManager() {
        if (this.stage == null) {
            return;
        }
        this.response.a = m.a.d;
        this.stage.close();
    }

    @FXML
    public void closeEnter(MouseEvent event) {
        String url = ((Object)((Object)this)).getClass().getResource("/com/testin/javafx/resources/dialog_close_enter_blue.png").toExternalForm();
        this.closeBtn.setImage(new Image(url));
    }

    @FXML
    public void closeExit(MouseEvent event) {
        String url = ((Object)((Object)this)).getClass().getResource("/com/testin/javafx/resources/dialog_close_blue.png").toExternalForm();
        this.closeBtn.setImage(new Image(url));
    }

    @FXML
    public void okEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_enter");
    }

    @FXML
    public void okExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_normal");
    }

    @FXML
    public void cancelEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelBtn, "buttonstyle_enter");
    }

    @FXML
    public void cancelExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelBtn, "buttonstyle_normal");
    }

    @FXML
    public void showMenu(ContextMenuEvent event) {
    }

    public void coptyScript() {
        String scriptPath = "";
        String newName = "";
        if (!this.caseName.startsWith(" ") && this.caseName.indexOf("/") == -1 && this.caseName.indexOf("\\") == -1 && this.caseName.indexOf("<") == -1 && this.caseName.indexOf(">") == -1) {
            if (this.select) {
                String dir_fn = String.format("%s_%s_dir", k.a().q(), k.a().getVersion());
                scriptPath = "script" + File.separator + dir_fn + File.separator;
                newName = com.testin.itestin.business.utils.a.a(scriptPath, this.caseName);
                com.testin.itestin.business.utils.a.a(scriptPath, newName, false);
                try {
                    File replay = new File(k.a().getCasePath() + File.separator + "replay.apk");
                    if (replay.exists()) {
                        FileUtils.copyFileToDirectory((File)replay, (File)new File(scriptPath + File.separator + newName));
                    }
                }
                catch (IOException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
                b.a().f(k.a().q(), k.a().getAppName(), k.a().getVersion());
            }
            for (a a2 : afm) {
                if (!a2.select) continue;
                scriptPath = com.testin.itestin.business.utils.a.a(a2);
                newName = com.testin.itestin.business.utils.a.a(scriptPath, this.caseName);
                com.testin.itestin.business.utils.a.a(scriptPath, newName, true);
            }
            if (StringUtils.isEmpty((String)scriptPath)) {
                com.testin.javafx.ui.control.d.a(d.a.c, d.e("copyscriptmanage.copy.notice.text.no.select"));
            } else {
                com.testin.javafx.ui.control.d.a(d.a.b, d.e("copyscriptmanage.copy.notice.text"));
                this.stage.close();
            }
        } else {
            com.testin.javafx.ui.control.d.a(d.a.b, d.e("copyscriptmanage.label.textRule"));
            this.stage.show();
        }
    }
}

