/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.business.utils.a;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.d;
import com.testin.javafx.ui.control.m;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.DirectoryChooserBuilder;
import javafx.stage.Stage;
import javafx.stage.Window;

public class ExportDialogWithTypeController
extends AnchorPane
implements Initializable {
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    private static String directory = "";
    @FXML
    AnchorPane AccountSelectDialog;
    @FXML
    TextField value;
    @FXML
    TextField zipName;
    @FXML
    RadioButton cloudType;
    @FXML
    RadioButton localType;
    @FXML
    Button ok;
    @FXML
    Button cancel;
    private Stage stage;
    private m response = new m();
    private String scriptName;
    private String appName;

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setCloudType(boolean disable) {
        this.cloudType.setDisable(!disable);
        if (this.cloudType.isDisable()) {
            this.localType.setSelected(true);
        } else {
            this.cloudType.setSelected(true);
        }
    }

    public void updateZipName() {
        String name = String.format("%s(%s-%s)", this.scriptName, this.appName, com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton1.text"));
        this.zipName.setText(a.i(name));
    }

    public double getMyPreHeight() {
        return this.AccountSelectDialog.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.AccountSelectDialog.getPrefWidth();
    }

    public m getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = b.a().aX();
        this.AccountSelectDialog.getStylesheets().add((Object)css);
    }

    @FXML
    public void clickOk(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        File f2 = new File(this.value.getText());
        if (!f2.exists()) {
            d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("folderselectdialogcontroller.selectClick.nodirectory"));
            return;
        }
        if (this.zipName.getText().equals("") || !a.l(this.zipName.getText())) {
            d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("apkfoldercontroller.handleMenuItem.scriptnameerror"));
            return;
        }
        if (a.a(this.value.getText(), this.zipName.getText() + ".zip").booleanValue()) {
            d.a(d.a.c, com.testin.itestin.business.actions.utils.d.e("folderselectdialogcontroller.selectClick.samename"));
            return;
        }
        this.response.a = m.a.b;
        this.response.value = this.value.getText();
        this.response.jw = this.zipName.getText();
        if (this.cloudType.isSelected()) {
            this.response.jx = "cloud";
        } else if (this.localType.isSelected()) {
            this.response.jx = "local";
        }
        this.stage.close();
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.a = m.a.c;
        this.response.value = null;
        this.stage.close();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (event.getCharacter().equals("\r")) {
            this.clickOk(null);
        }
    }

    @FXML
    public void keyCancel(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.response.a = m.a.c;
            this.response.value = null;
            this.stage.close();
        }
    }

    @FXML
    public void cloudClick(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        if (!this.cloudType.isSelected() && !this.localType.isSelected()) {
            this.cloudType.setSelected(true);
        } else if (this.cloudType.isSelected() && this.localType.isSelected()) {
            this.localType.setSelected(false);
        }
        if (!this.zipName.getText().contains(com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton1.text"))) {
            if (this.zipName.getText().contains(com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton2.text"))) {
                this.zipName.setText(this.zipName.getText().replace(com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton2.text"), com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton1.text")));
            } else {
                this.zipName.setText(this.zipName.getText() + "(" + com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton1.text") + ")");
            }
        }
    }

    @FXML
    public void localClick(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        if (this.cloudType.isSelected()) {
            this.cloudType.setSelected(false);
        }
        if (!this.localType.isSelected() && !this.cloudType.isSelected()) {
            this.localType.setSelected(true);
        } else if (this.localType.isSelected() && this.cloudType.isSelected()) {
            this.cloudType.setSelected(false);
        }
        if (!this.zipName.getText().contains(com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton2.text"))) {
            if (this.zipName.getText().contains(com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton1.text"))) {
                this.zipName.setText(this.zipName.getText().replace(com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton1.text"), com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton2.text")));
            } else {
                this.zipName.setText(this.zipName.getText() + "(" + com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton2.text") + ")");
            }
        }
    }

    @FXML
    public void selectClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            DirectoryChooserBuilder builder = DirectoryChooserBuilder.create();
            String cwd = directory.isEmpty() ? System.getProperty("user.dir") : directory;
            File file = new File(cwd);
            builder.initialDirectory(file);
            DirectoryChooser chooser = builder.build();
            File chosenDir = chooser.showDialog((Window)this.stage);
            if (chosenDir != null) {
                this.value.setText(chosenDir.getAbsolutePath());
                directory = chosenDir.getAbsolutePath();
            }
        }
    }

    @FXML
    public void nameKeyType(KeyEvent event) {
        this.keyOk(event);
    }

    @FXML
    public void cancelEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancel, "buttonstyle_enter");
    }

    @FXML
    public void cancelExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancel, "buttonstyle_normal");
    }

    @FXML
    public void okEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_enter");
    }

    @FXML
    public void okExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_normal");
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

