/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.business.utils.a;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.d;
import com.testin.javafx.ui.control.m;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.DirectoryChooserBuilder;
import javafx.stage.Stage;
import javafx.stage.Window;

public class ExportDialogWithTypeInnerController
extends AnchorPane
implements Initializable {
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    private static String directory = "";
    @FXML
    AnchorPane exportDialogInner;
    @FXML
    TextField value;
    @FXML
    TextField zipName;
    @FXML
    RadioButton cloudType;
    @FXML
    RadioButton localType;
    @FXML
    RadioButton innerType;
    @FXML
    Button ok;
    @FXML
    Button cancel;
    private String scriptName;
    private String appName;
    private Stage stage;
    private m response = new m();
    private ToggleGroup group = new ToggleGroup();

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setCloudType(boolean disable) {
        this.cloudType.setDisable(!disable);
        if (this.cloudType.isDisable()) {
            this.localType.setSelected(true);
        } else {
            this.cloudType.setSelected(true);
        }
    }

    public void setInnerType(boolean disable) {
        this.innerType.setDisable(!disable);
    }

    public void updateZipName() {
        String name = String.format("%s(%s-%s)", this.scriptName, this.appName, com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton1.text"));
        this.zipName.setText(a.i(name));
    }

    public double getMyPreHeight() {
        return this.exportDialogInner.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.exportDialogInner.getPrefWidth();
    }

    public m getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = b.a().aX();
        this.exportDialogInner.getStylesheets().add((Object)css);
        this.cloudType.setToggleGroup(this.group);
        this.cloudType.setUserData((Object)"cloud");
        this.localType.setToggleGroup(this.group);
        this.localType.setUserData((Object)"local");
        this.innerType.setToggleGroup(this.group);
        this.innerType.setUserData((Object)"inner");
        this.group.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> arg0, Object arg1, Object arg2) {
                ExportDialogWithTypeInnerController.this.updateZipName(ExportDialogWithTypeInnerController.this.group.getSelectedToggle().getUserData().toString());
            }
        });
    }

    private void updateZipName(String string) {
        if (string.equals("cloud")) {
            String name = String.format("%s(%s-%s)", this.scriptName, this.appName, com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton1.text"));
            this.zipName.setText(a.i(name));
        } else if (string.equals("local")) {
            String name = String.format("%s(%s-%s)", this.scriptName, this.appName, com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton2.text"));
            this.zipName.setText(a.i(name));
        } else if (string.equals("inner")) {
            String name = String.format("%s(%s-%s)", this.scriptName, this.appName, com.testin.itestin.business.actions.utils.d.e("exporttypeselect.radiobutton.inneruse.text"));
            this.zipName.setText(a.i(name));
        }
    }

    @FXML
    public void clickOk(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        File f2 = new File(this.value.getText());
        if (!f2.exists()) {
            d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("folderselectdialogcontroller.selectClick.nodirectory"));
            return;
        }
        if (this.zipName.getText().equals("") || !a.l(this.zipName.getText())) {
            d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("apkfoldercontroller.handleMenuItem.scriptnameerror"));
            return;
        }
        if (a.a(this.value.getText(), this.zipName.getText() + ".zip").booleanValue()) {
            d.a(d.a.c, com.testin.itestin.business.actions.utils.d.e("folderselectdialogcontroller.selectClick.samename"));
            return;
        }
        this.response.a = m.a.b;
        this.response.value = this.value.getText();
        this.response.jw = this.zipName.getText();
        if (this.cloudType.isSelected()) {
            this.response.jx = "cloud";
        } else if (this.localType.isSelected()) {
            this.response.jx = "local";
        } else if (this.innerType.isSelected()) {
            this.response.jx = "inner";
        }
        System.err.println("select: " + this.response.jx);
        this.stage.close();
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.a = m.a.c;
        this.response.value = null;
        this.stage.close();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (event.getCharacter().equals("\r")) {
            this.clickOk(null);
        }
    }

    @FXML
    public void keyCancel(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.response.a = m.a.c;
            this.response.value = null;
            this.stage.close();
        }
    }

    @FXML
    public void selectClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            DirectoryChooserBuilder builder = DirectoryChooserBuilder.create();
            String cwd = directory.isEmpty() ? System.getProperty("user.dir") : directory;
            File file = new File(cwd);
            builder.initialDirectory(file);
            DirectoryChooser chooser = builder.build();
            File chosenDir = chooser.showDialog((Window)this.stage);
            if (chosenDir != null) {
                this.value.setText(chosenDir.getAbsolutePath());
                directory = chosenDir.getAbsolutePath();
            }
        }
    }

    @FXML
    public void nameKeyType(KeyEvent event) {
        this.keyOk(event);
    }

    @FXML
    public void cancelEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancel, "buttonstyle_enter");
    }

    @FXML
    public void cancelExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancel, "buttonstyle_normal");
    }

    @FXML
    public void okEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_enter");
    }

    @FXML
    public void okExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_normal");
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

