/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.actions.coord.r;
import com.testin.itestin.business.actions.utils.d;
import com.testin.itestin.business.actions.utils.g;
import com.testin.itestin.business.k;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.util.n;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.m;
import com.testin.javafx.ui.control.w;
import java.net.URL;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.apache.log4j.Logger;

public class ImageInputDialogController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(ImageInputDialogController.class);
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    Label message;
    @FXML
    AnchorPane ImageInputDialog;
    @FXML
    AnchorPane imageAnchorPane;
    @FXML
    TextArea value;
    @FXML
    Button ok;
    @FXML
    Button cancelBtn;
    @FXML
    RadioButton usernameOpt;
    @FXML
    RadioButton passwordOpt;
    @FXML
    RadioButton normaltextOpt;
    @FXML
    RadioButton randomtextOpt;
    @FXML
    RadioButton randomnumOpt;
    @FXML
    RadioButton variableOpt;
    @FXML
    ImageView image;
    @FXML
    Label errorprompt;
    @FXML
    RadioButton back;
    @FXML
    RadioButton enter;
    @FXML
    GridPane variablePane;
    @FXML
    ComboBox<String> cmbVariable;
    @FXML
    Label lblValue;
    @FXML
    CheckBox clear;
    private static double mScale = 1.0;
    public w canvas;
    private double imageValueW;
    private double imageValueH;
    private Stage stage;
    private m response = new m();
    private ToggleGroup group = new ToggleGroup();
    private ToggleGroup typeGroup = new ToggleGroup();

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setOriImageW(double w2) {
        this.imageValueW = w2;
    }

    public void setOriImageH(double h2) {
        this.imageValueH = h2;
    }

    private void getScale() {
        double scaleX = this.image.getFitWidth() / this.imageValueW;
        double scaleY = this.image.getFitHeight() / this.imageValueH;
        mScale = Math.min(scaleX, scaleY);
    }

    public static double getMScale() {
        return mScale;
    }

    public void setCanvas() {
        this.getScale();
        this.canvas = new w(mScale * this.imageValueW, mScale * this.imageValueH);
        this.imageAnchorPane.getChildren().add((Object)this.canvas);
    }

    public void setPoint(r cp) {
        r p2 = new r();
        p2.setX(this.canvas.b(cp.getX(), g.b(mScale * this.imageValueW)));
        p2.setY(this.canvas.b(cp.getY(), g.b(mScale * this.imageValueH)));
        p2.setTime(cp.getTime());
        p2.e(cp.g());
        this.canvas.b(p2);
        this.canvas.a(cp);
    }

    public double getMyPreHeight() {
        return this.ImageInputDialog.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.ImageInputDialog.getPrefWidth();
    }

    public void setMessage(String message) {
        if (this.stage == null) {
            return;
        }
        this.message.setText(message);
    }

    public m getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void setValue(String value) {
        if (this.stage == null) {
            return;
        }
        this.response.value = value;
        this.value.setText(value);
    }

    @FXML
    public void okEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_enter");
    }

    @FXML
    public void okExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_normal");
    }

    @FXML
    public void cancelEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelBtn, "buttonstyle_enter");
    }

    @FXML
    public void cancelExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelBtn, "buttonstyle_normal");
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = b.a().aX();
        this.ImageInputDialog.getStylesheets().add((Object)css);
        this.usernameOpt.setToggleGroup(this.group);
        this.usernameOpt.setUserData((Object)"username");
        this.passwordOpt.setToggleGroup(this.group);
        this.passwordOpt.setUserData((Object)"password");
        this.normaltextOpt.setToggleGroup(this.group);
        this.normaltextOpt.setUserData((Object)"text");
        this.randomtextOpt.setToggleGroup(this.group);
        this.randomtextOpt.setUserData((Object)"randomtext");
        this.randomnumOpt.setToggleGroup(this.group);
        this.randomnumOpt.setUserData((Object)"randomnum");
        this.usernameOpt.setSelected(true);
        this.variableOpt.setToggleGroup(this.group);
        this.variableOpt.setUserData((Object)"variable");
        this.back.setToggleGroup(this.typeGroup);
        this.back.setUserData((Object)"back");
        this.enter.setToggleGroup(this.typeGroup);
        this.enter.setUserData((Object)"enter");
        this.enter.setSelected(true);
        this.cmbVariable.getItems().addAll(k.a().a().keySet());
        this.group.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> arg0, Object arg1, Object arg2) {
                ImageInputDialogController.this.errorprompt.setText("");
                ImageInputDialogController.this.value.setVisible(true);
                ImageInputDialogController.this.variablePane.setVisible(false);
                if (((RadioButton)arg2).getUserData() == "randomtext" || ((RadioButton)arg2).getUserData() == "randomnum") {
                    System.out.println("random");
                    ImageInputDialogController.this.message.setText(d.e("coordemulatorcontroller.handlemenuitem.text4"));
                } else if (ImageInputDialogController.this.group.getSelectedToggle().getUserData() == "variable") {
                    ImageInputDialogController.this.message.setText(d.e("coordemulatorcontroller.handlemenuitem.text7"));
                    ImageInputDialogController.this.value.setVisible(false);
                    ImageInputDialogController.this.variablePane.setVisible(true);
                } else {
                    System.out.println("putong");
                    ImageInputDialogController.this.message.setText(d.e("coordemulatorcontroller.handlemenuitem.text6"));
                }
            }
        });
        this.value.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ImageInputDialogController.this.checkInputValue(newValue);
            }
        });
    }

    private void checkInputValue(String newValue) {
        if (this.group.getSelectedToggle().getUserData() == "randomtext" || this.group.getSelectedToggle().getUserData() == "randomnum") {
            this.checkRandomInput(newValue);
        } else if (this.group.getSelectedToggle().getUserData().toString().equals("typetext")) {
            if (g.a((CharSequence)newValue)) {
                this.errorprompt.setText(d.e("inputdialog.typetext.prompt"));
            } else {
                this.errorprompt.setText("");
            }
        } else if (newValue.length() > 100) {
            this.errorprompt.setText(d.e("inputdialog.text.toolong.prompt"));
        } else if (this.group.getSelectedToggle().getUserData().toString().equals("username") || this.group.getSelectedToggle().getUserData().toString().equals("password")) {
            if (newValue.contains("\n")) {
                this.errorprompt.setText(d.e("inputdialog.usernamepassword.prompt"));
            } else {
                this.errorprompt.setText("");
            }
        } else {
            this.errorprompt.setText("");
        }
    }

    @FXML
    public void clickOk(MouseEvent event) {
        this.submitInput();
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.cancelInput();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void keyText(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r") && (this.randomtextOpt.isSelected() || this.passwordOpt.isSelected() || this.usernameOpt.isSelected() || this.randomnumOpt.isSelected() || this.variableOpt.isSelected())) {
            this.submitInput();
        }
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.submitInput();
        }
    }

    @FXML
    public void keyCancel(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.cancelInput();
        }
    }

    @FXML
    public void backClick(MouseEvent event) {
    }

    @FXML
    public void enterClick(MouseEvent event) {
    }

    private void submitInput() {
        this.checkInputValue(this.value.getText());
        if (this.stage == null || !this.errorprompt.getText().equals("")) {
            return;
        }
        if (this.variableOpt.isSelected() ? this.lblValue.getText().isEmpty() : this.value.getText().isEmpty()) {
            this.errorprompt.setText(d.e("scriptshowcontroller.handlemenuitem.alterconnull"));
            return;
        }
        this.response.a = m.a.b;
        if (this.randomtextOpt.isSelected()) {
            int len;
            String randValue = this.value.getText();
            if (randValue.endsWith("\n")) {
                randValue = randValue.replace("\n", "");
            }
            if (n.isNumber(randValue) && (len = Integer.parseInt(randValue)) > 0 && len <= 20) {
                this.response.value = g.b(Integer.parseInt(randValue));
            }
        } else if (this.randomnumOpt.isSelected()) {
            int len;
            String randValue = this.value.getText();
            if (randValue.endsWith("\n")) {
                randValue = randValue.replace("\n", "");
            }
            if (n.isNumber(randValue) && (len = Integer.parseInt(randValue)) > 0 && len <= 20) {
                this.response.value = g.c(Integer.parseInt(randValue));
            }
        } else {
            this.response.value = this.variableOpt.isSelected() ? this.lblValue.getText() : this.value.getText().replace("\n", "##@@");
        }
        this.response.jw = this.group.getSelectedToggle().getUserData().toString();
        this.response.jx = this.typeGroup.getSelectedToggle().getUserData().toString();
        this.response.jy = (String)this.cmbVariable.getValue();
        this.response.a = this.canvas.a();
        this.response.selected = this.clear.isSelected();
        this.stage.close();
    }

    private void checkRandomInput(String value) {
        String newValue = value;
        if (newValue.length() > 1 && newValue.endsWith("\n")) {
            newValue = newValue.replace("\n", "");
        }
        if (!n.isNumber(newValue)) {
            this.errorprompt.setText(d.e("inputdialog.randomtext.prompt"));
        } else {
            try {
                int len = Integer.parseInt(newValue);
                if (len > 0 && len <= 20) {
                    this.errorprompt.setText("");
                } else {
                    this.errorprompt.setText(d.e("inputdialog.randomtext.prompt"));
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private void cancelInput() {
        this.response.a = m.a.c;
        this.response.value = null;
        this.stage.close();
    }

    public void setActionRule(com.testin.itestin.business.actions.b rule) {
        if (rule != null) {
            switch (3.$SwitchMap$com$testin$itestin$business$actions$ActionRule[rule.ordinal()]) {
                case 1: {
                    this.usernameOpt.setSelected(true);
                    break;
                }
                case 2: {
                    this.passwordOpt.setSelected(true);
                    break;
                }
                case 3: {
                    this.normaltextOpt.setSelected(true);
                    break;
                }
                case 4: {
                    this.randomtextOpt.setSelected(true);
                    break;
                }
                case 5: {
                    this.randomnumOpt.setSelected(true);
                    break;
                }
                case 6: {
                    this.variableOpt.setSelected(true);
                    break;
                }
            }
        }
    }

    public void setImage(Image value) {
        this.image.setImage(value);
    }

    public void varOnAction(ActionEvent actionEvent) {
        Hashtable<String, String> variables = k.a().a();
        String key = (String)this.cmbVariable.getSelectionModel().getSelectedItem();
        if (key != null && !key.isEmpty()) {
            this.lblValue.setText(variables.get(key));
        }
    }
}

