/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.actions.utils.d;
import com.testin.itestin.business.k;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.util.n;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.m;
import java.net.URL;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.apache.log4j.Logger;

public class InputDialogWithOptionsController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(InputDialogWithOptionsController.class);
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    Label message;
    @FXML
    AnchorPane InputDialogWithOptions;
    @FXML
    TextArea value;
    @FXML
    Button ok;
    @FXML
    Button cancelBtn;
    @FXML
    RadioButton usernameOpt;
    @FXML
    RadioButton passwordOpt;
    @FXML
    RadioButton normaltextOpt;
    @FXML
    RadioButton randomtextOpt;
    @FXML
    RadioButton randomnumOpt;
    @FXML
    RadioButton typetextOpt;
    @FXML
    RadioButton variableOpt;
    @FXML
    Label errorprompt;
    @FXML
    Label lblValue;
    @FXML
    ComboBox<String> cmbVariable;
    @FXML
    GridPane variablePane;
    private Stage stage;
    private m response = new m();
    private ToggleGroup group = new ToggleGroup();

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public double getMyPreHeight() {
        return this.InputDialogWithOptions.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.InputDialogWithOptions.getPrefWidth();
    }

    public void setMessage(String message) {
        if (this.stage == null) {
            return;
        }
        this.message.setText(message);
    }

    public m getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void setValue(String value) {
        if (this.stage == null) {
            return;
        }
        this.response.value = value;
        this.value.setText(value);
    }

    @FXML
    public void okEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_enter");
    }

    @FXML
    public void okExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_normal");
    }

    @FXML
    public void cancelEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelBtn, "buttonstyle_enter");
    }

    @FXML
    public void cancelExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelBtn, "buttonstyle_normal");
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = b.a().aX();
        this.InputDialogWithOptions.getStylesheets().add((Object)css);
        this.usernameOpt.setToggleGroup(this.group);
        this.usernameOpt.setUserData((Object)"username");
        this.passwordOpt.setToggleGroup(this.group);
        this.passwordOpt.setUserData((Object)"password");
        this.normaltextOpt.setToggleGroup(this.group);
        this.normaltextOpt.setUserData((Object)"text");
        this.randomtextOpt.setToggleGroup(this.group);
        this.randomtextOpt.setUserData((Object)"randomtext");
        this.randomnumOpt.setToggleGroup(this.group);
        this.randomnumOpt.setUserData((Object)"randomnum");
        this.typetextOpt.setToggleGroup(this.group);
        this.typetextOpt.setUserData((Object)"typetext");
        this.variableOpt.setToggleGroup(this.group);
        this.variableOpt.setUserData((Object)"variable");
        this.usernameOpt.setSelected(true);
        this.cmbVariable.getItems().addAll(k.a().a().keySet());
        this.group.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> arg0, Object arg1, Object arg2) {
                InputDialogWithOptionsController.this.variablePane.setVisible(false);
                InputDialogWithOptionsController.this.value.setVisible(true);
                InputDialogWithOptionsController.this.errorprompt.setText("");
                if (InputDialogWithOptionsController.this.group.getSelectedToggle().getUserData() == "randomtext" || InputDialogWithOptionsController.this.group.getSelectedToggle().getUserData() == "randomnum") {
                    InputDialogWithOptionsController.this.value.setText("");
                } else if (InputDialogWithOptionsController.this.group.getSelectedToggle().getUserData().toString().equals("variable")) {
                    InputDialogWithOptionsController.this.message.setText(d.e("coordemulatorcontroller.handlemenuitem.text7"));
                    InputDialogWithOptionsController.this.variablePane.setVisible(true);
                    InputDialogWithOptionsController.this.value.setVisible(false);
                } else if (InputDialogWithOptionsController.this.group.getSelectedToggle().getUserData().toString().equals("username") || InputDialogWithOptionsController.this.group.getSelectedToggle().getUserData().toString().equals("password")) {
                    InputDialogWithOptionsController.this.value.setText(InputDialogWithOptionsController.this.value.getText().split("\n")[0]);
                }
            }
        });
        this.value.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                InputDialogWithOptionsController.this.checkInputValue(newValue);
            }
        });
    }

    private void checkInputValue(String newValue) {
        if (this.group.getSelectedToggle().getUserData() == "randomtext" || this.group.getSelectedToggle().getUserData() == "randomnum") {
            this.checkRandomInput(newValue);
        } else if (this.group.getSelectedToggle().getUserData().toString().equals("variable")) {
            if (this.lblValue.getText().isEmpty()) {
                this.errorprompt.setText(d.e("scriptshowcontroller.handlemenuitem.alterconnull"));
            } else {
                this.errorprompt.setText("");
            }
        } else if (newValue.length() > 100) {
            this.errorprompt.setText(d.e("inputdialog.text.toolong.prompt"));
        } else {
            this.errorprompt.setText("");
        }
    }

    @FXML
    public void clickOk(MouseEvent event) {
        this.submitInput();
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.cancelInput();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void keyText(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r") && !this.normaltextOpt.isSelected() && !this.typetextOpt.isSelected()) {
            this.submitInput();
        }
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.submitInput();
        }
    }

    @FXML
    public void keyCancel(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.cancelInput();
        }
    }

    private void submitInput() {
        this.checkInputValue(this.value.getText());
        if (this.stage == null || !this.errorprompt.getText().equals("")) {
            return;
        }
        this.response.a = m.a.b;
        this.response.value = this.usernameOpt.isSelected() || this.passwordOpt.isSelected() || this.randomtextOpt.isSelected() || this.randomnumOpt.isSelected() ? this.value.getText().replace("\n", "") : (this.variableOpt.isSelected() ? this.lblValue.getText() : this.value.getText().replace("\n", "##@@"));
        this.response.jw = this.group.getSelectedToggle().getUserData().toString();
        this.response.jx = (String)this.cmbVariable.getValue();
        this.stage.close();
    }

    private void checkRandomInput(String value) {
        String newValue = value.replace("\n", "");
        this.value.setText(newValue);
        if (!n.isNumber(newValue)) {
            this.errorprompt.setText(d.e("inputdialog.randomtext.prompt"));
        } else {
            try {
                int len = Integer.parseInt(newValue);
                if (len > 0 && len <= 20) {
                    this.errorprompt.setText("");
                } else {
                    this.errorprompt.setText(d.e("inputdialog.randomtext.prompt"));
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private void cancelInput() {
        this.response.a = m.a.c;
        this.response.value = null;
        this.stage.close();
    }

    public void setActionRule(com.testin.itestin.business.actions.b rule) {
        if (rule != null) {
            switch (3.$SwitchMap$com$testin$itestin$business$actions$ActionRule[rule.ordinal()]) {
                case 1: {
                    this.usernameOpt.setSelected(true);
                    break;
                }
                case 2: {
                    this.passwordOpt.setSelected(true);
                    break;
                }
                case 3: {
                    this.normaltextOpt.setSelected(true);
                    break;
                }
                case 4: {
                    this.randomtextOpt.setSelected(true);
                    break;
                }
                case 5: {
                    this.randomnumOpt.setSelected(true);
                    break;
                }
                case 6: {
                    this.typetextOpt.setSelected(true);
                    break;
                }
                case 7: {
                    this.variableOpt.setSelected(true);
                }
            }
        }
    }

    public void varOnAction(ActionEvent actionEvent) {
        Hashtable<String, String> variables = k.a().a();
        String key = (String)this.cmbVariable.getSelectionModel().getSelectedItem();
        if (key != null && !key.isEmpty()) {
            this.lblValue.setText(variables.get(key));
        }
    }
}

