/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.actions.coord.r;
import com.testin.itestin.business.actions.utils.g;
import com.testin.itestin.business.k;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.util.n;
import com.testin.javafx.a;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.MTrailImageControllerSet;
import com.testin.javafx.ui.control.d;
import com.testin.javafx.ui.control.m;
import com.testin.javafx.ui.include.MTrailImageController;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.apache.log4j.Logger;

public class MImageInputDialogController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(MImageInputDialogController.class);
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    Label message;
    @FXML
    AnchorPane MImageInputDialog;
    @FXML
    AnchorPane imageAnchorPane;
    @FXML
    TextArea value;
    @FXML
    Button ok;
    @FXML
    Button cancelBtn;
    @FXML
    RadioButton usernameOpt;
    @FXML
    RadioButton passwordOpt;
    @FXML
    RadioButton normaltextOpt;
    @FXML
    RadioButton randomtextOpt;
    @FXML
    RadioButton randomnumOpt;
    @FXML
    Label errorprompt;
    @FXML
    RadioButton back;
    @FXML
    RadioButton enter;
    @FXML
    GridPane gridPane;
    @FXML
    ComboBox<String> cmbVariable;
    @FXML
    Label lblValue;
    @FXML
    GridPane variablePane;
    @FXML
    RadioButton variableOpt;
    private static double mScale = 1.0;
    private Stage stage;
    private m response = new m();
    private ToggleGroup group = new ToggleGroup();
    private ToggleGroup typeGroup = new ToggleGroup();

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public static double getMScale() {
        return mScale;
    }

    public double getMyPreHeight() {
        return this.MImageInputDialog.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.MImageInputDialog.getPrefWidth();
    }

    public void setMessage(String message) {
        if (this.stage == null) {
            return;
        }
        this.message.setText(message);
    }

    public m getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void setValue(String value) {
        if (this.stage == null) {
            return;
        }
        this.response.value = value;
        this.value.setText(value);
    }

    @FXML
    public void okEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_enter");
    }

    @FXML
    public void okExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_normal");
    }

    @FXML
    public void cancelEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelBtn, "buttonstyle_enter");
    }

    @FXML
    public void cancelExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancelBtn, "buttonstyle_normal");
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = b.a().aX();
        this.MImageInputDialog.getStylesheets().add((Object)css);
        this.usernameOpt.setToggleGroup(this.group);
        this.usernameOpt.setUserData((Object)"username");
        this.passwordOpt.setToggleGroup(this.group);
        this.passwordOpt.setUserData((Object)"password");
        this.normaltextOpt.setToggleGroup(this.group);
        this.normaltextOpt.setUserData((Object)"text");
        this.randomtextOpt.setToggleGroup(this.group);
        this.randomtextOpt.setUserData((Object)"randomtext");
        this.variableOpt.setToggleGroup(this.group);
        this.variableOpt.setUserData((Object)"variable");
        this.usernameOpt.setSelected(true);
        this.back.setToggleGroup(this.typeGroup);
        this.back.setUserData((Object)"back");
        this.enter.setToggleGroup(this.typeGroup);
        this.enter.setUserData((Object)"enter");
        this.enter.setSelected(true);
        this.cmbVariable.getItems().addAll(k.a().a().keySet());
        this.group.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> arg0, Object arg1, Object arg2) {
                MImageInputDialogController.this.errorprompt.setText("");
                MImageInputDialogController.this.variablePane.setVisible(false);
                MImageInputDialogController.this.value.setVisible(true);
                if (MImageInputDialogController.this.group.getSelectedToggle().getUserData().toString().equals("randomtext")) {
                    MImageInputDialogController.this.message.setText(com.testin.itestin.business.actions.utils.d.e("coordemulatorcontroller.handlemenuitem.text4"));
                    MImageInputDialogController.this.value.setText("");
                } else if (MImageInputDialogController.this.group.getSelectedToggle().getUserData().toString().equals("variable")) {
                    MImageInputDialogController.this.message.setText(com.testin.itestin.business.actions.utils.d.e("coordemulatorcontroller.handlemenuitem.text7"));
                    MImageInputDialogController.this.variablePane.setVisible(true);
                    MImageInputDialogController.this.value.setVisible(false);
                } else {
                    MImageInputDialogController.this.message.setText(com.testin.itestin.business.actions.utils.d.e("coordemulatorcontroller.handlemenuitem.text6"));
                    if (MImageInputDialogController.this.group.getSelectedToggle().getUserData().toString().equals("username") || MImageInputDialogController.this.group.getSelectedToggle().getUserData().toString().equals("password")) {
                        MImageInputDialogController.this.value.setText(MImageInputDialogController.this.value.getText().split("\n")[0]);
                    }
                }
            }
        });
        this.value.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                MImageInputDialogController.this.checkInputValue(newValue);
            }
        });
    }

    private void checkInputValue(String newValue) {
        if (this.group.getSelectedToggle().getUserData().toString().equals("randomtext")) {
            this.checkRandomInput(newValue);
        } else if (this.group.getSelectedToggle().getUserData().toString().equals("typetext")) {
            if (g.a((CharSequence)newValue)) {
                this.errorprompt.setText(com.testin.itestin.business.actions.utils.d.e("inputdialog.typetext.prompt"));
            } else {
                this.errorprompt.setText("");
            }
        } else if (newValue.length() > 100) {
            this.errorprompt.setText(com.testin.itestin.business.actions.utils.d.e("inputdialog.text.toolong.prompt"));
        } else {
            this.errorprompt.setText("");
        }
    }

    @FXML
    public void clickOk(MouseEvent event) {
        this.submitInput();
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.cancelInput();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void keyText(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r") && (this.randomtextOpt.isSelected() || this.passwordOpt.isSelected() || this.usernameOpt.isSelected())) {
            this.submitInput();
        }
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.submitInput();
        }
    }

    @FXML
    public void keyCancel(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.cancelInput();
        }
    }

    @FXML
    public void backClick(MouseEvent event) {
    }

    @FXML
    public void enterClick(MouseEvent event) {
    }

    private void submitInput() {
        this.checkInputValue(this.value.getText());
        if (this.stage == null || !this.errorprompt.getText().equals("")) {
            return;
        }
        if (this.variableOpt.isSelected() ? this.lblValue.getText().isEmpty() : this.value.getText().isEmpty()) {
            this.errorprompt.setText(com.testin.itestin.business.actions.utils.d.e("scriptshowcontroller.handlemenuitem.alterconnull"));
            return;
        }
        this.response.a = m.a.b;
        if (this.randomtextOpt.isSelected()) {
            int len;
            String randValue = this.value.getText();
            if (randValue.endsWith("\n")) {
                randValue = randValue.replace("\n", "");
            }
            if (n.isNumber(randValue) && (len = Integer.parseInt(randValue)) > 0 && len <= 20) {
                this.response.value = g.b(Integer.parseInt(randValue));
            }
        } else {
            this.response.value = this.variableOpt.isSelected() ? this.lblValue.getText() : this.value.getText();
        }
        this.response.jw = this.group.getSelectedToggle().getUserData().toString();
        this.response.jx = this.typeGroup.getSelectedToggle().getUserData().toString();
        this.response.jy = (String)this.cmbVariable.getValue();
        this.response.pointList = new ArrayList();
        for (String name : MTrailImageControllerSet.getMTrailImageControllerSet().keySet()) {
            MTrailImageController mtic = MTrailImageControllerSet.get(name);
            if (mtic.canvas.r() == null || mtic.canvas.r().isEmpty()) {
                d.a(d.a.c, com.testin.itestin.business.actions.utils.d.e("traildialogcontroller.warn.trailisnull"));
                return;
            }
            this.response.pointList.add(mtic.canvas.r());
        }
        this.stage.close();
    }

    private void checkRandomInput(String value) {
        String newValue = value;
        if (newValue.length() > 1 && newValue.endsWith("\n")) {
            newValue = newValue.replace("\n", "");
        }
        if (!n.isNumber(newValue)) {
            this.errorprompt.setText(com.testin.itestin.business.actions.utils.d.e("inputdialog.randomtext.prompt"));
        } else {
            try {
                int len = Integer.parseInt(newValue);
                if (len > 0 && len <= 20) {
                    this.errorprompt.setText("");
                } else {
                    this.errorprompt.setText(com.testin.itestin.business.actions.utils.d.e("inputdialog.randomtext.prompt"));
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private void cancelInput() {
        this.response.a = m.a.c;
        this.response.value = null;
        this.stage.close();
    }

    public void setActionRule(com.testin.itestin.business.actions.b rule) {
        if (rule != null) {
            switch (3.$SwitchMap$com$testin$itestin$business$actions$ActionRule[rule.ordinal()]) {
                case 1: {
                    this.usernameOpt.setSelected(true);
                    break;
                }
                case 2: {
                    this.passwordOpt.setSelected(true);
                    break;
                }
                case 3: {
                    this.normaltextOpt.setSelected(true);
                    break;
                }
                case 4: {
                    this.randomtextOpt.setSelected(true);
                    break;
                }
                case 5: {
                    this.randomnumOpt.setSelected(true);
                    break;
                }
                case 6: {
                    this.variableOpt.setSelected(true);
                    break;
                }
            }
        }
    }

    public void setImage(ArrayList<String> fileName, ArrayList<Image> value, boolean isTrail) {
        MTrailImageControllerSet.reset();
        for (int i2 = 0; i2 < value.size(); ++i2) {
            String fxml = "/com/testin/javafx/ui/include/MTrailImage.fxml";
            a page = null;
            try {
                page = com.testin.itestin.business.utils.a.getAnchorPanePageInfo(fxml);
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
            if (null == page) {
                return;
            }
            MTrailImageController mtic = (MTrailImageController)page.a();
            r cp = new r();
            cp.setX(0.5f);
            cp.setY(0.5f);
            mtic.setImage(value.get(i2), isTrail, cp);
            MTrailImageControllerSet.put(fileName.get(i2), mtic);
            this.gridPane.setPadding(new Insets(0.0, 2.0, 0.0, 2.0));
            this.gridPane.add((Node)mtic.getImagePane(), i2, 0);
        }
    }

    public void varOnAction(ActionEvent actionEvent) {
        Hashtable<String, String> variables = k.a().a();
        String key = (String)this.cmbVariable.getSelectionModel().getSelectedItem();
        if (key != null && !key.isEmpty()) {
            this.lblValue.setText(variables.get(key));
        }
    }
}

