/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.TestFileUtils;
import com.testin.itestin.business.actions.coord.i;
import com.testin.itestin.business.actions.coord.o;
import com.testin.itestin.business.actions.k;
import com.testin.itestin.business.actions.u;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.entitys.h;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.d;
import com.testin.javafx.ui.include.logic.ScriptShowControllerLogic;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class VariableSetDialogController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(VariableSetDialogController.class);
    private Stage stage;
    @FXML
    AnchorPane variablePane;
    @FXML
    TableView<h> varTable;
    @FXML
    Label closeBtn;
    @FXML
    Button varok;
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    ScriptShowControllerLogic logic;
    private BooleanProperty isDisableOkProperty = new SimpleBooleanProperty((Object)this, "isChanged", true);

    public void setLogic(ScriptShowControllerLogic logic) {
        this.logic = logic;
    }

    @FXML
    public void addVariableClick() {
        this.showAddVariableDialog(this.stage, this.varTable, null);
    }

    @FXML
    public void okbtnClick() {
        Hashtable vars = (Hashtable)com.testin.itestin.business.k.a().a().clone();
        com.testin.itestin.business.k.a().a().clear();
        for (int i2 = this.varTable.getItems().size() - 1; i2 > -1; --i2) {
            h var2 = (h)this.varTable.getItems().get(i2);
            com.testin.itestin.business.k.a().a().put(var2.getKey(), var2.getValue());
        }
        if (com.testin.itestin.business.k.a().u()) {
            this.stage.close();
            this.varTable.getItems().stream().filter(var -> vars.containsKey(var.getKey()) && !((String)vars.get(var.getKey())).equals(var.getValue())).forEach(var -> this.updataVairable((h)var));
        }
    }

    @FXML
    public void cancelClick() {
        this.stage.close();
    }

    public void closeClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            this.stage.close();
            com.testin.javafx.ui.control.export.data.b.a().aD();
        } else if (eventType.equals("MOUSE_ENTERED")) {
            UIController.updateNodeSytleClass((Node)this.closeBtn, "closeBlueEnter");
        } else if (eventType.equals("MOUSE_EXITED")) {
            UIController.updateNodeSytleClass((Node)this.closeBtn, "closeBlueNormal");
        } else if (eventType.equals("MOUSE_PRESSED")) {
            UIController.updateNodeSytleClass((Node)this.closeBtn, "closeBluePressed");
        }
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    private void showAddVariableDialog(Stage parent, TableView<h> table, h variable) {
        Stage dialog = new Stage();
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.initOwner((Window)b.a().a());
        dialog.initStyle(StageStyle.UNDECORATED);
        dialog.setResizable(false);
        GridPane grid = new GridPane();
        TextField keyField = new TextField();
        TextField valueField = new TextField();
        grid.setOnMousePressed(event -> {
            this.mouseDragOffsetX = event.getSceneX();
            this.mouseDragOffsetY = event.getSceneY();
        });
        grid.setOnMouseDragged(event -> {
            dialog.setX(event.getScreenX() - this.mouseDragOffsetX);
            dialog.setY(event.getScreenY() - this.mouseDragOffsetY);
        });
        Label keyLbl = new Label(com.testin.itestin.business.actions.utils.d.e("variable.record.colum.name") + ":");
        keyLbl.setPrefWidth(70.0);
        keyLbl.setTextAlignment(TextAlignment.RIGHT);
        keyLbl.setAlignment(Pos.BASELINE_RIGHT);
        Label valueLbl = new Label(com.testin.itestin.business.actions.utils.d.e("variable.record.colum.default") + ":");
        valueLbl.setTextAlignment(TextAlignment.RIGHT);
        valueLbl.setAlignment(Pos.BASELINE_RIGHT);
        valueLbl.setPrefWidth(70.0);
        if (variable != null) {
            keyField.setDisable(true);
            keyField.setText(variable.getKey());
            valueField.setText(variable.getValue());
        }
        grid.add((Node)keyLbl, 0, 0);
        grid.add((Node)keyField, 1, 0);
        grid.add((Node)valueLbl, 0, 1);
        grid.add((Node)valueField, 1, 1);
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        GridPane.setHgrow((Node)keyField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)valueField, (Priority)Priority.ALWAYS);
        Button ok = new Button(com.testin.itestin.business.actions.utils.d.e("variable.record.dialog.ok"));
        ok.setDefaultButton(true);
        Button cancel = new Button(com.testin.itestin.business.actions.utils.d.e("variable.record.dialog.cancel"));
        cancel.setCancelButton(true);
        ok.disableProperty().bind((ObservableValue)keyField.textProperty().isEmpty().or((ObservableBooleanValue)valueField.textProperty().isEmpty()));
        ok.setOnAction(actionEvent -> {
            String key = keyField.getText().trim();
            String value = valueField.getText().trim();
            if (variable == null) {
                if (key.isEmpty() || value.isEmpty()) {
                    return;
                }
                for (h item : this.varTable.getItems()) {
                    if (!item.getKey().equals(key)) continue;
                    d.a(d.a.c, com.testin.itestin.business.actions.utils.d.e("variable.add.warn"));
                    return;
                }
                table.getItems().add((Object)new h(key, value));
            } else {
                variable.setValue(value);
            }
            this.isDisableOkProperty.set(false);
            dialog.close();
        });
        cancel.setOnAction(actionEvent -> dialog.close());
        HBox buttons = ((HBoxBuilder)HBoxBuilder.create().spacing(10.0).children(new Node[]{ok, cancel})).alignment(Pos.CENTER_RIGHT).build();
        VBox layout = new VBox(10.0);
        layout.getChildren().addAll((Object[])new Node[]{grid, buttons});
        layout.setPadding(new Insets(5.0));
        dialog.setScene(new Scene((Parent)layout));
        dialog.showAndWait();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.varTable.setEditable(false);
        this.variablePane.getStylesheets().add((Object)b.a().aX());
        final TableColumn keyCol = new TableColumn(com.testin.itestin.business.actions.utils.d.e("variable.record.colum.name"));
        keyCol.setCellValueFactory((Callback)new PropertyValueFactory("key"));
        keyCol.setPrefWidth(120.0);
        keyCol.setSortable(false);
        final TableColumn valueCol = new TableColumn(com.testin.itestin.business.actions.utils.d.e("variable.record.colum.default"));
        valueCol.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        valueCol.setPrefWidth(150.0);
        valueCol.setSortable(false);
        final TableColumn actionCol = new TableColumn(com.testin.itestin.business.actions.utils.d.e("scriptmanagercontroller.initialize.columntext7"));
        actionCol.setPrefWidth(120.0);
        actionCol.setSortable(false);
        actionCol.setCellValueFactory(features -> new SimpleBooleanProperty(features.getValue() != null));
        actionCol.setCellFactory(personBooleanTableColumn -> new DeleteVariableCell(this.varTable));
        this.varTable.getColumns().setAll((Object[])new TableColumn[]{keyCol, valueCol, actionCol});
        this.varTable.setEditable(false);
        Hashtable<String, String> variables = com.testin.itestin.business.k.a().a();
        for (String key : variables.keySet()) {
            this.varTable.getItems().add((Object)new h(key, variables.get(key)));
        }
        this.varok.disableProperty().bind((ObservableValue)this.isDisableOkProperty);
        this.varTable.getColumns().addListener((ListChangeListener)new ListChangeListener<Object>(){
            public boolean suspended = true;

            public void onChanged(ListChangeListener.Change<?> change) {
                change.next();
                if (change.wasReplaced() && this.suspended) {
                    this.suspended = false;
                    VariableSetDialogController.this.varTable.getColumns().setAll((Object[])new TableColumn[]{keyCol, valueCol, actionCol});
                    this.suspended = true;
                }
            }
        });
        this.varTable.setRowFactory(arg0 -> {
            TableRow row = new TableRow();
            row.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                if (event.getClickCount() == 2) {
                    this.showAddVariableDialog(this.stage, this.varTable, (h)row.getItem());
                }
            });
            return row;
        });
    }

    private void updataVairable(h item) {
        com.testin.itestin.business.k.a().a().stream().filter(action -> action.getRule().equals((Object)com.testin.itestin.business.actions.b.t)).forEach(action -> {
            if (action instanceof o && ((o)action).getVariable().equals(item.getValue())) {
                ((o)action).setText(item.getValue());
            } else if (action instanceof u && ((u)action).getVariable().equals(item.getValue())) {
                ((u)action).setText(item.getValue());
            } else if (action instanceof i && ((i)action).getVariable().equals(item.getValue())) {
                ((i)action).W(item.getValue());
            }
            this.logic.updateListItem(com.testin.itestin.business.k.a().a().indexOf(action), (k)action);
        });
    }

    public void clickexport() {
        com.testin.itestin.business.k.a().a(com.testin.itestin.business.k.a().getAppName() + com.testin.itestin.business.k.a().getVersion(), this.stage);
    }

    public void onMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    public void onMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    private class DeleteVariableCell
    extends TableCell<h, Boolean> {
        final Label delete = new Label(com.testin.itestin.business.actions.utils.d.e("scriptmanagercontroller.createcase.delete"));
        final Label edit = new Label(com.testin.itestin.business.actions.utils.d.e("scriptmanagercontroller.createcase.edit"));
        final HBox paddedButton = new HBox();
        boolean deleteflag = false;

        private boolean checkVariableRef(String var) {
            File[] scriptDir;
            for (File dir : scriptDir = TestFileUtils.getFilterList(new File(com.testin.itestin.business.k.a().getCasePath()).getParent(), "_dir")) {
                File[] xml;
                for (File xmlF : xml = TestFileUtils.getFilterList(dir.getPath(), ".xml")) {
                    String scriptContent = null;
                    try {
                        scriptContent = FileUtils.readFileToString((File)xmlF);
                    }
                    catch (IOException e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    if (!StringUtils.isNotEmpty((String)scriptContent) || !scriptContent.contains("[variable/" + var + "]")) continue;
                    return true;
                }
            }
            return false;
        }

        DeleteVariableCell(TableView<h> table) {
            this.paddedButton.setPadding(new Insets(3.0));
            this.paddedButton.setSpacing(15.0);
            this.paddedButton.getChildren().addAll((Object[])new Node[]{this.delete, this.edit});
            this.paddedButton.setAlignment(Pos.CENTER);
            this.delete.setUnderline(true);
            this.delete.setCursor(Cursor.HAND);
            this.delete.getStyleClass().addAll((Object[])new String[]{"bluetext", "smallfontsize"});
            this.edit.setUnderline(true);
            this.edit.setCursor(Cursor.HAND);
            this.edit.getStyleClass().addAll((Object[])new String[]{"bluetext", "smallfontsize"});
            this.deleteflag = false;
            this.delete.setOnMouseClicked(event -> {
                int index = table.getSelectionModel().getSelectedIndex();
                String var = ((h)table.getSelectionModel().getSelectedItem()).getKey();
                for (k action : com.testin.itestin.business.k.a().a()) {
                    if (action.getRule() != null && action.getRule().equals((Object)com.testin.itestin.business.actions.b.t)) {
                        this.deleteflag = action instanceof o && ((o)action).getVariable().equals(var) || action instanceof u && ((u)action).getVariable().equals(var) || action instanceof i && ((i)action).getVariable().equals(var);
                    }
                    this.deleteflag |= this.checkVariableRef(var);
                    if (!this.deleteflag) continue;
                    d.a(d.a.c, com.testin.itestin.business.actions.utils.d.e("variable.record.dialog.deletealert"));
                    return;
                }
                VariableSetDialogController.this.varTable.getItems().remove(index);
                VariableSetDialogController.this.isDisableOkProperty.set(false);
            });
            this.edit.setOnMouseClicked(event -> {
                int index = table.getSelectionModel().getSelectedIndex();
                h var = (h)VariableSetDialogController.this.varTable.getItems().get(index);
                VariableSetDialogController.this.showAddVariableDialog(VariableSetDialogController.this.stage, (TableView<h>)VariableSetDialogController.this.varTable, var);
            });
        }

        protected void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setGraphic(null);
            } else {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setGraphic((Node)this.paddedButton);
            }
        }
    }
}

