/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control.export;

import com.testin.itestin.business.actions.k;
import com.testin.itestin.business.utils.a;
import com.testin.itestin.util.i;
import com.testin.javafx.ui.control.d;
import com.testin.javafx.ui.control.export.d;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ExportPdfController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(ExportPdfController.class);
    @FXML
    TextField exportDir;
    @FXML
    TextField exportName;
    @FXML
    AnchorPane exportPdfPane;
    private static File chooseDir;
    private Stage stage;
    private String scriptName;
    private String appName;
    private d keyPress;
    private String path;
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;

    public void initialize(URL arg0, ResourceBundle arg1) {
    }

    public double getMyPreHeight() {
        return this.exportPdfPane.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.exportPdfPane.getPrefWidth();
    }

    public void setExportName(String name) {
        this.exportName.setText(name);
    }

    public void setExportDir() {
        if (chooseDir == null) {
            this.exportDir.setText(com.testin.itestin.service.a.Z());
            chooseDir = new File(com.testin.itestin.service.a.Z());
        } else {
            this.exportDir.setText(chooseDir.getAbsolutePath());
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    @FXML
    public void chooseExportDir(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            File dir;
            DirectoryChooser chooser = new DirectoryChooser();
            if (chooseDir != null && chooseDir.exists()) {
                chooser.setInitialDirectory(chooseDir);
            }
            if ((dir = chooser.showDialog((Window)this.getStage())) != null) {
                chooseDir = dir;
                String path = chooseDir.getPath();
                this.exportDir.setText(path);
            }
        }
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @FXML
    public void keyPressedLogic(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (KeyCode.ENTER.equals((Object)event.getCode())) {
            this.getKeyPress().keyPressedMethod(event);
        }
    }

    public d getKeyPress() {
        return this.keyPress;
    }

    public void setKeyPress(d keyPress) {
        this.keyPress = keyPress;
    }

    @FXML
    public void okClick(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        if (this.exportName.getText().isEmpty() || !a.l(this.exportName.getText())) {
            com.testin.javafx.ui.control.d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("exportpdf.name.error"));
            return;
        }
        this.exportPDF();
        this.stage.close();
    }

    @FXML
    public void cancelClick(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.close();
    }

    @FXML
    public void onMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void onMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    private void exportPDF() {
        block13: {
            try {
                LinkedList<String> step = new LinkedList<String>();
                LinkedList<String> stepPic = new LinkedList<String>();
                int stepNo = 1;
                int pdfNo = 1;
                for (k action : com.testin.itestin.business.k.a().a()) {
                    if (action.getActionType() == com.testin.itestin.business.actions.d.g) {
                        if (action.z().startsWith("pic_")) continue;
                        if (StringUtils.isNotEmpty((String)action.G())) {
                            if (action.z().endsWith("---\u622a\u56fe\uff1b")) {
                                step.add(pdfNo + ". " + action.z().replace("---\u622a\u56fe\uff1b", "---\u622a\u56fe"));
                            } else if (action.z().endsWith("---\u622a\u56fe")) {
                                step.add(pdfNo + ". " + action.z());
                            } else {
                                step.add(pdfNo + ". " + action.z() + "---\u622a\u56fe");
                            }
                            stepPic.add(this.path + File.separator + "img" + File.separator + action.G());
                            ++pdfNo;
                        } else {
                            String warn = String.format(com.testin.itestin.business.actions.utils.d.e("export.guide.cood.nopic"), stepNo, action.z());
                            com.testin.javafx.ui.control.d.a(d.a.b, warn);
                            return;
                        }
                    }
                    ++stepNo;
                }
                if (step.size() > 0) {
                    boolean isSuccess = i.a(step, stepPic, this.exportDir.getText() + File.separator + this.exportName.getText() + ".PDF");
                    if (isSuccess) {
                        com.testin.javafx.ui.control.d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("exportpdf.success"));
                    } else {
                        com.testin.javafx.ui.control.d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("exportpdf.failed"));
                    }
                    break block13;
                }
                com.testin.javafx.ui.control.d.a(d.a.b, com.testin.itestin.business.actions.utils.d.e("scriptmanagecontroller.export.textRule"));
                return;
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage());
            }
        }
    }
}

