/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.alibaba.fastjson.JSONArray;
import com.testin.itestin.business.actions.coord.p;
import com.testin.itestin.business.actions.coord.s;
import com.testin.itestin.business.actions.coord.t;
import com.testin.itestin.business.actions.k;
import com.testin.itestin.business.actions.utils.d;
import com.testin.itestin.business.actions.utils.g;
import com.testin.itestin.business.actions.y;
import com.testin.itestin.business.l;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.i;
import com.testin.itestin.device.j;
import com.testin.itestin.os.c;
import com.testin.itestin.util.j;
import com.testin.itestin.util.n;
import com.testin.javafx.b;
import com.testin.javafx.ui.TemplateController;
import com.testin.javafx.ui.control.d;
import com.testin.javafx.ui.include.RecordActionController;
import com.testin.javafx.ui.include.ScriptShowController;
import com.testin.javafx.ui.include.TopController;
import com.testin.javafx.ui.include.a;
import com.testin.javafx.ui.include.e;
import com.testin.javafx.ui.include.f;
import com.testin.javafx.ui.include.logic.CoordEmulatorControllerLogic;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CoordEmulatorController
extends AnchorPane
implements com.testin.itestin.device.event.g,
com.testin.javafx.ui.b,
e,
f,
Initializable {
    @FXML
    AnchorPane emulatorMobile;
    @FXML
    Label screenrecord_indicator;
    @FXML
    public Label auto_refresh_indicator;
    @FXML
    Label btnMenu;
    @FXML
    Label btnBack;
    @FXML
    Label switchMinicap;
    @FXML
    Label checkShot = new Label();
    @FXML
    BorderPane emulatorBorderPane;
    @FXML
    BorderPane emulatorTopBorderPane;
    @FXML
    HBox toolBarHBox;
    @FXML
    ImageView busyindicator;
    private boolean isChecked;
    static Logger log = Logger.getLogger(CoordEmulatorController.class);
    private CoordEmulatorControllerLogic logic;
    private boolean isReplaying;
    public a canvas;
    public boolean isTakeScreenShoting;
    private MenuItem variableItem;
    private ContextMenu contextMenu = new ContextMenu();
    private List<MenuItem> MenuItems;
    private List<MenuItem> ImageMenuItems;
    private List<MenuItem> UIAutoMenuItems;
    private com.testin.itestin.uiautomator.tree.b mSelectedNode;
    private int thread_count = 0;
    private com.testin.itestin.entitys.b latestScreenShot;
    private com.testin.itestin.entitys.l latestWindowInfo;
    private com.testin.itestin.uiautomator.a mModel;
    private int oriEmulatorBorderPaneWidth;
    private int oriEmulatorBorderPaneHeigh;
    private int oriEmulatorTopBorderPaneWidth;
    com.testin.itestin.os.a handler = new com.testin.itestin.os.a(){

        @Override
        public void handleMessage(c msg) {
            switch (msg.getStatus()) {
                case 769: {
                    com.testin.itestin.business.k.a().i(true);
                    CoordEmulatorController.this.updateEmulatorBackgroundColorTONormal();
                    UIController.setLastActionTimeToCurrentTime();
                    CoordEmulatorController.this.enableMinicapIFOK();
                    CoordEmulatorController.this.updateScreen();
                    CoordEmulatorController.this.logic.initDatas();
                    UIController.setScreenEventListener(CoordEmulatorController.this);
                    CoordEmulatorController.this.setCheckShotDisable(false);
                    CoordEmulatorController.this.switchToAutomatorMode();
                    break;
                }
                case 770: {
                    com.testin.itestin.business.k.a().i(false);
                    UIController.setLastActionTime(0L);
                    CoordEmulatorController.this.handleClearScreen();
                    CoordEmulatorController.this.setCheckShotDisable(true);
                    CoordEmulatorController.this.setCheckShot(false, false);
                    CoordEmulatorController.this.recordingNotReady();
                    CoordEmulatorController.this.updateEmulatorBackgroundColorTONormal();
                    break;
                }
                case 1025: {
                    CoordEmulatorController.this.isReplaying = true;
                    CoordEmulatorController.this.enableMinicapIFOK();
                    UIController.setLastActionTimeToCurrentTime();
                    CoordEmulatorController.this.updateScreen();
                    break;
                }
                case 1026: {
                    CoordEmulatorController.this.isReplaying = false;
                    UIController.setLastActionTime(0L);
                    CoordEmulatorController.this.handleClearScreen();
                    if (i.a() == null) break;
                    i.a().a().R();
                    break;
                }
                case 771: {
                    if (!com.testin.itestin.business.k.a().isRecording()) break;
                    UIController.setLastActionTimeToCurrentTime();
                    break;
                }
                case 772: {
                    com.testin.itestin.entitys.b image;
                    if (com.testin.itestin.business.k.a().isRecording()) {
                        com.testin.itestin.entitys.l wobj = (com.testin.itestin.entitys.l)msg.a(com.testin.itestin.entitys.l.class);
                        CoordEmulatorController.this.updateScreenWithWindowInfo(wobj);
                        break;
                    }
                    if (!CoordEmulatorController.this.isReplaying || (image = (com.testin.itestin.entitys.b)msg.a(com.testin.itestin.entitys.b.class)) == null || !image.isValid()) break;
                    CoordEmulatorController.this.canvas.b(image);
                    break;
                }
                case 768: {
                    CoordEmulatorController.this.handleClearScreen();
                    break;
                }
                case 1283: {
                    CoordEmulatorController.this.updateScreenRecordIndicator();
                    break;
                }
                case 1557: {
                    CoordEmulatorController.this.switchOnOrOffMinicap(false);
                    break;
                }
                case 1554: {
                    CoordEmulatorController.this.recordingNotReady();
                    CoordEmulatorController.this.updateEmulatorBackgroundColorTONormal();
                    break;
                }
                case 1556: {
                    CoordEmulatorController.this.updateEmulatorBackGroundColor();
                    break;
                }
            }
        }
    };

    public CoordEmulatorController() {
        this.createMenuItems();
        UIController.setCoordEmulatorHandler(this.handler);
    }

    public void initialize(URL location, ResourceBundle resources) {
        TopController.setCoordEmulatorEventListener(this);
        this.logic = new CoordEmulatorControllerLogic(this);
        UIController.setCoordEmulatorController(this);
        this.initContextMenu();
        this.btnBack.setTooltip(UIController.getInternationalTooltip("coordemulator.button.back"));
        this.btnMenu.setTooltip(UIController.getInternationalTooltip("coordemulator.button.menu"));
        this.auto_refresh_indicator.setTooltip(UIController.getInternationalTooltip("emulator.button.switch.not.ready"));
        String OSName = System.getProperty("os.name");
        if (OSName.startsWith("Mac")) {
            this.checkShot.setTooltip(UIController.getInternationalTooltip("coordscriptshowcontoller.scriptshowinTable.takeimage.holdcommand"));
        } else if (OSName.startsWith("Windows")) {
            this.checkShot.setTooltip(UIController.getInternationalTooltip("coordscriptshowcontoller.scriptshowinTable.takeimage.holdcontrol"));
        }
        this.oriEmulatorBorderPaneWidth = (int)this.emulatorBorderPane.getPrefWidth();
        this.oriEmulatorBorderPaneHeigh = (int)this.emulatorBorderPane.getPrefHeight();
        this.oriEmulatorTopBorderPaneWidth = (int)this.emulatorTopBorderPane.getPrefWidth();
        this.setSize();
        this.setCheckShotDisable(true);
        int width = g.b(this.emulatorMobile.getPrefWidth());
        int height = g.b(this.emulatorMobile.getPrefHeight());
        this.canvas = new a(width, height, this);
        ScriptShowController.SetScriptShowListener(this);
        this.emulatorMobile.getChildren().add((Object)this.canvas);
        this.updateEmulatorBackgroundColorTONormal();
    }

    private void createMenuItems() {
        this.createCoordMenuItems();
        this.createImageMenuItems();
        this.createUIAutomatorMenuItems();
    }

    private void createCoordMenuItems() {
        if (this.MenuItems == null) {
            this.MenuItems = new ArrayList<MenuItem>();
        }
        this.MenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems1"), "text"));
        this.MenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems2"), "username"));
        this.MenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems3"), "password"));
        this.variableItem = CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems.text.variable"), "variable");
        this.MenuItems.add(this.variableItem);
        this.MenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems4"), "randomtext"));
        this.MenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems8"), "randomnum"));
        this.MenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems6"), "enter"));
        this.MenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems7"), "clicktext"));
    }

    private void createUIAutomatorMenuItems() {
        if (this.UIAutoMenuItems == null) {
            this.UIAutoMenuItems = new ArrayList<MenuItem>();
        }
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("emulatorcontroller.menuitems3"), "updrag"));
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("emulatorcontroller.menuitems4"), "downdrag"));
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("emulatorcontroller.menuitems5"), "leftdrag"));
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("emulatorcontroller.menuitems6"), "rightdrag"));
        this.UIAutoMenuItems.add((MenuItem)this.createSeparatorMenuItem());
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems1"), "text"));
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems2"), "username"));
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems3"), "password"));
        this.variableItem = CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems.text.variable"), "variable");
        this.UIAutoMenuItems.add(this.variableItem);
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems4"), "randomtext"));
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems8"), "randomnum"));
        if (com.testin.itestin.common.a.aa) {
            this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("emulatorcontroller.getmessageverify"), "messageVerify"));
        }
        this.UIAutoMenuItems.add((MenuItem)this.createSeparatorMenuItem());
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems5"), "assert"));
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("emulatorcontroller.menuitems.if"), "startIF"));
        this.UIAutoMenuItems.add(CoordEmulatorController.createMenuItem(d.e("emulatorcontroller.menuitems.for"), "startFor"));
    }

    private void createImageMenuItems() {
        if (this.ImageMenuItems == null) {
            this.ImageMenuItems = new ArrayList<MenuItem>();
        }
        this.ImageMenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems.image.click"), "imageClick"));
        this.ImageMenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems.image.longtouch"), "imageLongTouch"));
        this.ImageMenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems.image.doubleclick"), "imageDoubleClick"));
        this.ImageMenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems.image.trail"), "imageTrail"));
        this.ImageMenuItems.add((MenuItem)this.createSeparatorMenuItem());
        this.ImageMenuItems.add(CoordEmulatorController.createMenuItem(d.e("inputdialog.titlepane.input"), "imageInput"));
        if (com.testin.itestin.common.a.aa) {
            this.ImageMenuItems.add(CoordEmulatorController.createMenuItem(d.e("emulatorcontroller.getmessageverify"), "imagemessageVerify"));
        }
        this.ImageMenuItems.add((MenuItem)this.createSeparatorMenuItem());
        this.ImageMenuItems.add(CoordEmulatorController.createMenuItem(d.e("coordemulatorcontroller.menuitems5"), "imageAssert"));
        this.ImageMenuItems.add(CoordEmulatorController.createMenuItem(d.e("emulatorcontroller.menuitems.if"), "imageIf"));
        this.ImageMenuItems.add(CoordEmulatorController.createMenuItem(d.e("emulatorcontroller.menuitems.for"), "imageFor"));
    }

    private static MenuItem createMenuItem(String text, String id) {
        MenuItem menuItem = new MenuItem();
        menuItem.setId(id);
        menuItem.setText(text);
        menuItem.setStyle("-fx-font-size: 12px;-fx-font-family: \"Microsoft Yahei\",Tahoma,Arial,Helvetica,STHeiti;-fx-padding:0px 50px 0px 0px;");
        return menuItem;
    }

    private SeparatorMenuItem createSeparatorMenuItem() {
        return new SeparatorMenuItem();
    }

    private void updateEmulatorBackGroundColor() {
        if (UIController.isNeedToHold()) {
            UIController.updateNodeSytleClass((Node)this.emulatorMobile, "emulatorMobileHold");
        } else {
            UIController.updateNodeSytleClass((Node)this.emulatorMobile, "emulatorMobileOK");
        }
    }

    private void updateEmulatorBackgroundColorTONormal() {
        UIController.updateNodeSytleClass((Node)this.emulatorMobile, "emulatorMobileNormal");
    }

    private void enableMinicapIFOK() {
        com.testin.itestin.business.minicap.d minicap = null;
        if (i.a() != null) {
            minicap = i.a().a();
        }
        if (minicap != null && minicap.U()) {
            minicap.D(true);
            this.switchOnOrOffMinicap(minicap.T());
        }
    }

    @FXML
    public void autoRefreshBtnClick(MouseEvent event) {
        if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
            if (com.testin.itestin.business.k.a().isRecording()) {
                if (n.aJ()) {
                    this.switchToPureCoordMode();
                } else {
                    this.switchToAutomatorMode();
                }
            } else {
                this.recordingNotReady();
            }
        }
    }

    private void switchToAutomatorMode() {
        if (i.ak() && i.a().G() < 16) {
            return;
        }
        n.Z(true);
        this.updateScreenWithWindowInfo(this.getLatestWindowInfo());
        Platform.runLater(() -> {
            UIController.updateNodeSytleClass((Node)this.auto_refresh_indicator, "refresh_auto");
            this.auto_refresh_indicator.setTooltip(UIController.getInternationalTooltip("emulator.button.switch.uiautomator.indicator"));
        });
    }

    private void switchToPureCoordMode() {
        n.Z(false);
        this.updateEmulatorBackgroundColorTONormal();
        Platform.runLater(() -> {
            UIController.updateNodeSytleClass((Node)this.auto_refresh_indicator, "refresh_manual");
            this.auto_refresh_indicator.setTooltip(UIController.getInternationalTooltip("emulator.button.switch.coord.indicator"));
        });
    }

    private void recordingNotReady() {
        if (Platform.isFxApplicationThread()) {
            this.recordingNotReadyUI();
        } else {
            Platform.runLater(this::recordingNotReadyUI);
        }
    }

    private void recordingNotReadyUI() {
        UIController.updateNodeSytleClass((Node)this.auto_refresh_indicator, "refresh_not_ready");
        this.auto_refresh_indicator.setTooltip(UIController.getInternationalTooltip("emulator.button.switch.not.ready"));
    }

    private void updateScreenWithWindowInfo(com.testin.itestin.entitys.l wobj) {
        if (wobj == null) {
            return;
        }
        String windowInfo = wobj.H();
        if (this.getLatestWindowInfo() != null && this.getLatestWindowInfo().H() != null && windowInfo != null && this.getLatestWindowInfo().H().equals(windowInfo)) {
            return;
        }
        if (!n.isWindowInfoValid(windowInfo)) {
            log.info((Object)"Window Info is invalid, ignore this request.");
            return;
        }
        if (this.isTakeScreenShoting) {
            log.info((Object)"A thread is taking shot, IGNORE this request.");
            return;
        }
        ++this.thread_count;
        Thread t2 = new Thread(() -> {
            com.testin.itestin.uiautomator.tree.b mSelectedNode = this.canvas.getSelectedNode();
            if (mSelectedNode != null) {
                String xpath = ((com.testin.itestin.uiautomator.tree.f)mSelectedNode).getAttribute("xpath");
                String clazz = ((com.testin.itestin.uiautomator.tree.f)mSelectedNode).getAttribute("class");
                String text = ((com.testin.itestin.uiautomator.tree.f)mSelectedNode).getAttribute("text");
                if (text == null) {
                    text = "";
                }
                if (!l.a(windowInfo, xpath, clazz, text)) {
                    mSelectedNode = null;
                }
            }
            this.mModel = new com.testin.itestin.uiautomator.a(windowInfo);
            if (this.mModel.aA()) {
                this.setLatestWindowInfo(wobj);
            }
            if (i.ak()) {
                boolean update = false;
                if (this.getLatestScreenShot() != null) {
                    update = this.mModel.aA() && this.getLatestScreenShot().getTimeStamp() >= wobj.getTimeStamp();
                }
                this.canvas.a(this.getLatestScreenShot(), this.mModel.aA() ? this.mModel : null, update);
            }
        });
        com.testin.itestin.threadpool.a.a(t2, "SyncUIScreen (" + this.thread_count + ")");
    }

    private void updateScreen() {
        Thread screenUpdater = new Thread(){

            @Override
            public void run() {
                while (com.testin.itestin.business.k.a().isRecording() || CoordEmulatorController.this.isReplaying) {
                    long wait_time_for_next_screenshot;
                    if (!CoordEmulatorController.this.isTakeScreenShoting && (wait_time_for_next_screenshot = System.currentTimeMillis() - n.g()) > (long)n.cV) {
                        try {
                            if (!i.ak()) {
                                log.info((Object)"\u8bbe\u5907\u5df2\u7ecf\u6389\u7ebf\uff01");
                                break;
                            }
                            com.testin.itestin.entitys.b screenshot = com.testin.itestin.business.utils.a.b();
                            if (screenshot != null && screenshot.isValid()) {
                                CoordEmulatorController.this.setLatestScreenShot(screenshot);
                                boolean update = CoordEmulatorController.this.getLatestWindowInfo() != null && screenshot.getTimeStamp() >= CoordEmulatorController.this.getLatestWindowInfo().getTimeStamp();
                                CoordEmulatorController.this.canvas.a(screenshot, null, update);
                            } else {
                                log.error((Object)"imageNotValid in updateScreen.");
                            }
                        }
                        catch (Exception ex) {
                            log.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                    g.sleep(n.cV);
                }
            }
        };
        com.testin.itestin.threadpool.a.a(screenUpdater, "Update Screen");
    }

    private void handleClearScreen() {
        this.canvas.a(0, null);
    }

    private void initContextMenu() {
        this.contextMenu.setOnAction(event -> {
            MenuItem item = (MenuItem)event.getTarget();
            final String id = item.getId();
            Thread t2 = new Thread(){

                @Override
                public void run() {
                    CoordEmulatorController.this.logic.handleMenuItem(id, CoordEmulatorController.this.getSelectedNode());
                }
            };
            com.testin.itestin.threadpool.a.a(t2, "Handle Menu Item " + id);
            this.hideContextMenu();
        });
        this.contextMenu.getItems().addAll(this.MenuItems);
    }

    private boolean isSingleCaseIsRecording() {
        return com.testin.itestin.business.k.a().isRecording();
    }

    @FXML
    public void clickMenu(MouseEvent event) {
        String eventType;
        switch (eventType = event.getEventType().getName()) {
            case "MOUSE_CLICKED": {
                if (!this.isSingleCaseIsRecording()) break;
                s action = new s(82);
                this.logic.sendTestAction(action);
                break;
            }
            case "MOUSE_ENTERED": {
                if (this.isSingleCaseIsRecording()) {
                    UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgEnter");
                    break;
                }
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgDisable");
                break;
            }
            case "MOUSE_EXITED": {
                if (this.isSingleCaseIsRecording()) {
                    UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkg");
                    break;
                }
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgDisable");
                break;
            }
            case "MOUSE_PRESSED": {
                if (this.isSingleCaseIsRecording()) {
                    UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgPress");
                    break;
                }
                UIController.updateNodeSytleClass((Node)this.btnMenu, "menubtnBkgDisable");
            }
        }
    }

    @FXML
    public void clickBack(MouseEvent event) {
        String eventType;
        switch (eventType = event.getEventType().getName()) {
            case "MOUSE_CLICKED": {
                if (!this.isSingleCaseIsRecording()) break;
                s action = new s(4);
                this.logic.sendTestAction(action);
                break;
            }
            case "MOUSE_ENTERED": {
                if (this.isSingleCaseIsRecording()) {
                    UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgEnter");
                    break;
                }
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgDisable");
                break;
            }
            case "MOUSE_EXITED": {
                if (this.isSingleCaseIsRecording()) {
                    UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkg");
                    break;
                }
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgDisable");
                break;
            }
            case "MOUSE_PRESSED": {
                if (this.isSingleCaseIsRecording()) {
                    UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgPress");
                    break;
                }
                UIController.updateNodeSytleClass((Node)this.btnBack, "backbtnBkgDisable");
            }
        }
    }

    @FXML
    public void clickScreenShot(MouseEvent event) {
        if (com.testin.itestin.business.k.a().isRecording()) {
            y screenshot = new y(UIController.getNextAutoImgName());
            screenshot.a(com.testin.itestin.business.actions.d.g);
            screenshot.setRule(com.testin.itestin.business.actions.b.I);
            this.logic.sendTestAction(screenshot);
        }
    }

    @Override
    public void onMouseEvent(String json, boolean isLong) {
        if (com.testin.itestin.business.k.a().isRecording()) {
            if (isLong) {
                p longTouchTA = new p(json);
                this.logic.sendTestAction(longTouchTA);
                log.debug((Object)json);
            } else {
                t touchAction = new t(json);
                this.logic.sendTestAction(touchAction);
                log.debug((Object)json);
            }
        }
    }

    @FXML
    public void clickEmulator(MouseEvent event) {
        String eventType;
        if (com.testin.itestin.business.k.a().isRecording() && (eventType = event.getEventType().getName()).equals("MOUSE_CLICKED")) {
            MouseButton button = event.getButton();
            switch (button) {
                case PRIMARY: {
                    this.hideContextMenu();
                    if (this.isCheckShot() || !this.canvas.a.aR() || !this.canvas.b(event.getX(), event.getY())) break;
                    this.canvas.a.ag(false);
                    break;
                }
                case SECONDARY: {
                    break;
                }
            }
        }
    }

    private void hideContextMenu() {
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
    }

    @FXML
    public void showContextMenu(ContextMenuEvent event) {
        if (com.testin.itestin.business.k.a().isRecording()) {
            this.variableItem.setDisable(com.testin.itestin.business.k.a().a().isEmpty());
            if (this.canvas.a.aR() && !this.canvas.aN()) {
                this.contextMenu.getItems().clear();
                this.contextMenu.getItems().addAll(this.ImageMenuItems);
            } else if (n.aJ()) {
                this.contextMenu.getItems().clear();
                this.setSelectedNode(this.canvas.getSelectedNode());
                this.contextMenu.getItems().addAll(this.UIAutoMenuItems);
            } else {
                this.contextMenu.getItems().clear();
                this.contextMenu.getItems().addAll(this.MenuItems);
            }
            this.contextMenu.show((Node)this.canvas, event.getScreenX(), event.getScreenY());
        }
    }

    @FXML
    public void clickScreenRecord(MouseEvent event) {
        if (!com.testin.itestin.business.k.a().isRecording()) {
            this.setScreenRecordAsNotReady();
            return;
        }
        if (n.aJ) {
            this.setScreenRecordAsDisabled();
        } else {
            this.setScreenRecordAsEnabled();
        }
    }

    private void updateScreenRecordIndicator() {
        if (!com.testin.itestin.business.k.a().isRecording()) {
            this.setScreenRecordAsNotReady();
            return;
        }
        this.setScreenRecordAsDisabled();
    }

    private void setScreenRecordAsNotReady() {
        n.aJ = false;
        Platform.runLater(() -> {
            this.screenrecord_indicator.setTooltip(UIController.getInternationalTooltip("screen.event.detector.info"));
            this.screenrecord_indicator.getStyleClass().clear();
            this.screenrecord_indicator.getStyleClass().add((Object)"screenRecordNotReady");
        });
    }

    private void setScreenRecordAsEnabled() {
        n.aJ = true;
        if (UIController.isEventDetectorRunning()) {
            Platform.runLater(() -> {
                this.screenrecord_indicator.getStyleClass().clear();
                this.screenrecord_indicator.getStyleClass().add((Object)"screenRecordEnabled");
                this.screenrecord_indicator.setTooltip(UIController.getInternationalTooltip("screen.event.detector.enabled"));
            });
        } else {
            log.info((Object)"screen detector thread is not running, still set indicator as not ready.");
            this.setScreenRecordAsNotReady();
        }
    }

    private void setScreenRecordAsDisabled() {
        n.aJ = false;
        if (UIController.isEventDetectorRunning()) {
            Platform.runLater(() -> {
                this.screenrecord_indicator.getStyleClass().clear();
                this.screenrecord_indicator.getStyleClass().add((Object)"screenRecordDisabled");
                this.screenrecord_indicator.setTooltip(UIController.getInternationalTooltip("screen.event.detector.disabled"));
            });
        } else {
            log.info((Object)"screen detector thread is not running, still set indicator as not ready.");
            this.setScreenRecordAsNotReady();
        }
    }

    @Override
    public void onDoubleClickEvent(String json) {
        if (com.testin.itestin.business.k.a().isRecording()) {
            com.testin.itestin.business.actions.coord.c action = new com.testin.itestin.business.actions.coord.c(json);
            this.logic.sendTestAction(action);
            log.debug((Object)json);
        }
    }

    @Override
    public void onLocalConClick(int orientation, com.testin.itestin.uiautomator.tree.b node, com.testin.itestin.business.actions.f civ) {
        com.testin.itestin.uiautomator.tree.f tmp = (com.testin.itestin.uiautomator.tree.f)node;
        boolean editable = false;
        try {
            if (tmp != null && !StringUtils.isEmpty((String)tmp.getAttribute("editable"))) {
                editable = Boolean.parseBoolean(tmp.getAttribute("editable"));
            }
        }
        catch (Exception e2) {
            log.error((Object)String.format("id#%s editable not found.", "click"), (Throwable)e2);
        }
        k action = n.a(com.testin.itestin.business.actions.b.a, orientation, node, civ);
        action.I(com.testin.itestin.business.actions.e.e.getString());
        this.handleAction(action, editable, "click", node);
    }

    @Override
    public void onLocalConDoubleClick(int orientation, com.testin.itestin.uiautomator.tree.b node, com.testin.itestin.business.actions.f civ) {
        com.testin.itestin.uiautomator.tree.f tmp = (com.testin.itestin.uiautomator.tree.f)node;
        boolean editable = false;
        try {
            if (tmp != null && !StringUtils.isEmpty((String)tmp.getAttribute("editable"))) {
                editable = Boolean.parseBoolean(tmp.getAttribute("editable"));
            }
        }
        catch (Exception e2) {
            log.error((Object)String.format("id#%s editable not found.", "doubleclick"), (Throwable)e2);
        }
        k action = n.a(com.testin.itestin.business.actions.b.b, orientation, node, civ);
        action.I(com.testin.itestin.business.actions.e.e.getString());
        this.handleAction(action, editable, "doubleclick", node);
    }

    @Override
    public void onLocalConLongClick(int orientation, com.testin.itestin.uiautomator.tree.b node, com.testin.itestin.business.actions.f civ, int holdTime) {
        com.testin.itestin.uiautomator.tree.f tmp = (com.testin.itestin.uiautomator.tree.f)node;
        boolean editable = false;
        try {
            if (tmp != null && !StringUtils.isEmpty((String)tmp.getAttribute("editable"))) {
                editable = Boolean.parseBoolean(tmp.getAttribute("editable"));
            }
        }
        catch (Exception e2) {
            log.error((Object)String.format("id#%s editable not found.", "longclick"), (Throwable)e2);
        }
        k action = n.a(com.testin.itestin.business.actions.b.c, orientation, node, civ, holdTime);
        action.I(com.testin.itestin.business.actions.e.e.getString());
        this.handleAction(action, editable, "longclick", node);
    }

    @Override
    public void onLocalDrag(int orientation, float fromX, float toX, float fromY, float toY) {
        k action = n.a(orientation, fromX, toX, fromY, toY);
        action.I(com.testin.itestin.business.actions.e.e.getString());
        this.logic.sendUIAutomatorTestAction(action);
    }

    private void handleAction(k action, boolean isEditable, String actionName, com.testin.itestin.uiautomator.tree.b mSelectedNode) {
        System.err.println("Send handleAction: " + action);
        if (action != null && StringUtils.isNotEmpty((String)action.z())) {
            if (n.a(actionName, isEditable)) {
                String timestamp = String.format("%s", System.currentTimeMillis());
                com.testin.itestin.entitys.e rec = com.testin.itestin.business.utils.a.a(mSelectedNode, i.O(), i.N(), UIController.getRotation());
                com.testin.itestin.business.utils.a.a(timestamp, rec, action);
                com.testin.itestin.business.utils.a.a(this.canvas.b(), rec, action, this.mModel.H(), false);
            }
            this.logic.sendUIAutomatorTestAction(action);
        }
    }

    private JSONArray getRelativePointer(com.testin.itestin.device.event.i point, int rotation, long time, float pressure) {
        if (point != null && i.ak()) {
            float screenwidth = i.a().H();
            float screenheight = i.a().I();
            float x2 = this.getXwithDock(point, screenwidth, screenheight, rotation);
            float y2 = this.getYWithDock(point, screenwidth, screenheight, rotation);
            JSONArray pointValue = new JSONArray();
            pointValue.add((Object)Float.valueOf(x2));
            pointValue.add((Object)Float.valueOf(y2));
            pointValue.add((Object)time);
            pointValue.add((Object)Float.valueOf(pressure));
            return pointValue;
        }
        if (point != null) {
            JSONArray pointValue = new JSONArray();
            pointValue.add((Object)Float.valueOf(point.getX()));
            pointValue.add((Object)Float.valueOf(point.getY()));
            return pointValue;
        }
        return null;
    }

    private float getXwithDock(com.testin.itestin.device.event.i point, float sourceWidth, float sourceHeight, int rotation) {
        if (g.DEBUG) {
            System.err.println(String.format("getXXXXwithDock before W=%s, H=%s, rotation=%s", Float.valueOf(sourceWidth), Float.valueOf(sourceHeight), rotation));
        }
        float mDockW = i.a().a().getWidth();
        float mDockH = i.a().a().getHeight();
        if (rotation == 0 || rotation == 2) {
            if (mDockW != 0.0f && mDockW != sourceWidth) {
                sourceWidth = mDockW;
            }
            if (mDockH != 0.0f && mDockH != sourceHeight) {
                sourceHeight = mDockH;
            }
        } else {
            if (mDockW != 0.0f && mDockW != sourceHeight) {
                sourceHeight = mDockW;
            }
            if (mDockH != 0.0f && mDockH != sourceHeight) {
                sourceWidth = mDockH;
            }
        }
        if (g.DEBUG) {
            System.err.println(String.format("getXXXXwithDock after W=%s, H=%s", Float.valueOf(sourceWidth), Float.valueOf(sourceHeight)));
        }
        if (rotation == 0) {
            if (point != null) {
                if (sourceWidth > 0.0f) {
                    return (float)point.getX() / sourceWidth;
                }
                return point.getX();
            }
        } else if (rotation == 1) {
            if (point != null) {
                if (sourceWidth > 0.0f) {
                    return (float)point.getY() / sourceWidth;
                }
                return point.getY();
            }
        } else if (rotation == 3 && point != null) {
            if (sourceWidth > 0.0f) {
                return (sourceHeight - (float)point.getY()) / sourceWidth;
            }
            return (sourceHeight - (float)point.getY()) / sourceWidth;
        }
        return 0.0f;
    }

    private float getYWithDock(com.testin.itestin.device.event.i point, float sourceWidth, float sourceHeight, int rotation) {
        if (g.DEBUG) {
            System.err.println(String.format("getYYYYWithDock before W=%s, H=%s rotation=%s", Float.valueOf(sourceWidth), Float.valueOf(sourceHeight), rotation));
        }
        float mDockW = i.a().a().getWidth();
        float mDockH = i.a().a().getHeight();
        if (rotation == 0 || rotation == 2) {
            if (mDockW != 0.0f && mDockW != sourceWidth) {
                sourceWidth = mDockW;
            }
            if (mDockH != 0.0f && mDockH != sourceHeight) {
                sourceHeight = mDockH;
            }
        } else {
            if (mDockW != 0.0f && mDockW != sourceHeight) {
                sourceHeight = mDockW;
            }
            if (mDockH != 0.0f && mDockH != sourceHeight) {
                sourceWidth = mDockH;
            }
        }
        if (g.DEBUG) {
            System.err.println(String.format("getYYYYWithDock after W=%s, H=%s", Float.valueOf(sourceWidth), Float.valueOf(sourceHeight)));
        }
        if (rotation == 0) {
            if (point != null) {
                if (sourceHeight > 0.0f) {
                    return (float)point.getY() / sourceHeight;
                }
                return point.getY();
            }
        } else if (rotation == 1) {
            if (point != null) {
                if (sourceHeight > 0.0f) {
                    return (sourceWidth - (float)point.getX()) / sourceHeight;
                }
                return (sourceWidth - (float)point.getX()) / sourceHeight;
            }
        } else if (rotation == 3 && point != null) {
            if (sourceHeight > 0.0f) {
                return (float)point.getX() / sourceHeight;
            }
            return (float)point.getX() / sourceHeight;
        }
        return 0.0f;
    }

    private JSONArray generateClickActionStr(com.testin.itestin.device.event.c event) {
        if (event != null && (event.getType() == 0 || event.getType() == 1 || event.getType() == 4)) {
            JSONArray action = new JSONArray();
            JSONArray rotation = new JSONArray();
            int rotationValue = event.S();
            rotation.add((Object)rotationValue);
            action.add((Object)rotation);
            if (event.getType() == 1) {
                JSONArray timeUsed = new JSONArray();
                timeUsed.add((Object)(event.getEndTime() - event.getStartTime()));
                action.add((Object)timeUsed);
            }
            action.add((Object)this.getRelativePointer(event.c(), rotationValue, 0L, 0.0f));
            action.add((Object)this.getRelativePointer(event.c(), rotationValue, 0L, 0.0f));
            action.add((Object)this.getRelativePointer(event.c(), rotationValue, 0L, 0.0f));
            return action;
        }
        log.error((Object)"this is not click or long click event, cannot use it to generate click or long click action string.");
        return null;
    }

    private JSONArray generateDragActionStr(com.testin.itestin.device.event.c event) {
        if (event != null && event.getType() == 2) {
            JSONArray action = new JSONArray();
            JSONArray rotation = new JSONArray();
            int rotationValue = event.S();
            rotation.add((Object)rotationValue);
            action.add((Object)rotation);
            ArrayList<com.testin.itestin.device.event.a> actionList = event.m();
            if (actionList != null) {
                for (com.testin.itestin.device.event.a a2 : actionList) {
                    JSONArray pointValue;
                    if (a2.a().isZero() || (pointValue = this.getRelativePointer(a2.a(), rotationValue, a2.getTime(), a2.g())) == null) continue;
                    action.add((Object)this.getRelativePointer(a2.a(), rotationValue, a2.getTime(), a2.g()));
                }
            }
            return action;
        }
        log.error((Object)"this is not drag event, cannot use it to generate drag action string.");
        return null;
    }

    @Override
    public void handleEvent(com.testin.itestin.device.event.c event) {
        t testAction;
        JSONArray action;
        log.info((Object)("detected screen event: " + event));
        if (!com.testin.itestin.business.k.a().isRecording()) {
            log.info((Object)"It's not under recording state right now, ignore the event.");
            return;
        }
        if (event == null || !i.ak()) {
            log.error((Object)"event is invalid, or device is not online, ignore this event.");
            return;
        }
        if (event.getType() == 0 || event.getType() == 1 || event.getType() == 4) {
            action = this.generateClickActionStr(event);
            testAction = null;
            if (event.getType() == 0) {
                testAction = new t(action);
            } else if (event.getType() == 1) {
                testAction = new p(action);
            } else if (event.getType() == 4) {
                testAction = new com.testin.itestin.business.actions.coord.c(action);
            }
            if (testAction != null) {
                testAction.s(true);
                this.logic.sendTestAction(testAction);
            }
        }
        if (event.getType() == 2 && (action = this.generateDragActionStr(event)) != null) {
            testAction = new t(action);
            testAction.s(true);
            this.logic.sendTestAction(testAction);
        }
        if (event.getType() == 3) {
            s keyPressAction = null;
            if (event.a().equals((Object)j.b.a)) {
                keyPressAction = new s(4);
            } else if (event.a().equals((Object)j.b.b)) {
                keyPressAction = new s(82);
            }
            if (keyPressAction != null) {
                keyPressAction.s(true);
                this.logic.sendTestAction(keyPressAction);
            }
        }
    }

    public boolean isCheckShotDisable() {
        return this.checkShot.isDisable();
    }

    public void setCheckShotDisable(boolean disable) {
        this.checkShot.setDisable(disable);
    }

    public boolean isCheckShot() {
        return this.isChecked;
    }

    public void setCheckShot(boolean check, boolean wait) {
        this.isChecked = check;
        if (wait) {
            g.sleep(600L);
            if (UIController.isSpaceKeyRelease()) {
                return;
            }
        }
        if (check) {
            UIController.updateNodeSytleClass((Node)this.checkShot, "checkShotSelect");
        } else {
            UIController.updateNodeSytleClass((Node)this.checkShot, "checkShotUnselect");
        }
    }

    @FXML
    public void clickShotCheck(MouseEvent event) {
        this.setCheckShot(!this.isCheckShot(), false);
        this.canvas.aI();
        this.canvas.repaint();
    }

    @FXML
    public void clickSwitch(MouseEvent event) {
        if (!i.ak()) {
            return;
        }
        com.testin.itestin.business.minicap.d minicap = i.a().a();
        if (!minicap.U()) {
            com.testin.javafx.ui.control.d.a(d.a.c, d.e("minicap.not.support"));
        } else {
            minicap.D(!minicap.T());
            this.switchOnOrOffMinicap(minicap.T());
        }
    }

    private void switchOnOrOffMinicap(boolean available) {
        com.testin.itestin.business.minicap.d minicap = null;
        if (i.a() != null) {
            minicap = i.a().a();
        }
        if (minicap != null) {
            minicap.D(available);
        }
        if (available) {
            UIController.updateNodeSytleClass((Node)this.switchMinicap, "switchMinicapOn");
        } else {
            UIController.updateNodeSytleClass((Node)this.switchMinicap, "switchMinicapOff");
            if (minicap != null && minicap.P) {
                minicap.S();
            }
        }
    }

    @Override
    public void onScriptShowMouseEvent(List<j> pointList, int touch) {
    }

    @Override
    public void setData(List<j> pointList, int touch) {
        this.canvas.f(pointList);
        a.aa(touch);
    }

    public com.testin.itestin.entitys.b getLatestScreenShot() {
        return this.latestScreenShot;
    }

    public void setLatestScreenShot(com.testin.itestin.entitys.b latestScreenShot) {
        this.latestScreenShot = latestScreenShot;
    }

    public com.testin.itestin.entitys.l getLatestWindowInfo() {
        return this.latestWindowInfo;
    }

    public void setLatestWindowInfo(com.testin.itestin.entitys.l latestWindowInfo) {
        this.latestWindowInfo = latestWindowInfo;
    }

    public com.testin.itestin.uiautomator.tree.b getSelectedNode() {
        return this.mSelectedNode;
    }

    public void setSelectedNode(com.testin.itestin.uiautomator.tree.b node) {
        this.mSelectedNode = node;
    }

    @Override
    public void setSize() {
        if (TopController.isFullScreen) {
            int h2 = (int)b.a().a().getHeight();
            int emulatorSize = h2 - TemplateController.topHeigh - TemplateController.bottomHeigh - RecordActionController.oriBorderPaneHeigh - 10;
            this.emulatorBorderPane.setPrefWidth((double)(emulatorSize - 40));
            this.emulatorBorderPane.setPrefHeight((double)emulatorSize);
            this.emulatorBorderPane.setLayoutX(10.0);
            this.emulatorTopBorderPane.setPrefWidth((double)(emulatorSize - 40));
            this.emulatorTopBorderPane.setLayoutX(10.0);
            this.emulatorMobile.setPrefWidth((double)(emulatorSize - 40));
            this.emulatorMobile.setPrefHeight((double)(emulatorSize - 40));
            this.toolBarHBox.setPrefWidth((double)(emulatorSize - 40));
            this.toolBarHBox.setSpacing(((double)(emulatorSize - 40) - 4.0 * this.btnMenu.getPrefWidth()) / 3.0);
            this.busyindicator.setLayoutX((double)(emulatorSize - 40 - 32));
            if (this.canvas != null) {
                this.canvas.d(emulatorSize - 40, emulatorSize - 40);
                this.canvas.ab(false);
            }
        } else {
            this.emulatorBorderPane.setPrefWidth((double)this.oriEmulatorBorderPaneWidth);
            this.emulatorBorderPane.setPrefHeight((double)this.oriEmulatorBorderPaneHeigh);
            this.emulatorTopBorderPane.setPrefWidth((double)this.oriEmulatorTopBorderPaneWidth);
            this.emulatorMobile.setPrefWidth(400.0);
            this.emulatorMobile.setPrefHeight(400.0);
            this.toolBarHBox.setPrefWidth(400.0);
            this.toolBarHBox.setSpacing(90.0);
            this.busyindicator.setLayoutX(364.0);
            if (this.canvas != null) {
                this.canvas.d(400, 400);
                this.canvas.ab(false);
            }
        }
    }

    @Override
    public void setImage(Image img) {
        this.canvas.a(img);
        this.canvas.repaint();
    }
}

