/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.testin.itestin.business.actions.coord.m;
import com.testin.itestin.business.actions.d;
import com.testin.itestin.business.actions.k;
import com.testin.itestin.business.actions.utils.g;
import com.testin.itestin.business.actions.y;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.business.utils.a;
import com.testin.javafx.b;
import com.testin.javafx.ui.TemplateController;
import com.testin.javafx.ui.include.RecordActionController;
import com.testin.javafx.ui.include.ScriptShowController;
import com.testin.javafx.ui.include.TopController;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Popup;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StepItemController
extends Pane
implements com.testin.javafx.ui.b {
    static Logger log = Logger.getLogger(StepItemController.class);
    @FXML
    public Pane stepPane;
    @FXML
    public Label onlyDesc;
    @FXML
    public ImageView ifIcon;
    @FXML
    private HBox stepHbox;
    @FXML
    public HBox stepItem;
    @FXML
    public Label name;
    @FXML
    public Label show;
    @FXML
    private Label itemSeparator;
    @FXML
    public ImageView smallImg;
    @FXML
    public StackPane icon;
    @FXML
    public VBox content;
    @FXML
    public StackPane separator;
    @FXML
    public BorderPane onlyDesPane;
    @FXML
    public BorderPane stepHboxPane;
    @FXML
    public StackPane imagePane;
    @FXML
    BorderPane imageIndexPane;
    private String act;
    private String ele;
    @FXML
    public Label imageindex;
    @FXML
    public Label stepindex;
    @FXML
    public Label breakPoint;
    private String imgPath;
    private boolean isScreenshotStep = false;
    private ScriptShowController scriptShowController;
    private k testAction;
    private int oriOnlyDesPaneWidth;
    private int oriStepHboxPaneWidth;
    private int oriContentWidth;
    Popup popup = new Popup();
    private long mousedownMills = 0L;
    private boolean isCanDrag = false;

    public StepItemController(ScriptShowController showController) {
        this.scriptShowController = showController;
        this.loadFxml();
        this.updateView();
        this.initDragDrop();
        if (this.onlyDesPane != null) {
            this.oriOnlyDesPaneWidth = (int)this.onlyDesPane.getPrefWidth();
        }
        if (this.stepHboxPane != null) {
            this.oriStepHboxPaneWidth = (int)this.stepHboxPane.getPrefWidth();
        }
        if (this.content != null) {
            this.oriContentWidth = (int)this.content.getPrefWidth();
        }
        TopController.setStepItemEventListener(this);
        this.setSize();
    }

    public StepItemController(k action, ScriptShowController showController) {
        if (d.g.equals((Object)action.getActionType())) {
            this.setScreenshotStep(true);
            this.loadStepImage();
            y tas = (y)action;
            this.showStepImageInfo(tas.N(), tas.getImageName(), tas.G());
        } else {
            this.loadFxml();
            this.updateItemViaTestAction(action);
            this.updateView();
        }
        this.scriptShowController = showController;
        this.initDragDrop();
        if (this.onlyDesPane != null) {
            this.oriOnlyDesPaneWidth = (int)this.onlyDesPane.getPrefWidth();
        }
        if (this.stepHboxPane != null) {
            this.oriStepHboxPaneWidth = (int)this.stepHboxPane.getPrefWidth();
        }
        if (this.content != null) {
            this.oriContentWidth = (int)this.content.getPrefWidth();
        }
        TopController.setStepItemEventListener(this);
        this.setSize();
    }

    private void initDragDrop() {
        ObservableList items = this.scriptShowController.listView.getItems();
        this.setOnMousePressed(event -> {
            this.mousedownMills = System.currentTimeMillis();
        });
        this.setOnMouseDragged(event -> {
            this.isCanDrag = System.currentTimeMillis() - this.mousedownMills > 300L;
        });
        this.setOnDragDetected(event -> {
            if (this.getTestAction() == null && !this.isScreenshotStep || !this.isCanDrag) {
                return;
            }
            Dragboard dragboard = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            WritableImage snapshot = this.getParent().snapshot(new SnapshotParameters(), null);
            dragboard.setDragView(new ImageView((Image)snapshot).getImage());
            ClipboardContent content = new ClipboardContent();
            content.putString(String.valueOf(items.indexOf((Object)this)));
            dragboard.setContent((Map)content);
            event.consume();
        });
        this.setOnDragOver(event -> {
            if (this.getTestAction() == null && !this.isScreenshotStep) {
                return;
            }
            if (!event.getDragboard().getString().equals(String.valueOf(items.indexOf((Object)this))) && event.getDragboard().hasString()) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            event.consume();
        });
        this.setOnDragEntered(event -> {
            if (!event.getDragboard().getString().equals(String.valueOf(items.indexOf((Object)this))) && event.getDragboard().hasString()) {
                this.setOpacity(0.3);
            }
        });
        this.setOnDragExited(event -> {
            if (!event.getDragboard().getString().equals(String.valueOf(items.indexOf((Object)this))) && event.getDragboard().hasString()) {
                this.setOpacity(1.0);
            }
        });
        this.setOnDragDropped(event -> {
            if (this.getTestAction() == null && !this.isScreenshotStep) {
                return;
            }
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasString()) {
                int thisIdx;
                StepItemController dragItem = (StepItemController)event.getGestureSource();
                int draggedIdx = items.indexOf((Object)dragItem);
                if (draggedIdx < (thisIdx = items.indexOf((Object)this))) {
                    for (int idx = draggedIdx; idx < thisIdx; ++idx) {
                        items.set(idx, items.get(idx + 1));
                    }
                    items.set(thisIdx, (Object)dragItem);
                } else {
                    for (int idx = draggedIdx; idx > thisIdx; --idx) {
                        items.set(idx, items.get(idx - 1));
                    }
                }
                items.set(thisIdx, (Object)dragItem);
                this.scriptShowController.getLogic().updateStepIndexs();
                com.testin.itestin.business.k.a().a(draggedIdx, thisIdx);
                if (b.a().a() != null) {
                    b.a().a().setSaveScript(true);
                }
                this.scriptShowController.listView.getSelectionModel().select(thisIdx);
                success = true;
            }
            this.setOpacity(1.0);
            this.isCanDrag = false;
            event.setDropCompleted(success);
            event.consume();
        });
        this.setOnDragDone(Event::consume);
    }

    private void updateItemViaTestAction(k action) {
        if (action == null) {
            return;
        }
        this.setTestAction(action);
        this.setAct(action.getActionName());
        if (action.B() != null && !action.B().isEmpty()) {
            this.setEle(action.B());
        } else if (action.getActionType() == d.h) {
            String show = action.z();
            this.setEle(show);
        } else {
            String display = d.N.equals((Object)action.getActionType()) ? action.z() : action.z().replace("##@@", "\n");
            this.setEle(display);
        }
        if (action.getActionType() == d.D || action.getActionType() == d.E || action.getActionType() == d.F || action.getActionType() == d.H || action.getActionType() == d.I || action.getActionType() == d.G || action.getActionType() == d.L && action.A().contains("]],") || action.getActionType() == d.j && action.A().contains("]],")) {
            String smallImage = a.a((m)action, "smallImage");
            if (StringUtils.isNotEmpty((String)smallImage)) {
                this.setImgPath(smallImage);
            }
        } else if (StringUtils.isNotEmpty((String)action.G())) {
            this.setImgPath(action.G());
        }
    }

    private void loadFxml() {
        this.loadItemXml("/com/testin/javafx/ui/include/StepItem.fxml");
    }

    private void loadStepImage() {
        this.loadItemXml("/com/testin/javafx/ui/include/StepImageItem.fxml");
    }

    private void loadItemXml(String xml) {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource(xml));
        try {
            fxmlLoader.setRoot((Object)this);
            fxmlLoader.setController((Object)this);
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setHboxBackground(boolean phoneInput) {
        if (phoneInput) {
            UIController.updateNodeSytleClass((Node)this.stepHbox, "emulatorMobileHold");
        }
    }

    private void showStepIcon(String name) {
        String img = "/com/testin/javafx/resources/" + name;
        Image image = new Image(StepItemController.class.getResourceAsStream(img));
        this.ifIcon.setImage(image);
    }

    private void showStepImageInfo(String stepNote, String stepDescription, String imagePath) {
        if (StringUtils.isEmpty((String)stepNote)) {
            this.content.getChildren().remove(1);
        } else {
            this.show.setText(stepNote);
            this.setEle(stepNote);
        }
        if (StringUtils.isNotEmpty((String)stepDescription)) {
            this.setAct(stepDescription);
            this.name.setText(stepDescription);
        }
        this.setImgPath(imagePath);
        this.name.setWrapText(true);
        this.showStepImage(imagePath);
    }

    public void updateStepImage(Image image) {
        this.ifIcon.setImage(image);
        BufferedImage big = SwingFXUtils.fromFXImage((Image)image, null);
        double mScale = a.a(big.getWidth(), big.getHeight());
        BufferedImage temp = a.makeThumbnail(big, g.b(new Double(mScale * (double)big.getWidth())), g.b(new Double(mScale * (double)big.getHeight())));
        BufferedImage small = a.makeThumbnail(temp, 60, 40);
        this.saveSmallImage(small, false);
        File f2 = new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + this.getImgPath());
        a.a(temp, f2);
    }

    private void showStepImage(String imagePath) {
        if (StringUtils.isEmpty((String)imagePath)) {
            this.showStepIcon("screenshot.png");
            return;
        }
        try {
            if (com.testin.itestin.business.k.a().isRecording()) {
                if (a.b.containsKey(imagePath)) {
                    if (a.b.get(imagePath) != null) {
                        WritableImage icon = SwingFXUtils.toFXImage((BufferedImage)a.b.get(imagePath), null);
                        this.ifIcon.setImage((Image)icon);
                        this.saveSmallImage(a.b.get(imagePath), true);
                    }
                } else {
                    this.showThumbnailImg(this.ifIcon);
                }
            } else {
                String name = this.getThumbnailImg(imagePath);
                File f2 = new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + name);
                InputStream input = null;
                if (!f2.exists()) {
                    BufferedImage nail = a.makeThumbnail(ImageIO.read(new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + imagePath)), 60, 40);
                    this.saveSmallImage(nail, false);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)nail, "png", os);
                    input = new ByteArrayInputStream(os.toByteArray());
                    os.close();
                } else {
                    input = new FileInputStream(f2);
                }
                Image icon = new Image(input);
                ((InputStream)input).close();
                this.ifIcon.setImage(icon);
            }
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
    }

    private void updateView() {
        if (this.getActionType().equals((Object)d.u)) {
            this.onlyDesc.textProperty().set((Object)("     " + this.getEle()));
            this.stepHbox.setVisible(false);
            return;
        }
        this.onlyDesc.setVisible(false);
        switch (2.$SwitchMap$com$testin$itestin$business$actions$ActionType[this.getActionType().ordinal()]) {
            case 1: {
                this.showStepIcon("if.png");
                break;
            }
            case 2: {
                this.showStepIcon("fi.png");
                break;
            }
            case 3: {
                this.showStepIcon("loopstart.png");
                break;
            }
            case 4: {
                this.showStepIcon("loopend.png");
                break;
            }
            case 5: {
                this.showStepIcon("manualstep.png");
                break;
            }
        }
        this.name.textProperty().set((Object)this.getActionName());
        this.show.textProperty().set((Object)this.getEle());
        try {
            if (!StringUtils.isEmpty((String)this.getImgPath())) {
                if (com.testin.itestin.business.k.a().isRecording()) {
                    if (a.b.containsKey(this.getImgPath())) {
                        if (a.b.get(this.getImgPath()) != null) {
                            WritableImage icon = SwingFXUtils.toFXImage((BufferedImage)a.b.get(this.getImgPath()), null);
                            this.smallImg.setImage((Image)icon);
                            this.saveSmallImage(a.b.get(this.getImgPath()), true);
                        }
                    } else {
                        String name = this.getThumbnailImg(this.getImgPath());
                        File f2 = new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + name);
                        ByteArrayInputStream input = null;
                        if (!f2.exists()) {
                            BufferedImage nail = a.makeThumbnail(ImageIO.read(new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + this.getImgPath())), 130, 36);
                            this.saveSmallImage(nail, false);
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)nail, "png", os);
                            input = new ByteArrayInputStream(os.toByteArray());
                            os.close();
                            Image icon = new Image((InputStream)input);
                            ((InputStream)input).close();
                            this.smallImg.setImage(icon);
                        } else {
                            this.showThumbnailImg(this.smallImg);
                        }
                    }
                } else {
                    String name = this.getThumbnailImg(this.getImgPath());
                    File f3 = new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + name);
                    InputStream input = null;
                    if (!f3.exists()) {
                        BufferedImage nail = a.makeThumbnail(ImageIO.read(new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + this.getImgPath())), 130, 36);
                        this.saveSmallImage(nail, false);
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)nail, "png", os);
                        input = new ByteArrayInputStream(os.toByteArray());
                        os.close();
                    } else {
                        input = new FileInputStream(f3);
                    }
                    Image icon = new Image(input);
                    ((InputStream)input).close();
                    this.smallImg.setImage(icon);
                }
            } else {
                this.itemSeparator.setVisible(false);
            }
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
    }

    private void showThumbnailImg(ImageView img) throws Exception {
        String name = this.getThumbnailImg(this.getImgPath());
        File f2 = new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + name);
        if (f2.exists()) {
            FileInputStream input = new FileInputStream(f2);
            Image icon = new Image((InputStream)input);
            ((InputStream)input).close();
            img.setImage(icon);
        }
    }

    private void saveSmallImage(final BufferedImage smallImg, final boolean needToRemove) {
        new Thread(){

            @Override
            public void run() {
                try {
                    File f2 = new File(com.testin.itestin.business.k.a().getCasePath() + "img");
                    if (!f2.exists()) {
                        f2.mkdirs();
                    }
                    String name = StepItemController.this.getThumbnailImg(StepItemController.this.getImgPath());
                    BufferedImage save = smallImg;
                    if (save.getWidth() > 400 || save.getHeight() > 400) {
                        double mScale = a.a(smallImg.getWidth(), smallImg.getHeight());
                        save = a.makeThumbnail(smallImg, g.b(new Double(mScale * (double)smallImg.getWidth())), g.b(new Double(mScale * (double)smallImg.getHeight())));
                    }
                    ImageIO.write((RenderedImage)save, "png", new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + name));
                    if (needToRemove) {
                        a.b.remove(StepItemController.this.getImgPath());
                    }
                }
                catch (Exception e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }.start();
    }

    @FXML
    public void showEnter(MouseEvent event) {
        if (this.ele == null) {
            return;
        }
        Tooltip tt = new Tooltip(this.ele);
        if (a.a(this.ele) > 70) {
            tt.setWrapText(true);
            tt.setTextAlignment(TextAlignment.LEFT);
            tt.setPrefWidth(500.0);
        } else {
            tt.setPrefWidth(-1.0);
        }
        tt.setStyle("-fx-font-size:12px;-fx-font-family:\"Microsoft Yahei\",Tahoma,Arial,Helvetica,STHeiti;");
        this.show.setTooltip(tt);
    }

    @FXML
    public void showStepTooltip(MouseEvent event) {
        if (this.act == null) {
            return;
        }
        Tooltip tt = new Tooltip(this.act);
        if (a.a(this.act) > 70) {
            tt.setWrapText(true);
            tt.setTextAlignment(TextAlignment.LEFT);
            tt.setPrefWidth(500.0);
        } else {
            tt.setPrefWidth(-1.0);
        }
        tt.setStyle("-fx-font-size:12px;-fx-font-family:\"Microsoft Yahei\",Tahoma,Arial,Helvetica,STHeiti;");
        this.name.setTooltip(tt);
    }

    @FXML
    public void imgClicked(MouseEvent event) {
        if (StringUtils.isEmpty((String)this.getImgPath())) {
            return;
        }
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_ENTERED")) {
            try {
                File f2;
                g.sleep(600L);
                if (!StringUtils.isEmpty((String)this.getImgPath()) && (f2 = new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + this.getImgPath())).exists()) {
                    int width = 320;
                    int height = 440;
                    double des = (double)width / (double)height;
                    BufferedImage bi = ImageIO.read(f2);
                    double src = (double)bi.getWidth() / (double)bi.getHeight();
                    if (des > src) {
                        if (bi.getHeight() > 440) {
                            width = (int)(440.0 * src);
                        } else {
                            width = bi.getWidth();
                            height = bi.getHeight();
                        }
                    } else if (bi.getWidth() > 320) {
                        height = (int)(320.0 / src);
                    } else {
                        width = bi.getWidth();
                        height = bi.getHeight();
                    }
                    BufferedImage nail = a.makeThumbnail(bi, width, height);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)nail, "png", os);
                    ByteArrayInputStream input = new ByteArrayInputStream(os.toByteArray());
                    Image image = new Image((InputStream)input);
                    ImageView imgView = new ImageView(image);
                    ((InputStream)input).close();
                    os.close();
                    this.popup.setX(10.0 + event.getScreenX());
                    this.popup.setY(10.0 + event.getScreenY());
                    this.popup.getContent().add((Object)imgView);
                    this.popup.show((Window)b.a().a());
                }
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            this.popup.hide();
        } else if (eventType.equals("MOUSE_MOVED")) {
            // empty if block
        }
    }

    @FXML
    public void iconClick(MouseEvent event) {
        event.consume();
        if (event.getClickCount() > 1) {
            this.setBreakPointUi();
        }
    }

    public void setBreakPointUi() {
        if (((String)this.breakPoint.getStyleClass().get(0)).equals("breakPoint")) {
            UIController.updateNodeSytleClass((Node)this.breakPoint, "stepindex");
            this.testAction.u(false);
        } else {
            UIController.updateNodeSytleClass((Node)this.breakPoint, "breakPoint");
            this.testAction.u(true);
        }
        com.testin.itestin.business.k.a().b(this.getTestAction(), this.scriptShowController.listView.getSelectionModel().getSelectedIndex());
    }

    public String getActionName() {
        return this.act;
    }

    public void setAct(String act) {
        this.act = act;
    }

    public String getEle() {
        return this.ele;
    }

    public void setEle(String ele) {
        this.ele = ele;
    }

    public String getImgPath() {
        return this.imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }

    private String getThumbnailImg(String smallName) {
        String name = smallName;
        name = name.substring(0, name.length() - 4) + "_thumb." + "png";
        return name;
    }

    public k getTestAction() {
        return this.testAction;
    }

    public void setTestAction(k action) {
        this.testAction = action;
        if (d.g.equals((Object)action.getActionType())) {
            this.setImgPath(action.G());
        }
    }

    public d getActionType() {
        if (this.getTestAction() != null) {
            return this.getTestAction().getActionType();
        }
        return d.w;
    }

    public void setImageStepIndex(int index) {
        this.imageindex.setText(String.valueOf(index));
    }

    public void setStepIndex(int index) {
        if (this.name != null && StringUtils.isNotEmpty((String)this.name.getText()) && this.stepindex != null) {
            this.stepindex.setText(String.valueOf(index));
        }
    }

    public boolean isScreenshotStep() {
        return this.isScreenshotStep;
    }

    public void setScreenshotStep(boolean isScreenshotStep) {
        this.isScreenshotStep = isScreenshotStep;
    }

    public String getStepIndexStatus() {
        return (String)this.stepindex.getStyleClass().get(0);
    }

    @Override
    public void setSize() {
        if (TopController.isFullScreen) {
            int w2 = (int)b.a().a().getWidth();
            int h2 = (int)b.a().a().getHeight();
            int emulatorSize = h2 - TemplateController.topHeigh - TemplateController.bottomHeigh - RecordActionController.oriBorderPaneHeigh;
            if (this.stepPane != null) {
                this.stepPane.setPrefWidth((double)(w2 - emulatorSize - 10));
            }
            if (this.onlyDesPane != null) {
                this.onlyDesPane.setPrefWidth((double)(w2 - emulatorSize - 10));
            }
            if (this.onlyDesc != null) {
                this.onlyDesc.setPrefWidth((double)(w2 - emulatorSize - 10));
            }
            if (this.stepHboxPane != null) {
                this.stepHboxPane.setPrefWidth((double)(w2 - emulatorSize - 10));
            }
            if (this.content != null && this.imagePane != null) {
                this.content.setPrefWidth((double)(w2 - emulatorSize) - this.imagePane.getPrefWidth() - 100.0);
            } else if (this.content != null && this.icon != null) {
                this.content.setPrefWidth((double)(w2 - emulatorSize) - this.icon.getPrefWidth() - 100.0);
            }
            if (this.show != null && this.imagePane != null) {
                this.show.setPrefWidth((double)(w2 - emulatorSize) - this.imagePane.getPrefHeight() - 100.0);
            } else if (this.show != null && this.icon != null) {
                this.show.setPrefWidth((double)(w2 - emulatorSize) - this.icon.getPrefWidth() - 100.0);
            }
            if (this.imageIndexPane != null) {
                this.imageIndexPane.setPrefWidth((double)(w2 - emulatorSize - 20));
            }
        } else {
            if (this.stepPane != null) {
                this.stepPane.setPrefWidth((double)this.oriOnlyDesPaneWidth);
            }
            if (this.onlyDesPane != null) {
                this.onlyDesPane.setPrefWidth((double)this.oriOnlyDesPaneWidth);
            }
            if (this.onlyDesc != null) {
                this.onlyDesc.setPrefWidth((double)this.oriOnlyDesPaneWidth);
            }
            if (this.stepHboxPane != null) {
                this.stepHboxPane.setPrefWidth((double)this.oriStepHboxPaneWidth);
            }
            if (this.content != null) {
                this.content.setPrefWidth((double)this.oriContentWidth);
            }
            if (this.show != null) {
                this.show.setPrefWidth((double)this.oriContentWidth);
            }
            if (this.imageIndexPane != null) {
                this.imageIndexPane.setPrefWidth((double)(this.oriOnlyDesPaneWidth - 20));
            }
        }
    }
}

