/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include.logic;

import com.testin.itestin.business.actions.b;
import com.testin.itestin.business.actions.coord.d;
import com.testin.itestin.business.actions.coord.e;
import com.testin.itestin.business.actions.coord.h;
import com.testin.itestin.business.actions.coord.k;
import com.testin.itestin.business.actions.coord.l;
import com.testin.itestin.business.actions.coord.m;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.business.utils.a;
import com.testin.itestin.os.c;
import com.testin.itestin.util.g;
import com.testin.itestin.util.n;
import com.testin.javafx.ui.control.d;
import com.testin.javafx.ui.control.m;
import com.testin.javafx.ui.control.u;
import com.testin.javafx.ui.control.y;
import com.testin.javafx.ui.include.EmulatorController;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.DecimalFormat;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EmulatorControllerLogic {
    static Logger log = Logger.getLogger(EmulatorControllerLogic.class);
    public EmulatorController controller;
    private BufferedImage thumb;

    public EmulatorControllerLogic(EmulatorController controller) {
        this.controller = controller;
    }

    public String getData(int rotation, int w2, int h2, com.testin.itestin.entitys.e rec) {
        DecimalFormat df = new DecimalFormat("#.0000");
        double endX = Double.parseDouble(df.format(this.controller.canvas.b.getX() + this.controller.canvas.b.getW()));
        double endY = Double.parseDouble(df.format(this.controller.canvas.b.getY() + this.controller.canvas.b.h()));
        return String.format("[[%s],[%s,%s],[%s,%s],[%s,%s,%s],[%s.png]]", rotation, Float.valueOf(this.controller.canvas.b.getX()), Float.valueOf(this.controller.canvas.b.getY()), endX, endY, w2, h2, g.r(rec.getName()), rec.getName());
    }

    public com.testin.itestin.business.actions.d getActByName(String name) {
        switch (name) {
            case "imageClick": {
                return com.testin.itestin.business.actions.d.D;
            }
            case "imageLongTouch": {
                return com.testin.itestin.business.actions.d.E;
            }
            case "imageDoubleClick": {
                return com.testin.itestin.business.actions.d.F;
            }
            case "imageAssert": {
                return com.testin.itestin.business.actions.d.G;
            }
            case "imageIf": {
                return com.testin.itestin.business.actions.d.j;
            }
            case "imageFor": {
                return com.testin.itestin.business.actions.d.L;
            }
            case "imageTrail": {
                return com.testin.itestin.business.actions.d.H;
            }
        }
        return com.testin.itestin.business.actions.d.w;
    }

    public com.testin.itestin.entitys.e getRectangleByPoints(int w2, int h2, com.testin.itestin.business.actions.d actionType) {
        com.testin.itestin.entitys.e rec = null;
        if (!this.controller.canvas.a.aR() && !UIController.getCoordEmulatorController().isCheckShot() || this.controller.canvas.a.getX() == -1.0f || this.controller.canvas.a.getY() == -1.0f || this.controller.canvas.a.getW() == -1.0f || this.controller.canvas.a.h() == -1.0f) {
            com.testin.javafx.ui.control.d.a(d.a.c, com.testin.itestin.business.actions.utils.d.e("coordemulatorcontroller.getimageaction.getrect"));
            return null;
        }
        com.testin.javafx.ui.control.m response = null;
        response = actionType.equals((Object)com.testin.itestin.business.actions.d.j) ? u.a("", "1.0", n.aW(), true) : y.a(com.testin.itestin.business.actions.utils.d.e("coordemulatorcontroller.handlemenuitem.imagename"), "", true, true, true);
        if (response.a == m.a.b) {
            String name = String.format("%s.%s", response.value, "png");
            if (StringUtils.isEmpty((String)response.value) || !a.j(com.testin.itestin.business.k.a().getCasePath() + name)) {
                com.testin.javafx.ui.control.d.a(d.a.c, com.testin.itestin.business.actions.utils.d.e("coordemulatorcontroller.getimageaction.invalid.picname"));
                return this.getRectangleByPoints(w2, h2, actionType);
            }
        } else {
            return null;
        }
        rec = this.getRecForDragViaOkResponse(w2, h2, response);
        this.controller.canvas.a.ag(false);
        return rec;
    }

    public boolean isExistedPicName(String name) {
        File[] fileList;
        String dir = com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator;
        if (new File(dir).exists() && null != (fileList = new File(dir).listFiles())) {
            for (File f2 : fileList) {
                String pic = f2.getName().substring(0, f2.getName().length() - 4);
                if (!pic.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean imageMatchCheck(com.testin.itestin.entitys.e myRec, int w2, int h2, int rotation, com.testin.itestin.business.actions.k action) {
        try {
            BufferedImage big = SwingFXUtils.fromFXImage((Image)this.controller.canvas.b(), null);
            int width = myRec.getX() + myRec.getWidth() > big.getWidth() ? big.getWidth() - myRec.getX() : myRec.getWidth();
            int height = myRec.getY() + myRec.getHeight() > big.getHeight() ? big.getHeight() - myRec.getY() : myRec.getHeight();
            BufferedImage small = big.getSubimage(myRec.getX(), myRec.getY(), width, height);
            File smallPic = new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + action.G());
            File bigPic = new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + action.E());
            if (!bigPic.getParentFile().exists()) {
                bigPic.getParentFile().mkdirs();
            }
            ImageIO.write((RenderedImage)small, "png", smallPic);
            ImageIO.write((RenderedImage)big, "png", bigPic);
            cn.testin.cv.g result = cn.testin.cv.b.a(bigPic.getAbsolutePath(), smallPic.getAbsolutePath(), myRec.getX(), myRec.getY(), w2, h2, rotation);
            bigPic.delete();
            if (result != null && !result.c()) {
                this.setThumb(null);
                com.testin.javafx.ui.control.d.a(d.a.c, com.testin.itestin.business.actions.utils.d.e("coordemulatorcontroller.getimageaction.clearimage"));
                return false;
            }
            this.setThumb(a.makeThumbnail(small, 130, 36));
            return true;
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            this.setThumb(null);
            return false;
        }
    }

    public void sendImageMatchAction(m cta) {
        long sleeptime = UIController.getActionTimeByData(cta, true);
        c tableMsg = new c();
        if (sleeptime > 0L && cta.getActionType() != com.testin.itestin.business.actions.d.L && cta.getActionType() != com.testin.itestin.business.actions.d.j) {
            com.testin.itestin.business.actions.k sleepAction = n.b((int)sleeptime);
            tableMsg = new c();
            tableMsg.setStatus(773);
            tableMsg.setContent(sleepAction);
            this.controller.queueActions.offer(tableMsg);
        }
        if (com.testin.itestin.business.k.a().q() && cta.getActionType() != com.testin.itestin.business.actions.d.L && cta.getActionType() != com.testin.itestin.business.actions.d.j) {
            com.testin.itestin.business.actions.y takeScreenAction = null;
            com.testin.itestin.business.actions.y action_screenshot = new com.testin.itestin.business.actions.y();
            action_screenshot.a(com.testin.itestin.business.actions.d.g);
            action_screenshot.setRule(b.I);
            action_screenshot.setImageName(UIController.getNextAutoImgName());
            takeScreenAction = action_screenshot;
            String timestamp = String.format("%s", System.currentTimeMillis());
            String imgName = String.format("%s%s.%s", timestamp, "_shot", "png");
            a.b.put(imgName, a.a(SwingFXUtils.fromFXImage((Image)this.controller.canvas.b(), null), imgName));
            takeScreenAction.F(imgName);
            tableMsg = new c();
            tableMsg.setStatus(773);
            tableMsg.setContent(takeScreenAction);
            this.controller.queueActions.offer(tableMsg);
        }
        tableMsg = new c();
        tableMsg.setStatus(773);
        tableMsg.setContent(cta);
        this.controller.queueActions.offer(tableMsg);
        UIController.setLastActionTimeToCurrentTime();
    }

    public BufferedImage getThumb() {
        return this.thumb;
    }

    public void setThumb(BufferedImage thumb) {
        this.thumb = thumb;
    }

    public void deletRelatedPics(com.testin.itestin.business.actions.k action) {
        File smallPic = new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + action.E());
        File bigPic = new File(com.testin.itestin.business.k.a().getCasePath() + "img" + File.separator + action.G());
        FileUtils.deleteQuietly((File)smallPic);
        FileUtils.deleteQuietly((File)bigPic);
    }

    public com.testin.itestin.entitys.e getRecForDragViaOkResponse(int width, int height, com.testin.javafx.ui.control.m response) {
        com.testin.itestin.entitys.e rec = new com.testin.itestin.entitys.e();
        if (response.a == m.b.b) {
            rec.T(true);
        }
        if (response.a == m.b.c) {
            rec.T(false);
        }
        DecimalFormat df = new DecimalFormat("#.0000");
        double endX = Double.parseDouble(df.format(this.controller.canvas.b.getX() + this.controller.canvas.b.getW()));
        double endY = Double.parseDouble(df.format(this.controller.canvas.b.getY() + this.controller.canvas.b.h()));
        int x0 = (int)(this.controller.canvas.b.getX() * (float)width);
        int y0 = (int)(this.controller.canvas.b.getY() * (float)height);
        int x1 = (int)(endX * (double)width);
        int y1 = (int)(endY * (double)height);
        rec.setX(x0);
        rec.setY(y0);
        rec.setWidth(Math.abs(x1 - x0));
        rec.setHeight(Math.abs(y1 - y0));
        rec.setName(response.value);
        return rec;
    }

    public m getCoordImageTouchActionByType(int w2, int h2, int rotation, com.testin.itestin.entitys.e rec, com.testin.itestin.business.actions.d actionType) {
        m imageAction = new m();
        float startX = this.controller.canvas.b.getX();
        float startY = this.controller.canvas.b.getY();
        float endX = this.controller.canvas.b.getX() + this.controller.canvas.b.getW();
        float endY = this.controller.canvas.b.getY() + this.controller.canvas.b.h();
        String imageName = rec.getName();
        if (actionType.equals((Object)com.testin.itestin.business.actions.d.F)) {
            imageAction = new e();
        }
        if (actionType.equals((Object)com.testin.itestin.business.actions.d.E)) {
            imageAction = new k();
        }
        if (actionType.equals((Object)com.testin.itestin.business.actions.d.G)) {
            imageAction = new d();
        }
        if (actionType.equals((Object)com.testin.itestin.business.actions.d.j)) {
            imageAction = new h();
            imageAction.setExist(rec.aw());
        }
        if (actionType.equals((Object)com.testin.itestin.business.actions.d.L)) {
            imageAction = new l();
            imageAction.setExist(rec.aw());
        }
        imageAction.e().add(Float.valueOf(startX));
        imageAction.f().add(Float.valueOf(startY));
        imageAction.g().add(Float.valueOf(endX));
        imageAction.h().add(Float.valueOf(endY));
        imageAction.setImageName(imageName);
        imageAction.j().add(h2);
        imageAction.i().add(w2);
        imageAction.k().add(rotation);
        imageAction.b(actionType);
        imageAction.s(true);
        return imageAction;
    }
}

