/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.update;

import com.testin.javafx.update.DlFile;
import com.testin.javafx.update.RemoteFile;
import com.testin.javafx.update.b;
import com.testin.javafx.update.d;
import com.testin.javafx.update.e;
import com.testin.javafx.update.f;
import com.testin.javafx.update.g;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.rauschig.jarchivelib.CompressionType;

public class Updater
implements d {
    static Logger log = Logger.getLogger(Updater.class);
    private static Updater update = new Updater();
    private a updaterListener;
    private f updateChecker = new f();
    private List<DlFile> dlFiles = new ArrayList<DlFile>();
    private List<String> backupFiles = new ArrayList<String>();

    private Updater() {
    }

    public static Updater getInstance() {
        return update;
    }

    public void setUpdaterListener(a updaterListener) {
        this.updaterListener = updaterListener;
    }

    public boolean isUpdateNeeded() {
        return this.updateChecker.h();
    }

    public boolean update() {
        boolean res = false;
        try {
            res = this.downloadFiles();
            if (res) {
                this.backupFiles();
                boolean delSuccess = this.delDiscardFile();
                boolean unzipSuccess = this.unzipFiles();
                boolean copySuccess = this.copyFiles();
                System.err.println("del: " + delSuccess + " unzip: " + unzipSuccess + " copy: " + copySuccess);
                if (delSuccess && unzipSuccess && copySuccess) {
                    this.updateLocalXml();
                    res = true;
                } else {
                    this.rollbackFiles();
                }
            }
        }
        catch (IOException e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
        return res;
    }

    private boolean unzipFiles() {
        boolean success = true;
        for (DlFile dl : this.dlFiles) {
            if (!dl.isUnzip() || !StringUtils.isNotEmpty((String)dl.getLocal())) continue;
            Archiver archiver = null;
            if (dl.getLocal().toLowerCase().endsWith(".zip")) {
                archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.ZIP);
            } else if (dl.getLocal().toLowerCase().endsWith(".tar.gz")) {
                archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.TAR, (CompressionType)CompressionType.GZIP);
            }
            if (archiver == null) continue;
            File zipFile = new File(dl.getLocal());
            String destPath = com.testin.itestin.service.a.Z() + File.separator + dl.getPath();
            File destDir = new File(destPath);
            try {
                archiver.extract(zipFile, destDir);
            }
            catch (IOException e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
                success = false;
                break;
            }
        }
        return success;
    }

    private boolean delDiscardFile() {
        boolean success = true;
        try {
            List<RemoteFile> discardFiles = f.m();
            for (RemoteFile rf : discardFiles) {
                String path = rf.getPath().replace(" ", "");
                String src = g.Z() + File.separator + path;
                File srcF = new File(src);
                FileUtils.deleteQuietly((File)srcF);
            }
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            success = false;
        }
        return success;
    }

    private boolean downloadFiles() {
        List<RemoteFile> updateFiles = this.updateChecker.n();
        int fileCount = updateFiles.size();
        for (int i2 = 0; i2 < fileCount; ++i2) {
            RemoteFile rf = updateFiles.get(i2);
            String local = g.ad() + File.separator + rf.getPath();
            if (rf.isUnZip() || rf.getPath().contains("..") && !rf.isNeedDelete()) {
                local = g.ad() + File.separator + rf.getUrl().substring(rf.getUrl().lastIndexOf("/") + 1);
            }
            File fn = new File(local);
            fn.getParentFile().mkdirs();
            if (this.updaterListener != null) {
                this.updaterListener.download(fn.getName(), fileCount, i2 + 1);
            }
            if (rf.isNeedDelete()) {
                this.onDlStateChange(1, 1, 1);
                continue;
            }
            DlFile dlFile = b.a(rf.getUrl(), local, this);
            if (dlFile.getState() == 2) {
                dlFile.setRemoteFile(rf);
                this.dlFiles.add(dlFile);
                continue;
            }
            String msg = String.format("%s\u66f4\u65b0\u5931\u8d25!", fn.getName());
            log.info((Object)msg);
            if (this.updaterListener != null) {
                this.updaterListener.updateError();
            }
            return false;
        }
        return true;
    }

    private void backupFiles() throws IOException {
        File srcF;
        String dest;
        String src;
        String path;
        File bkDir = new File(g.bj());
        FileUtils.deleteDirectory((File)bkDir);
        bkDir.mkdirs();
        for (DlFile df : this.dlFiles) {
            String local = df.getLocal();
            path = local.replace(g.ad(), "");
            src = g.Z() + File.separator + path;
            dest = g.bj() + File.separator + path;
            srcF = new File(src);
            this.copyFile(srcF, new File(dest));
        }
        List<RemoteFile> discardFiles = f.m();
        for (RemoteFile rf : discardFiles) {
            path = rf.getPath().replace(" ", "");
            src = g.Z() + File.separator + path;
            dest = g.bj() + File.separator + path;
            srcF = new File(src);
            this.copyFile(srcF, new File(dest));
        }
    }

    private boolean copyFiles() {
        boolean res = true;
        try {
            for (DlFile df : this.dlFiles) {
                if (df.isUnzip()) continue;
                String local = df.getLocal();
                String path = df.getPath();
                String dest = g.Z() + File.separator + path;
                File srcF = new File(local);
                this.backupFiles.add(local);
                if (StringUtils.isNotEmpty((String)cn.testin.cv.d.d()) && new File(cn.testin.cv.d.d()).exists() && srcF.getName().equals(new File(cn.testin.cv.d.d()).getName())) {
                    log.info((Object)(new File(cn.testin.cv.d.d()).getName() + " to unload"));
                    com.testin.itestin.business.utils.a.af(new File(cn.testin.cv.d.d()).getName());
                }
                this.copyFile(srcF, new File(dest));
            }
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            res = false;
        }
        return res;
    }

    private void rollbackFiles() throws IOException {
        Iterator<String> iterator = this.backupFiles.iterator();
        while (iterator.hasNext()) {
            String str;
            String src = str = iterator.next();
            String path = src.replace(g.ad(), "");
            String dest = g.Z() + File.separator + path;
            File srcF = new File(src);
            this.copyFile(srcF, new File(dest));
        }
    }

    private void updateLocalXml() throws IOException {
        e remoteXml = this.updateChecker.a();
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        xml.append("<Config xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n");
        xml.append("<Enabled>true</Enabled>\r\n");
        xml.append(String.format("<ServerUrl>%s</ServerUrl>\r\n", g.aZ()));
        xml.append(String.format("<publishTime>%s</publishTime>\r\n", remoteXml.ba()));
        xml.append(String.format("<version>%s</version>\r\n", remoteXml.getVersion()));
        xml.append(String.format("<PublishInfo>%s</PublishInfo>\r\n", remoteXml.bb()));
        xml.append("<UpdateFileList>\r\n");
        for (RemoteFile rf : remoteXml.l()) {
            String str = "<LocalFile path=\"%s\" lastver=\"%s\" size=\"%s\" />\r\n";
            str = String.format(str, rf.getPath(), rf.getLastver(), rf.getSize());
            xml.append(str);
        }
        xml.append("</UpdateFileList>\r\n");
        xml.append("</Config>\r\n");
        this.saveLocalXml(xml.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLocalXml(String xml) throws IOException {
        String localXmlPath = g.bg();
        File f2 = new File(localXmlPath);
        FileUtils.deleteQuietly((File)f2);
        byte[] buff = xml.getBytes("utf-8");
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(f2);
            fos.write(buff);
            fos.flush();
            fos.close();
            fos = null;
        }
    }

    public void copyFile(File srcF, File destFile) {
        try {
            if (srcF.exists()) {
                if (srcF.isFile()) {
                    FileUtils.copyFile((File)srcF, (File)destFile);
                }
                if (srcF.isDirectory()) {
                    FileUtils.copyDirectory((File)srcF, (File)destFile);
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
    }

    @Override
    public void onDlStateChange(int state, int length, int transferred) {
        if (this.updaterListener != null) {
            this.updaterListener.transferred(length, transferred);
        }
    }

    public static interface a {
        public void download(String var1, int var2, int var3);

        public void transferred(long var1, long var3);

        public void updateError();
    }
}

