/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detdesc;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.feature.SurfFeature;
import boofcv.struct.feature.SurfFeatureQueue;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.struct.GrowQueue_F64;

public class WrapDetectDescribeSurf<T extends ImageSingleBand, II extends ImageSingleBand>
implements DetectDescribePoint<T, SurfFeature> {
    private FastHessianFeatureDetector<II> detector;
    private OrientationIntegral<II> orientation;
    private DescribePointSurf<II> describe;
    private II ii;
    private SurfFeatureQueue features;
    private List<ScalePoint> foundPoints;
    private GrowQueue_F64 featureAngles = new GrowQueue_F64(10);

    public WrapDetectDescribeSurf(FastHessianFeatureDetector<II> detector, OrientationIntegral<II> orientation, DescribePointSurf<II> describe) {
        this.detector = detector;
        this.orientation = orientation;
        this.describe = describe;
        this.features = new SurfFeatureQueue(describe.getDescriptionLength());
    }

    @Override
    public SurfFeature createDescription() {
        return this.describe.createDescription();
    }

    @Override
    public SurfFeature getDescription(int index) {
        return (SurfFeature)this.features.get(index);
    }

    @Override
    public Class<SurfFeature> getDescriptionType() {
        return SurfFeature.class;
    }

    @Override
    public void detect(T input) {
        if (this.ii != null) {
            this.ii.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        }
        this.ii = GIntegralImageOps.transform(input, this.ii);
        this.orientation.setImage(this.ii);
        this.describe.setImage(this.ii);
        this.features.reset();
        this.featureAngles.reset();
        this.detector.detect(this.ii);
        this.foundPoints = this.detector.getFoundPoints();
        for (int i = 0; i < this.foundPoints.size(); ++i) {
            ScalePoint p = this.foundPoints.get(i);
            this.orientation.setScale(p.scale);
            double angle = this.orientation.compute(p.x, p.y);
            this.describe.describe(p.x, p.y, angle, p.scale, (SurfFeature)this.features.grow());
            this.featureAngles.push(angle);
        }
    }

    @Override
    public int getNumberOfFeatures() {
        return this.foundPoints.size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.foundPoints.get(featureIndex);
    }

    @Override
    public double getScale(int featureIndex) {
        return this.foundPoints.get((int)featureIndex).scale;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return this.featureAngles.get(featureIndex);
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return true;
    }
}

