/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.alg.feature.detect.interest.FeatureLaplacePyramid;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.PyramidFloat;
import georegression.struct.point.Point2D_F64;
import java.util.List;

public class WrapFLPtoInterestPoint<T extends ImageSingleBand, D extends ImageSingleBand>
implements InterestPointDetector<T> {
    FeatureLaplacePyramid<T, D> detector;
    List<ScalePoint> location;
    PyramidFloat<T> ss;

    public WrapFLPtoInterestPoint(FeatureLaplacePyramid<T, D> detector, PyramidFloat<T> ss) {
        this.detector = detector;
        this.ss = ss;
    }

    @Override
    public void detect(T input) {
        this.ss.process(input);
        this.detector.detect(this.ss);
        this.location = this.detector.getInterestPoints();
    }

    @Override
    public int getNumberOfFeatures() {
        return this.location.size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.location.get(featureIndex);
    }

    @Override
    public double getScale(int featureIndex) {
        return this.location.get((int)featureIndex).scale;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return 0.0;
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return false;
    }
}

