/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.feature.detect.interest.SiftImageScaleSpace;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.ImageFloat32;
import georegression.struct.point.Point2D_F64;

public class WrapSiftDetector
implements InterestPointDetector<ImageFloat32> {
    SiftImageScaleSpace ss;
    SiftDetector detector;

    public WrapSiftDetector(SiftDetector detector, SiftImageScaleSpace ss) {
        this.detector = detector;
        this.ss = ss;
    }

    @Override
    public void detect(ImageFloat32 input) {
        this.ss.constructPyramid(input);
        this.ss.computeFeatureIntensity();
        this.detector.process(this.ss);
    }

    @Override
    public int getNumberOfFeatures() {
        return this.detector.getFoundPoints().size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return (Point2D_F64)this.detector.getFoundPoints().get(featureIndex);
    }

    @Override
    public double getScale(int featureIndex) {
        return ((ScalePoint)((Object)this.detector.getFoundPoints().get((int)featureIndex))).scale;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return 0.0;
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return false;
    }
}

