/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.disparity;

import boofcv.abst.feature.disparity.StereoDisparity;
import boofcv.alg.feature.disparity.DisparityScoreRowFormat;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageSingleBand;

public class WrapDisparitySadRect<T extends ImageSingleBand, D extends ImageSingleBand>
implements StereoDisparity<T, D> {
    DisparityScoreRowFormat<T, D> alg;
    D disparity;

    public WrapDisparitySadRect(DisparityScoreRowFormat<T, D> alg) {
        this.alg = alg;
    }

    @Override
    public void process(T imageLeft, T imageRight) {
        if (this.disparity == null || ((ImageSingleBand)this.disparity).width != ((ImageSingleBand)imageLeft).width || ((ImageSingleBand)this.disparity).height != ((ImageSingleBand)imageLeft).height) {
            this.disparity = GeneralizedImageOps.createSingleBand(this.alg.getDisparityType(), (int)((ImageSingleBand)imageLeft).width, (int)((ImageSingleBand)imageLeft).height);
            GImageMiscOps.fill(this.disparity, (double)(this.getMaxDisparity() + 1));
        }
        this.alg.process(imageLeft, imageRight, this.disparity);
    }

    @Override
    public D getDisparity() {
        return this.disparity;
    }

    @Override
    public int getBorderX() {
        return this.alg.getBorderX();
    }

    @Override
    public int getBorderY() {
        return this.alg.getBorderY();
    }

    @Override
    public int getMinDisparity() {
        return this.alg.getMinDisparity();
    }

    @Override
    public int getMaxDisparity() {
        return this.alg.getMaxDisparity();
    }

    @Override
    public Class<T> getInputType() {
        return this.alg.getInputType();
    }

    @Override
    public Class<D> getDisparityType() {
        return this.alg.getDisparityType();
    }

    public DisparityScoreRowFormat<T, D> getAlg() {
        return this.alg;
    }
}

