/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;

public class ImplMedianCornerIntensity {
    public static void process(ImageFloat32 intensity, ImageFloat32 originalImage, ImageFloat32 medianImage) {
        int width = originalImage.width;
        int height = originalImage.height;
        for (int y = 0; y < height; ++y) {
            int indexOrig = originalImage.startIndex + originalImage.stride * y;
            int indexMed = medianImage.startIndex + medianImage.stride * y;
            int indexInten = intensity.startIndex + intensity.stride * y;
            for (int x = 0; x < width; ++x) {
                float val = originalImage.data[indexOrig++] - medianImage.data[indexMed++];
                intensity.data[indexInten++] = val < 0.0f ? -val : val;
            }
        }
    }

    public static void process(ImageFloat32 intensity, ImageUInt8 originalImage, ImageUInt8 medianImage) {
        int width = originalImage.width;
        int height = originalImage.height;
        for (int y = 0; y < height; ++y) {
            int indexOrig = originalImage.startIndex + originalImage.stride * y;
            int indexMed = medianImage.startIndex + medianImage.stride * y;
            int indexInten = intensity.startIndex + intensity.stride * y;
            for (int x = 0; x < width; ++x) {
                int val = (originalImage.data[indexOrig++] & 0xFF) - (medianImage.data[indexMed++] & 0xFF);
                intensity.data[indexInten++] = val < 0 ? (float)(-val) : (float)val;
            }
        }
    }
}

