/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.ImageSingleBand;

public abstract class DisparityScoreRowFormat<Input extends ImageSingleBand, Disparity extends ImageSingleBand> {
    protected int minDisparity;
    protected int maxDisparity;
    protected int rangeDisparity;
    protected int lengthHorizontal;
    protected int radiusX;
    protected int radiusY;
    protected int regionWidth;
    protected int regionHeight;

    public DisparityScoreRowFormat(int minDisparity, int maxDisparity, int regionRadiusX, int regionRadiusY) {
        if (maxDisparity <= 0) {
            throw new IllegalArgumentException("Max disparity must be greater than zero");
        }
        if (minDisparity < 0 || minDisparity >= maxDisparity) {
            throw new IllegalArgumentException("Min disparity must be >= 0 and < maxDisparity");
        }
        this.minDisparity = minDisparity;
        this.maxDisparity = maxDisparity;
        this.radiusX = regionRadiusX;
        this.radiusY = regionRadiusY;
        this.rangeDisparity = maxDisparity - minDisparity;
        this.regionWidth = regionRadiusX * 2 + 1;
        this.regionHeight = regionRadiusY * 2 + 1;
    }

    public void process(Input left, Input right, Disparity disparity) {
        InputSanityCheck.checkSameShape(left, right, disparity);
        if (this.maxDisparity > ((ImageSingleBand)left).width - 2 * this.radiusX) {
            throw new RuntimeException("The maximum disparity is too large for this image size: max size " + (((ImageSingleBand)left).width - 2 * this.radiusX));
        }
        this.lengthHorizontal = ((ImageSingleBand)left).width * this.rangeDisparity;
        this._process(left, right, disparity);
    }

    public abstract void _process(Input var1, Input var2, Disparity var3);

    public abstract Class<Input> getInputType();

    public abstract Class<Disparity> getDisparityType();

    public int getMinDisparity() {
        return this.minDisparity;
    }

    public int getMaxDisparity() {
        return this.maxDisparity;
    }

    public int getBorderX() {
        return this.radiusX;
    }

    public int getBorderY() {
        return this.radiusY;
    }
}

