/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.ImageSingleBand;

public abstract class DisparitySparseScoreSadRect<ArrayData, Input extends ImageSingleBand> {
    protected int minDisparity;
    protected int maxDisparity;
    protected int rangeDisparity;
    protected int localMaxDisparity;
    protected int radiusX;
    protected int radiusY;
    protected int regionWidth;
    protected int regionHeight;
    protected Input left;
    protected Input right;

    public DisparitySparseScoreSadRect(int minDisparity, int maxDisparity, int radiusX, int radiusY) {
        this.minDisparity = minDisparity;
        this.maxDisparity = maxDisparity;
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.rangeDisparity = maxDisparity - minDisparity;
        this.regionWidth = radiusX * 2 + 1;
        this.regionHeight = radiusY * 2 + 1;
    }

    public void setImages(Input left, Input right) {
        InputSanityCheck.checkSameShape(left, right);
        this.left = left;
        this.right = right;
    }

    public abstract boolean process(int var1, int var2);

    public int getLocalMaxDisparity() {
        return this.localMaxDisparity;
    }

    public int getMinDisparity() {
        return this.minDisparity;
    }

    public int getMaxDisparity() {
        return this.maxDisparity;
    }

    public int getRadiusX() {
        return this.radiusX;
    }

    public int getRadiusY() {
        return this.radiusY;
    }

    public abstract ArrayData getScore();

    public abstract Class<Input> getImageType();
}

