/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.watershed;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.segmentation.watershed.RemoveWatersheds;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import org.ddogleg.struct.CircularQueue_I32;
import org.ddogleg.struct.GrowQueue_I32;

public abstract class WatershedVincentSoille1991 {
    public static final int WSHED = 0;
    public static final int INIT = -1;
    public static final int MASK = -2;
    public static final int MARKER_PIXEL = -1;
    protected GrowQueue_I32[] histogram = new GrowQueue_I32[256];
    protected ImageSInt32 output = new ImageSInt32(1, 1);
    protected ImageSInt32 outputSub = new ImageSInt32();
    protected ImageSInt32 distance = new ImageSInt32(1, 1);
    protected int currentDistance;
    protected int currentLabel;
    protected CircularQueue_I32 fifo = new CircularQueue_I32();
    protected RemoveWatersheds removeWatersheds = new RemoveWatersheds();
    boolean removedWatersheds;

    public WatershedVincentSoille1991() {
        for (int i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = new GrowQueue_I32();
        }
    }

    public void process(ImageUInt8 input) {
        this.removedWatersheds = false;
        this.output.reshape(input.width + 2, input.height + 2);
        this.distance.reshape(input.width + 2, input.height + 2);
        ImageMiscOps.fill((ImageSInt32)this.output, (int)-1);
        ImageMiscOps.fill((ImageSInt32)this.distance, (int)0);
        this.fifo.reset();
        this.sortPixels(input);
        this.currentLabel = 0;
        for (int i = 0; i < this.histogram.length; ++i) {
            int index;
            int j;
            GrowQueue_I32 level = this.histogram[i];
            if (level.size == 0) continue;
            for (j = 0; j < level.size; ++j) {
                index = level.data[j];
                this.output.data[index] = -2;
                this.assignNewToNeighbors(index);
            }
            this.currentDistance = 1;
            this.fifo.add(-1);
            while (true) {
                int p;
                if ((p = this.fifo.popHead()) == -1) {
                    if (this.fifo.isEmpty()) break;
                    this.fifo.add(-1);
                    ++this.currentDistance;
                    p = this.fifo.popHead();
                }
                this.checkNeighborsAssign(p);
            }
            for (j = 0; j < level.size; ++j) {
                index = level.get(j);
                this.distance.data[index] = 0;
                if (this.output.data[index] != -2) continue;
                this.fifo.add(index);
                this.output.data[index] = ++this.currentLabel;
                while (!this.fifo.isEmpty()) {
                    this.checkNeighborsMasks(this.fifo.popHead());
                }
            }
        }
    }

    public void process(ImageUInt8 input, ImageSInt32 seeds) {
        InputSanityCheck.checkSameShape((ImageBase)input, (ImageBase)seeds);
        this.removedWatersheds = false;
        this.output.reshape(input.width + 2, input.height + 2);
        this.distance.reshape(input.width + 2, input.height + 2);
        ImageMiscOps.fill((ImageSInt32)this.output, (int)-1);
        ImageMiscOps.fill((ImageSInt32)this.distance, (int)0);
        this.fifo.reset();
        for (int y = 0; y < seeds.height; ++y) {
            int indexSeeds = seeds.startIndex + y * seeds.stride;
            int indexOut = (y + 1) * this.output.stride + 1;
            int x = 0;
            while (x < seeds.width) {
                int v = seeds.data[indexSeeds];
                if (v > 0) {
                    this.output.data[indexOut] = v;
                }
                ++x;
                ++indexSeeds;
                ++indexOut;
            }
        }
        this.sortPixels(input);
        for (int i = 0; i < this.histogram.length; ++i) {
            GrowQueue_I32 level = this.histogram[i];
            if (level.size == 0) continue;
            for (int j = 0; j < level.size; ++j) {
                int index = level.data[j];
                if (this.output.data[index] != -1) continue;
                this.output.data[index] = -2;
                this.assignNewToNeighbors(index);
            }
            this.currentDistance = 1;
            this.fifo.add(-1);
            while (true) {
                int p;
                if ((p = this.fifo.popHead()) == -1) {
                    if (this.fifo.isEmpty()) break;
                    this.fifo.add(-1);
                    ++this.currentDistance;
                    p = this.fifo.popHead();
                }
                this.checkNeighborsAssign(p);
            }
            ImageMiscOps.fill((ImageSInt32)this.distance, (int)0);
        }
    }

    protected abstract void assignNewToNeighbors(int var1);

    protected abstract void checkNeighborsAssign(int var1);

    protected void handleNeighborAssign(int indexTarget, int indexNeighbor) {
        int regionNeighbor = this.output.data[indexNeighbor];
        int distanceNeighbor = this.distance.data[indexNeighbor];
        if (regionNeighbor >= 0 && distanceNeighbor < this.currentDistance) {
            int regionTarget = this.output.data[indexTarget];
            if (regionNeighbor > 0) {
                if (regionTarget < 0) {
                    this.output.data[indexTarget] = regionNeighbor;
                } else if (regionTarget == 0) {
                    if (distanceNeighbor + 1 < this.currentDistance) {
                        this.output.data[indexTarget] = regionNeighbor;
                    }
                } else if (regionTarget != regionNeighbor) {
                    this.output.data[indexTarget] = 0;
                }
            } else if (regionTarget == -2) {
                this.output.data[indexTarget] = 0;
            }
        } else if (regionNeighbor == -2 && distanceNeighbor == 0) {
            this.distance.data[indexNeighbor] = this.currentDistance + 1;
            this.fifo.add(indexNeighbor);
        }
    }

    protected abstract void checkNeighborsMasks(int var1);

    protected void checkMask(int index) {
        if (this.output.data[index] == -2) {
            this.output.data[index] = this.currentLabel;
            this.fifo.add(index);
        }
    }

    protected void sortPixels(ImageUInt8 input) {
        for (int i = 0; i < this.histogram.length; ++i) {
            this.histogram[i].reset();
        }
        for (int y = 0; y < input.height; ++y) {
            int index = input.startIndex + y * input.stride;
            int indexOut = (y + 1) * this.output.stride + 1;
            int x = 0;
            while (x < input.width) {
                int value = input.data[index] & 0xFF;
                this.histogram[value].add(indexOut);
                ++x;
                ++index;
                ++indexOut;
            }
        }
    }

    public ImageSInt32 getOutput() {
        this.output.subimage(1, 1, this.output.width - 1, this.output.height - 1, (ImageSingleBand)this.outputSub);
        return this.outputSub;
    }

    public ImageSInt32 getOutputBorder() {
        return this.output;
    }

    public void removeWatersheds() {
        this.removedWatersheds = true;
        this.removeWatersheds.remove(this.output);
    }

    public int getTotalRegions() {
        return this.removedWatersheds ? this.currentLabel : this.currentLabel + 1;
    }

    public static class Connect8
    extends WatershedVincentSoille1991 {
        @Override
        protected void assignNewToNeighbors(int index) {
            if (this.output.data[index + 1] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            } else if (this.output.data[index - 1] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            } else if (this.output.data[index + this.output.stride] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            } else if (this.output.data[index - this.output.stride] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            } else if (this.output.data[index + 1 + this.output.stride] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            } else if (this.output.data[index - 1 + this.output.stride] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            } else if (this.output.data[index + 1 - this.output.stride] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            } else if (this.output.data[index - 1 - this.output.stride] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            }
        }

        @Override
        protected void checkNeighborsAssign(int index) {
            this.handleNeighborAssign(index, index + 1);
            this.handleNeighborAssign(index, index - 1);
            this.handleNeighborAssign(index, index + this.output.stride);
            this.handleNeighborAssign(index, index - this.output.stride);
            this.handleNeighborAssign(index, index + 1 + this.output.stride);
            this.handleNeighborAssign(index, index - 1 + this.output.stride);
            this.handleNeighborAssign(index, index + 1 - this.output.stride);
            this.handleNeighborAssign(index, index - 1 - this.output.stride);
        }

        @Override
        protected void checkNeighborsMasks(int index) {
            this.checkMask(index + 1);
            this.checkMask(index - 1);
            this.checkMask(index + this.output.stride);
            this.checkMask(index - this.output.stride);
            this.checkMask(index + 1 + this.output.stride);
            this.checkMask(index - 1 + this.output.stride);
            this.checkMask(index + 1 - this.output.stride);
            this.checkMask(index - 1 - this.output.stride);
        }
    }

    public static class Connect4
    extends WatershedVincentSoille1991 {
        @Override
        protected void assignNewToNeighbors(int index) {
            if (this.output.data[index + 1] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            } else if (this.output.data[index - 1] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            } else if (this.output.data[index + this.output.stride] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            } else if (this.output.data[index - this.output.stride] >= 0) {
                this.distance.data[index] = 1;
                this.fifo.add(index);
            }
        }

        @Override
        protected void checkNeighborsAssign(int index) {
            this.handleNeighborAssign(index, index + 1);
            this.handleNeighborAssign(index, index - 1);
            this.handleNeighborAssign(index, index + this.output.stride);
            this.handleNeighborAssign(index, index - this.output.stride);
        }

        @Override
        protected void checkNeighborsMasks(int index) {
            this.checkMask(index + 1);
            this.checkMask(index - 1);
            this.checkMask(index + this.output.stride);
            this.checkMask(index - this.output.stride);
        }
    }
}

