/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.transform.wavelet.impl;

import boofcv.abst.transform.wavelet.WaveletTransform;
import boofcv.alg.transform.wavelet.UtilWavelet;
import boofcv.alg.transform.wavelet.WaveletTransformOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef_I32;

public class WaveletTransformInt<T extends ImageInteger>
implements WaveletTransform<T, ImageSInt32, WlCoef_I32> {
    ImageSInt32 copyInput = new ImageSInt32(1, 1);
    ImageSInt32 copyOutput = new ImageSInt32(1, 1);
    ImageSInt32 temp = new ImageSInt32(1, 1);
    WaveletDescription<WlCoef_I32> desc;
    int numLevels;
    Class<T> inputType;
    int minPixelValue;
    int maxPixelValue;

    public WaveletTransformInt(WaveletDescription<WlCoef_I32> desc, int numLevels, int minPixelValue, int maxPixelValue, Class<T> inputType) {
        this.desc = desc;
        this.numLevels = numLevels;
        this.inputType = inputType;
        this.minPixelValue = minPixelValue;
        this.maxPixelValue = maxPixelValue;
    }

    @Override
    public ImageSInt32 transform(T original, ImageSInt32 transformed) {
        if (transformed == null) {
            ImageDimension d = UtilWavelet.transformDimension(original, this.numLevels);
            transformed = new ImageSInt32(d.width, d.height);
        }
        this.temp.reshape(transformed.width, transformed.height);
        this.copyInput.reshape(((ImageInteger)original).width, ((ImageInteger)original).height);
        if (((ImageInteger)original).getDataType().getDataType() == Integer.TYPE) {
            this.copyInput.setTo((ImageSInt32)original);
        } else {
            GeneralizedImageOps.convert(original, this.copyInput);
        }
        WaveletTransformOps.transformN(this.desc, this.copyInput, transformed, this.temp, this.numLevels);
        return transformed;
    }

    @Override
    public void invert(ImageSInt32 transformed, T original) {
        this.copyInput.reshape(transformed.width, transformed.height);
        this.temp.reshape(transformed.width, transformed.height);
        this.copyInput.setTo(transformed);
        if (((ImageInteger)original).getDataType().getDataType() == Integer.TYPE) {
            WaveletTransformOps.inverseN(this.desc, this.copyInput, (ImageSInt32)original, this.temp, this.numLevels, this.minPixelValue, this.maxPixelValue);
        } else {
            this.copyOutput.reshape(((ImageInteger)original).width, ((ImageInteger)original).height);
            WaveletTransformOps.inverseN(this.desc, this.copyInput, this.copyOutput, this.temp, this.numLevels, this.minPixelValue, this.maxPixelValue);
            GeneralizedImageOps.convert(this.copyOutput, original);
        }
    }

    @Override
    public int getLevels() {
        return this.numLevels;
    }

    @Override
    public BorderType getBorderType() {
        return UtilWavelet.convertToType(this.desc.getBorder());
    }

    @Override
    public WaveletDescription<WlCoef_I32> getDescription() {
        return this.desc;
    }

    @Override
    public Class<T> getOriginalType() {
        return this.inputType;
    }
}

