/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.color.ColorXyz;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class ColorLab {
    public static final double epsilon = 0.008856;
    public static final double kappa = 903.3;
    public static final double Xr = 0.950456;
    public static final double Yr = 1.0;
    public static final double Zr = 1.088754;
    public static final float epsilon_f = 0.008856f;
    public static final float kappa_f = 903.3f;
    public static final float Xr_f = 0.950456f;
    public static final float Yr_f = 1.0f;
    public static final float Zr_f = 1.088754f;

    public static void srgbToLab(double r, double g, double b, double[] lab) {
        ColorXyz.srgbToXyz(r, g, b, lab);
        double X = lab[0];
        double Y = lab[1];
        double Z = lab[2];
        double xr = X / 0.950456;
        double yr = Y / 1.0;
        double zr = Z / 1.088754;
        double fx = xr > 0.008856 ? Math.pow(xr, 0.3333333333333333) : (903.3 * xr + 16.0) / 116.0;
        double fy = yr > 0.008856 ? Math.pow(yr, 0.3333333333333333) : (903.3 * yr + 16.0) / 116.0;
        double fz = zr > 0.008856 ? Math.pow(zr, 0.3333333333333333) : (903.3 * zr + 16.0) / 116.0;
        lab[0] = 116.0 * fy - 16.0;
        lab[1] = 500.0 * (fx - fy);
        lab[2] = 200.0 * (fy - fz);
    }

    public static void srgbToLab(float r, float g, float b, float[] lab) {
        ColorXyz.srgbToXyz(r, g, b, lab);
        float X = lab[0];
        float Y = lab[1];
        float Z = lab[2];
        float xr = X / 0.950456f;
        float yr = Y / 1.0f;
        float zr = Z / 1.088754f;
        float fx = xr > 0.008856f ? (float)Math.pow(xr, 0.3333333432674408) : (903.3f * xr + 16.0f) / 116.0f;
        float fy = yr > 0.008856f ? (float)Math.pow(yr, 0.3333333333333333) : (903.3f * yr + 16.0f) / 116.0f;
        float fz = zr > 0.008856f ? (float)Math.pow(zr, 0.3333333333333333) : (903.3f * zr + 16.0f) / 116.0f;
        lab[0] = 116.0f * fy - 16.0f;
        lab[1] = 500.0f * (fx - fy);
        lab[2] = 200.0f * (fy - fz);
    }

    public static void rgbToLab_U8(MultiSpectral<ImageUInt8> rgb, MultiSpectral<ImageFloat32> lab) {
        InputSanityCheck.checkSameShape(lab, rgb);
        ImageUInt8 R = rgb.getBand(0);
        ImageUInt8 G = rgb.getBand(1);
        ImageUInt8 B = rgb.getBand(2);
        ImageFloat32 L_ = lab.getBand(0);
        ImageFloat32 A_ = lab.getBand(1);
        ImageFloat32 B_ = lab.getBand(2);
        for (int row = 0; row < lab.height; ++row) {
            int indexLab = lab.startIndex + row * lab.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < lab.width) {
                float r = (float)(R.data[indexRgb] & 0xFF) / 255.0f;
                float g = (float)(G.data[indexRgb] & 0xFF) / 255.0f;
                float b = (float)(B.data[indexRgb] & 0xFF) / 255.0f;
                float X = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                float Y = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                float Z = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                float xr = X / 0.950456f;
                float yr = Y / 1.0f;
                float zr = Z / 1.088754f;
                float fx = xr > 0.008856f ? (float)Math.pow(xr, 0.3333333432674408) : (903.3f * xr + 16.0f) / 116.0f;
                float fy = yr > 0.008856f ? (float)Math.pow(yr, 0.3333333333333333) : (903.3f * yr + 16.0f) / 116.0f;
                float fz = zr > 0.008856f ? (float)Math.pow(zr, 0.3333333333333333) : (903.3f * zr + 16.0f) / 116.0f;
                L_.data[indexLab] = 116.0f * fy - 16.0f;
                A_.data[indexLab] = 500.0f * (fx - fy);
                B_.data[indexLab] = 200.0f * (fy - fz);
                ++col;
                ++indexLab;
                ++indexRgb;
            }
        }
    }

    public static void rgbToLab_F32(MultiSpectral<ImageFloat32> rgb, MultiSpectral<ImageFloat32> lab) {
        InputSanityCheck.checkSameShape(lab, rgb);
        ImageFloat32 R = rgb.getBand(0);
        ImageFloat32 G = rgb.getBand(1);
        ImageFloat32 B = rgb.getBand(2);
        ImageFloat32 L_ = lab.getBand(0);
        ImageFloat32 A_ = lab.getBand(1);
        ImageFloat32 B_ = lab.getBand(2);
        for (int row = 0; row < lab.height; ++row) {
            int indexLab = lab.startIndex + row * lab.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < lab.width) {
                float r = R.data[indexRgb] / 255.0f;
                float g = G.data[indexRgb] / 255.0f;
                float b = B.data[indexRgb] / 255.0f;
                float X = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                float Y = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                float Z = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                float xr = X / 0.950456f;
                float yr = Y / 1.0f;
                float zr = Z / 1.088754f;
                float fx = xr > 0.008856f ? (float)Math.pow(xr, 0.3333333432674408) : (903.3f * xr + 16.0f) / 116.0f;
                float fy = yr > 0.008856f ? (float)Math.pow(yr, 0.3333333333333333) : (903.3f * yr + 16.0f) / 116.0f;
                float fz = zr > 0.008856f ? (float)Math.pow(zr, 0.3333333333333333) : (903.3f * zr + 16.0f) / 116.0f;
                L_.data[indexLab] = 116.0f * fy - 16.0f;
                A_.data[indexLab] = 500.0f * (fx - fy);
                B_.data[indexLab] = 200.0f * (fy - fz);
                ++col;
                ++indexLab;
                ++indexRgb;
            }
        }
    }
}

