/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.enhance;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.enhance.EnhanceImageOps;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class GEnhanceImageOps {
    public static <T extends ImageSingleBand> void applyTransform(T input, int[] transform, int minValue, T output) {
        InputSanityCheck.checkSameShape(input, output);
        if (input instanceof ImageUInt8) {
            EnhanceImageOps.applyTransform((ImageUInt8)input, transform, (ImageUInt8)output);
        } else if (input instanceof ImageSInt8) {
            EnhanceImageOps.applyTransform((ImageSInt8)input, transform, minValue, (ImageSInt8)output);
        } else if (input instanceof ImageUInt16) {
            EnhanceImageOps.applyTransform((ImageUInt16)input, transform, (ImageUInt16)output);
        } else if (input instanceof ImageSInt16) {
            EnhanceImageOps.applyTransform((ImageSInt16)input, transform, minValue, (ImageSInt16)output);
        } else if (input instanceof ImageSInt32) {
            EnhanceImageOps.applyTransform((ImageSInt32)input, transform, minValue, (ImageSInt32)output);
        } else {
            throw new IllegalArgumentException("Image type not supported. " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void equalizeLocal(T input, int radius, T output, int[] histogram, int[] transform) {
        if (input instanceof ImageUInt8) {
            EnhanceImageOps.equalizeLocal((ImageUInt8)input, radius, (ImageUInt8)output, histogram, transform);
        } else if (input instanceof ImageUInt16) {
            EnhanceImageOps.equalizeLocal((ImageUInt16)input, radius, (ImageUInt16)output, histogram, transform);
        } else {
            throw new IllegalArgumentException("Unsupported image type " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void sharpen4(T input, T output) {
        if (input instanceof ImageUInt8) {
            EnhanceImageOps.sharpen4((ImageUInt8)input, (ImageUInt8)output);
        } else if (input instanceof ImageFloat32) {
            EnhanceImageOps.sharpen4((ImageFloat32)input, (ImageFloat32)output);
        } else {
            throw new IllegalArgumentException("Image type not supported. " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageSingleBand> void sharpen8(T input, T output) {
        if (input instanceof ImageUInt8) {
            EnhanceImageOps.sharpen8((ImageUInt8)input, (ImageUInt8)output);
        } else if (input instanceof ImageFloat32) {
            EnhanceImageOps.sharpen8((ImageFloat32)input, (ImageFloat32)output);
        } else {
            throw new IllegalArgumentException("Image type not supported. " + input.getClass().getSimpleName());
        }
    }
}

