/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class ConvolveImageStandardSparse {
    public static float convolve(Kernel1D_F32 horizontal, Kernel1D_F32 vertical, ImageFloat32 input, int c_x, int c_y, float[] storage) {
        int widthH = horizontal.getWidth();
        int widthV = vertical.getWidth();
        int offsetH = horizontal.getOffset();
        int offsetV = vertical.getOffset();
        for (int i = 0; i < widthV; ++i) {
            int indexImg = input.startIndex + (i + c_y - offsetV) * input.stride + c_x - offsetH;
            float total = 0.0f;
            int j = 0;
            while (j < widthH) {
                total += input.data[indexImg] * horizontal.data[j];
                ++j;
                ++indexImg;
            }
            storage[i] = total;
        }
        float total = 0.0f;
        for (int i = 0; i < widthV; ++i) {
            total += storage[i] * vertical.data[i];
        }
        return total;
    }

    public static int convolve(Kernel1D_I32 horizontal, Kernel1D_I32 vertical, ImageUInt8 input, int c_x, int c_y, int[] storage) {
        int widthH = horizontal.getWidth();
        int widthV = vertical.getWidth();
        int offsetH = horizontal.getOffset();
        int offsetV = vertical.getOffset();
        for (int i = 0; i < widthV; ++i) {
            int indexImg = input.startIndex + (i + c_y - offsetV) * input.stride + c_x - offsetH;
            int total = 0;
            int j = 0;
            while (j < widthH) {
                total += (input.data[indexImg] & 0xFF) * horizontal.data[j];
                ++j;
                ++indexImg;
            }
            storage[i] = total;
        }
        int total = 0;
        for (int i = 0; i < widthV; ++i) {
            total += storage[i] * vertical.data[i];
        }
        return total;
    }

    public static int convolve(Kernel1D_I32 horizontal, Kernel1D_I32 vertical, ImageUInt8 input, int c_x, int c_y, int[] storage, int divisorHorizontal, int divisorVertical) {
        int widthH = horizontal.getWidth();
        int widthV = vertical.getWidth();
        int offsetH = horizontal.getOffset();
        int offsetV = vertical.getOffset();
        int halfHorizontal = divisorHorizontal / 2;
        for (int i = 0; i < widthV; ++i) {
            int indexImg = input.startIndex + (i + c_y - offsetV) * input.stride + c_x - offsetH;
            int total = 0;
            int j = 0;
            while (j < widthH) {
                total += (input.data[indexImg] & 0xFF) * horizontal.data[j];
                ++j;
                ++indexImg;
            }
            storage[i] = (total + halfHorizontal) / divisorHorizontal;
        }
        int total = 0;
        for (int i = 0; i < widthV; ++i) {
            total += storage[i] * vertical.data[i];
        }
        return (total + divisorVertical / 2) / divisorVertical;
    }

    public static int convolve(Kernel1D_I32 horizontal, Kernel1D_I32 vertical, ImageSInt16 input, int c_x, int c_y, int[] storage) {
        int widthH = horizontal.getWidth();
        int widthV = vertical.getWidth();
        int offsetH = horizontal.getOffset();
        int offsetV = vertical.getOffset();
        for (int i = 0; i < widthV; ++i) {
            int indexImg = input.startIndex + (i + c_y - offsetV) * input.stride + c_x - offsetH;
            int total = 0;
            int j = 0;
            while (j < widthH) {
                total += input.data[indexImg] * horizontal.data[j];
                ++j;
                ++indexImg;
            }
            storage[i] = total;
        }
        int total = 0;
        for (int i = 0; i < widthV; ++i) {
            total += storage[i] * vertical.data[i];
        }
        return total;
    }

    public static int convolve(Kernel1D_I32 horizontal, Kernel1D_I32 vertical, ImageSInt16 input, int c_x, int c_y, int[] storage, int divisorHorizontal, int divisorVertical) {
        int widthH = horizontal.getWidth();
        int widthV = vertical.getWidth();
        int offsetH = horizontal.getOffset();
        int offsetV = vertical.getOffset();
        int halfHorizontal = divisorHorizontal / 2;
        for (int i = 0; i < widthV; ++i) {
            int indexImg = input.startIndex + (i + c_y - offsetV) * input.stride + c_x - offsetH;
            int total = 0;
            int j = 0;
            while (j < widthH) {
                total += input.data[indexImg] * horizontal.data[j];
                ++j;
                ++indexImg;
            }
            storage[i] = (total + halfHorizontal) / divisorHorizontal;
        }
        int total = 0;
        for (int i = 0; i < widthV; ++i) {
            total += storage[i] * vertical.data[i];
        }
        return (total + divisorVertical / 2) / divisorVertical;
    }
}

