/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.noborder;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class ImplConvolveMean {
    public static void horizontal(ImageUInt8 input, ImageInt8 output, int radius) {
        int kernelWidth;
        int divisor = kernelWidth = radius * 2 + 1;
        int halfDivisor = divisor / 2;
        for (int y = 0; y < input.height; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn] & 0xFF;
            }
            output.data[indexOut++] = (byte)((total + halfDivisor) / divisor);
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth] & 0xFF;
                output.data[indexOut++] = (byte)(((total += input.data[indexIn] & 0xFF) + halfDivisor) / divisor);
                ++indexIn;
            }
        }
    }

    public static void vertical(ImageUInt8 input, ImageInt8 output, int radius) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        int divisor = kernelWidth;
        int halfDivisor = divisor / 2;
        int[] totals = new int[input.width];
        for (int x = 0; x < input.width; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            int total = 0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn] & 0xFF;
            }
            totals[x] = total;
            output.data[indexOut] = (byte)((total + halfDivisor) / divisor);
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride;
            indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                int total = totals[x] - (input.data[indexIn - backStep] & 0xFF);
                totals[x] = total += input.data[indexIn] & 0xFF;
                output.data[indexOut] = (byte)((total + halfDivisor) / divisor);
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(ImageSInt16 input, ImageInt16 output, int radius) {
        int kernelWidth;
        int divisor = kernelWidth = radius * 2 + 1;
        int halfDivisor = divisor / 2;
        for (int y = 0; y < input.height; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            int total = 0;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = (short)((total + halfDivisor) / divisor);
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = (short)(((total += input.data[indexIn]) + halfDivisor) / divisor);
                ++indexIn;
            }
        }
    }

    public static void vertical(ImageSInt16 input, ImageInt16 output, int radius) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        int divisor = kernelWidth;
        int halfDivisor = divisor / 2;
        int[] totals = new int[input.width];
        for (int x = 0; x < input.width; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            int total = 0;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn];
            }
            totals[x] = total;
            output.data[indexOut] = (short)((total + halfDivisor) / divisor);
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride;
            indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                int total = totals[x] - input.data[indexIn - backStep];
                totals[x] = total += input.data[indexIn];
                output.data[indexOut] = (short)((total + halfDivisor) / divisor);
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void horizontal(ImageFloat32 input, ImageFloat32 output, int radius) {
        int kernelWidth = radius * 2 + 1;
        float divisor = kernelWidth;
        for (int y = 0; y < input.height; ++y) {
            int indexIn;
            int indexOut = output.startIndex + output.stride * y + radius;
            float total = 0.0f;
            int indexEnd = indexIn + kernelWidth;
            for (indexIn = input.startIndex + input.stride * y; indexIn < indexEnd; ++indexIn) {
                total += input.data[indexIn];
            }
            output.data[indexOut++] = total / divisor;
            indexEnd = indexIn + input.width - kernelWidth;
            while (indexIn < indexEnd) {
                total -= input.data[indexIn - kernelWidth];
                output.data[indexOut++] = (total += input.data[indexIn]) / divisor;
                ++indexIn;
            }
        }
    }

    public static void vertical(ImageFloat32 input, ImageFloat32 output, int radius) {
        int indexIn;
        int indexOut;
        int kernelWidth = radius * 2 + 1;
        int backStep = kernelWidth * input.stride;
        float divisor = kernelWidth;
        float[] totals = new float[input.width];
        for (int x = 0; x < input.width; ++x) {
            indexOut = output.startIndex + output.stride * radius + x;
            float total = 0.0f;
            int indexEnd = indexIn + input.stride * kernelWidth;
            for (indexIn = input.startIndex + x; indexIn < indexEnd; indexIn += input.stride) {
                total += input.data[indexIn];
            }
            totals[x] = total;
            output.data[indexOut] = total / divisor;
        }
        for (int y = radius + 1; y < output.height - radius; ++y) {
            indexIn = input.startIndex + (y + radius) * input.stride;
            indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < input.width) {
                float total = totals[x] - input.data[indexIn - backStep];
                totals[x] = total += input.data[indexIn];
                output.data[indexOut] = total / divisor;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }
}

