/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.NearestNeighborPixel;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;

public class NearestNeighborPixel_U8
extends NearestNeighborPixel<ImageUInt8> {
    private byte[] data;

    public NearestNeighborPixel_U8() {
    }

    public NearestNeighborPixel_U8(ImageUInt8 orig) {
        this.setImage(orig);
    }

    @Override
    public void setImage(ImageUInt8 image) {
        this.orig = image;
        this.data = ((ImageUInt8)this.orig).data;
        this.stride = ((ImageUInt8)this.orig).getStride();
        this.width = ((ImageUInt8)this.orig).getWidth();
        this.height = ((ImageUInt8)this.orig).getHeight();
    }

    @Override
    public float get_fast(float x, float y) {
        return this.data[((ImageUInt8)this.orig).startIndex + (int)y * this.stride + (int)x] & 0xFF;
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            throw new IllegalArgumentException("Point is outside of the image");
        }
        int xx = (int)x;
        int yy = (int)y;
        return this.data[((ImageUInt8)this.orig).startIndex + yy * this.stride + xx] & 0xFF;
    }

    @Override
    public ImageType<ImageUInt8> getImageType() {
        return ImageType.single(ImageUInt8.class);
    }
}

