/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.ii;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.transform.ii.IntegralKernel;
import boofcv.alg.transform.ii.impl.ImplIntegralImageOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageUInt8;

public class IntegralImageOps {
    public static ImageFloat32 transform(ImageFloat32 input, ImageFloat32 transformed) {
        transformed = InputSanityCheck.checkDeclare(input, transformed);
        ImplIntegralImageOps.transform(input, transformed);
        return transformed;
    }

    public static ImageFloat64 transform(ImageFloat64 input, ImageFloat64 transformed) {
        transformed = InputSanityCheck.checkDeclare(input, transformed);
        ImplIntegralImageOps.transform(input, transformed);
        return transformed;
    }

    public static ImageSInt32 transform(ImageUInt8 input, ImageSInt32 transformed) {
        transformed = InputSanityCheck.checkDeclare(input, transformed, ImageSInt32.class);
        ImplIntegralImageOps.transform(input, transformed);
        return transformed;
    }

    public static ImageSInt32 transform(ImageSInt32 input, ImageSInt32 transformed) {
        transformed = InputSanityCheck.checkDeclare(input, transformed, ImageSInt32.class);
        ImplIntegralImageOps.transform(input, transformed);
        return transformed;
    }

    public static ImageSInt64 transform(ImageSInt64 input, ImageSInt64 transformed) {
        transformed = InputSanityCheck.checkDeclare(input, transformed, ImageSInt64.class);
        ImplIntegralImageOps.transform(input, transformed);
        return transformed;
    }

    public static ImageFloat32 convolve(ImageFloat32 integral, IntegralKernel kernel, ImageFloat32 output) {
        output = InputSanityCheck.checkDeclare(integral, output);
        ImplIntegralImageOps.convolve(integral, kernel, output);
        return output;
    }

    public static ImageFloat64 convolve(ImageFloat64 integral, IntegralKernel kernel, ImageFloat64 output) {
        output = InputSanityCheck.checkDeclare(integral, output);
        ImplIntegralImageOps.convolve(integral, kernel, output);
        return output;
    }

    public static ImageSInt32 convolve(ImageSInt32 integral, IntegralKernel kernel, ImageSInt32 output) {
        output = InputSanityCheck.checkDeclare(integral, output);
        ImplIntegralImageOps.convolve(integral, kernel, output);
        return output;
    }

    public static ImageSInt64 convolve(ImageSInt64 integral, IntegralKernel kernel, ImageSInt64 output) {
        output = InputSanityCheck.checkDeclare(integral, output);
        ImplIntegralImageOps.convolve(integral, kernel, output);
        return output;
    }

    public static ImageFloat32 convolveBorder(ImageFloat32 integral, IntegralKernel kernel, ImageFloat32 output, int borderX, int borderY) {
        output = InputSanityCheck.checkDeclare(integral, output);
        ImplIntegralImageOps.convolveBorder(integral, kernel, output, borderX, borderY);
        return output;
    }

    public static ImageFloat64 convolveBorder(ImageFloat64 integral, IntegralKernel kernel, ImageFloat64 output, int borderX, int borderY) {
        output = InputSanityCheck.checkDeclare(integral, output);
        ImplIntegralImageOps.convolveBorder(integral, kernel, output, borderX, borderY);
        return output;
    }

    public static ImageSInt32 convolveBorder(ImageSInt32 integral, IntegralKernel kernel, ImageSInt32 output, int borderX, int borderY) {
        output = InputSanityCheck.checkDeclare(integral, output);
        ImplIntegralImageOps.convolveBorder(integral, kernel, output, borderX, borderY);
        return output;
    }

    public static ImageSInt64 convolveBorder(ImageSInt64 integral, IntegralKernel kernel, ImageSInt64 output, int borderX, int borderY) {
        output = InputSanityCheck.checkDeclare(integral, output);
        ImplIntegralImageOps.convolveBorder(integral, kernel, output, borderX, borderY);
        return output;
    }

    public static float convolveSparse(ImageFloat32 integral, IntegralKernel kernel, int x, int y) {
        return ImplIntegralImageOps.convolveSparse(integral, kernel, x, y);
    }

    public static double convolveSparse(ImageFloat64 integral, IntegralKernel kernel, int x, int y) {
        return ImplIntegralImageOps.convolveSparse(integral, kernel, x, y);
    }

    public static int convolveSparse(ImageSInt32 integral, IntegralKernel kernel, int x, int y) {
        return ImplIntegralImageOps.convolveSparse(integral, kernel, x, y);
    }

    public static long convolveSparse(ImageSInt64 integral, IntegralKernel kernel, int x, int y) {
        return ImplIntegralImageOps.convolveSparse(integral, kernel, x, y);
    }

    public static double block_unsafe(ImageFloat64 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_unsafe(integral, x0, y0, x1, y1);
    }

    public static float block_unsafe(ImageFloat32 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_unsafe(integral, x0, y0, x1, y1);
    }

    public static int block_unsafe(ImageSInt32 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_unsafe(integral, x0, y0, x1, y1);
    }

    public static long block_unsafe(ImageSInt64 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_unsafe(integral, x0, y0, x1, y1);
    }

    public static float block_zero(ImageFloat32 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_zero(integral, x0, y0, x1, y1);
    }

    public static double block_zero(ImageFloat64 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_zero(integral, x0, y0, x1, y1);
    }

    public static int block_zero(ImageSInt32 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_zero(integral, x0, y0, x1, y1);
    }

    public static long block_zero(ImageSInt64 integral, int x0, int y0, int x1, int y1) {
        return ImplIntegralImageOps.block_zero(integral, x0, y0, x1, y1);
    }

    public static void print(IntegralKernel kernel) {
        int x0 = 0;
        int x1 = 0;
        int y0 = 0;
        int y1 = 0;
        for (ImageRectangle k : kernel.blocks) {
            if (k.x0 < x0) {
                x0 = k.x0;
            }
            if (k.y0 < y0) {
                y0 = k.y0;
            }
            if (k.x1 > x1) {
                x1 = k.x1;
            }
            if (k.y1 <= y1) continue;
            y1 = k.y1;
        }
        int w = x1 - x0;
        int h = y1 - y0;
        int[] sum = new int[w * h];
        for (int i = 0; i < kernel.blocks.length; ++i) {
            ImageRectangle r = kernel.blocks[i];
            int value = kernel.scales[i];
            for (int y = r.y0; y < r.y1; ++y) {
                int yy = y - y0;
                for (int x = r.x0; x < r.x1; ++x) {
                    int xx = x - x0;
                    int n = yy * w + xx;
                    sum[n] = sum[n] + value;
                }
            }
        }
        System.out.println("IntegralKernel: TL = (" + (x0 + 1) + "," + (y0 + 1) + ") BR=(" + x1 + "," + y1 + ")");
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                System.out.printf("%4d ", sum[y * w + x]);
            }
            System.out.println();
        }
    }

    public static boolean isInBounds(int x, int y, IntegralKernel kernel, int width, int height) {
        for (ImageRectangle r : kernel.blocks) {
            if (x + r.x0 < 0 || y + r.y0 < 0) {
                return false;
            }
            if (x + r.x1 < width && y + r.y1 < height) continue;
            return false;
        }
        return true;
    }
}

